/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.lm.applications.saleinvoices;

import com.suncode.lm.categories.Categories;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class AttachInvoice {
    public static Logger log = Logger.getLogger(AttachInvoice.class);
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("attachinvoice-app")).name("attachinvoice-app.name")).description("attachinvoice-app.desc")).category(new Category[]{Categories.CLIENT})).icon((Icon)SilkIconPack.APPLICATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ApplicationContext applicationContext, ActivityContextMap activityContext) throws Exception {
        String sProcessId = applicationContext.getProcessId();
        String sActivityId = applicationContext.getActivityId();
        Map activityContextMap = null;
        Map processContextMap = null;
        String sProcessName = "";
        ProcessService processService = ServiceFactory.getProcessService();
        ActivityService activityService = ServiceFactory.getActivityService();
        try {
            activityContextMap = activityService.getActivityContext(sProcessId, sActivityId);
            processContextMap = processService.getProcessContext(sProcessId);
            String sAttachCancelledInvoice = SystemProperties.getString((String)"AttachCancelledInvoice");
            log.debug((Object)("sProcessId" + sProcessId + " sActivityId:" + sActivityId));
            if (!StringUtils.isBlank((CharSequence)sAttachCancelledInvoice) && sAttachCancelledInvoice.compareToIgnoreCase("YES") == 0) {
                String nr_faktury = (String)activityContextMap.get("nr_faktury");
                nr_faktury = nr_faktury.replaceAll("_ANULOWANY", "");
                String nip = (String)activityContextMap.get("nip");
                String data_wystawienia = (String)activityContextMap.get("data_wystawienia");
                log.debug((Object)("nr_faktury:" + nr_faktury + ", nip:" + nip + ", data_wystawienia:" + data_wystawienia));
                if (StringUtils.isBlank((CharSequence)nr_faktury) || StringUtils.isBlank((CharSequence)nip)) {
                    log.debug((Object)"Nr faktury i nip nie mog\u0105 by\u0107 puste");
                    activityContextMap.put("Action", "weryfikacja");
                    processContextMap.put("Action", "weryfikacja");
                    AttachInvoice.addCommentToActivity(sProcessId, sActivityId, "admin", "Nr faktury i nip nie mog\u0105 by\u0107 puste");
                    return;
                }
                SQLFinder finder = FinderFactory.getSQLFinder();
                SQLBuilder builder = new SQLBuilder();
                String sql = "select distinct ac.processid as processid, ac.id as activityid from pm_idx_proces_fakt pf join activities ac on(pf.processid=ac.processid) where ac.activitydefinitionid='weryfikacja_danych_faktury'  and  nr_faktury=:nr_faktury and nip=:nip  and ac.processid!=:processid";
                builder.setQuery(sql);
                builder.addScalar("activityid", (Type)StandardBasicTypes.STRING);
                builder.addScalar("processid", (Type)StandardBasicTypes.STRING);
                builder.setParameter("nr_faktury", (Object)nr_faktury);
                builder.setParameter("nip", (Object)nip);
                builder.setParameter("processid", (Object)sProcessId);
                List data = finder.find(builder);
                if (data.size() == 0) {
                    log.debug((Object)("Nie znaleziono innego procesu faktur dla nr_faktury:" + nr_faktury + ", nip:" + nip));
                    activityContextMap.put("Action", "weryfikacja");
                    processContextMap.put("Action", "weryfikacja");
                    AttachInvoice.addCommentToActivity(sProcessId, sActivityId, "admin", "Nie znaleziono innego procesu faktur dla nr_faktury:" + nr_faktury + ", nip:" + nip);
                    return;
                }
                if (data.size() > 5) {
                    log.debug((Object)("Znalezionio kilka proces\u00f3w faktur dla nr_faktury:" + nr_faktury + ", nip:" + nip));
                    activityContextMap.put("Action", "weryfikacja");
                    processContextMap.put("Action", "weryfikacja");
                    AttachInvoice.addCommentToActivity(sProcessId, sActivityId, "admin", "Znalezionio kilka proces\u00f3w faktur dla nr_faktury:" + nr_faktury + ", nip:" + nip);
                    return;
                }
                for (int i = 0; i < data.size(); ++i) {
                    String processid = ((Map)data.get(i)).get("processid").toString();
                    String activityid = ((Map)data.get(i)).get("activityid").toString();
                    DocumentFinder documentFinder = FinderFactory.getDocumentFinder();
                    List wf = documentFinder.getDocumentsFromActivity(sProcessId, sActivityId, new String[0]);
                    for (WfDocument doc : wf) {
                        DocumentClass documentClass = (DocumentClass)this.documentClassService.get((Serializable)doc.getDocumentClassId());
                        if (documentClass.getName().compareToIgnoreCase("Faktury") != 0) continue;
                        log.debug((Object)("Pod\u0142\u0105czanie dokumentu: " + doc.getFile().getFileName() + " do procesu, processid: " + processid + ", activityid:" + activityid));
                        this.documentService.attachDocumentToProcess(doc, "admin", processid, activityid);
                        sProcessName = processService.getProcess(processid, new String[0]).getName();
                        AttachInvoice.addCommentToActivity(sProcessId, sActivityId, "admin", "Pod\u0142\u0105czono dokument: " + doc.getFile().getFileName() + " do procesu " + sProcessName + ", activityid:" + activityid);
                    }
                }
            } else {
                log.debug((Object)"Parametr AttachCancelledInvoice nie jest ustawiony na YES, dokumenty nie b\u0119d\u0105 pod\u0142\u0105czane pod inne procesy");
            }
            activityContextMap.put("Action", "zakoncz");
            processContextMap.put("Action", "zakoncz");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            log.debug((Object)"Zapis mapy kontekstowej zadania i procesu.");
            activityService.setActivityContext(sProcessId, sActivityId, activityContextMap);
            processService.setProcessContext(sProcessId, processContextMap);
        }
    }

    public static void addCommentToActivity(String sProcessId, String sActivityId, String sUserid, String msg) {
        try {
            Date dDate = new Date();
            Long lTime = dDate.getTime();
            CommentService cs = ServiceFactory.getCommentService();
            Comment comment = new Comment();
            comment.setActivityId(sActivityId);
            comment.setProcessId(sProcessId);
            comment.setTimestamp(lTime);
            comment.setUserId(sUserid);
            comment.setComment(msg);
            cs.createComment(comment);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

