/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.lm.applications.deltransferprocess;

import com.suncode.lm.applications.deltransferprocess.CSVGenerator;
import com.suncode.lm.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

@Application
public class GenerateTransferFile {
    private static Logger log = Logger.getLogger(GenerateTransferFile.class);
    public static int csvLinesCount;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("del-csv-generator-application")).name("Generowanie pliku przelew\u00f3w delegacji")).description("Generowanie pliku przelew\u00f3w delegacji")).category(new Category[]{Categories.CLIENT})).parameter().id("sciezka_do_pliku").name("application.parameter.sciezka_do_pliku.name").description("application.parameter.sciezka_do_pliku.desc").type((Type)Types.STRING).create()).parameter().id("data_przelewu").name("application.parameter.data_przelewu.name").description("application.parameter.data_przelewu.desc").type((Type)Types.STRING).create()).parameter().id("kwota_przelewu").name("application.parameter.kwota_przelewu.name").description("application.parameter.kwota_przelewu.desc").type((Type)Types.STRING).create()).parameter().id("nr_rachunku_odbiorcy").name("application.parameter.nr_rachunku_odbiorcy.name").description("application.parameter.nr_rachunku_odbiorcy.desc").type((Type)Types.STRING).create()).parameter().id("odbiorca").name("application.parameter.odbiorca.name").description("application.parameter.odbiorca.desc").type((Type)Types.STRING).create()).parameter().id("tytul_przelewu").name("application.parameter.tytul_przelewu.name").description("application.parameter.tytul_przelewu.desc").type((Type)Types.STRING).create()).parameter().id("status").name("application.parameter.status.name").description("application.parameter.status.desc").type((Type)Types.VARIABLE).create()).parameter().id("action").name("application.parameter.action.name").description("application.parameter.action.desc").type((Type)Types.VARIABLE).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(ApplicationContext appContext, @Param String sciezka_do_pliku, @Param String data_przelewu, @Param String kwota_przelewu, @Param String nr_rachunku_odbiorcy, @Param String odbiorca, @Param String tytul_przelewu, @Param Variable status, @Param Variable action) {
        int fileId = 0;
        String sAction = (String)status.getValue();
        String sStatus = (String)action.getValue();
        try {
            log.debug((Object)("Generuje plik dla processid: " + appContext.getProcessId() + ", activityid: '" + appContext.getActivityId()));
            HashMap<String, Object> mProcessContext = new HashMap<String, Object>();
            mProcessContext.put("data_przelewu", data_przelewu);
            mProcessContext.put("kwota_do_wyplaty_gr", kwota_przelewu);
            mProcessContext.put("nr_rachunku_odbiorcy_gr", nr_rachunku_odbiorcy);
            mProcessContext.put("odbiorca_gr", odbiorca);
            mProcessContext.put("tytul_przelewu_gr", tytul_przelewu);
            GenerateTransferFile.prepareData(mProcessContext);
            CSVGenerator csvGenerator = null;
            csvGenerator = new CSVGenerator(csvLinesCount, 16, mProcessContext, "", ",");
            csvGenerator.setConstColumnValues(0, "110");
            csvGenerator.setColumnValues(1, "data_przelewu");
            csvGenerator.setColumnValues(2, "kwota_do_wyplaty_gr");
            csvGenerator.setConstColumnValues(3, "12401125");
            csvGenerator.setConstColumnValues(4, "0");
            if (appContext.getProcessDefId().equals("przelewy_zw")) {
                csvGenerator.setConstColumnValues(5, "55124011251111000003451414", "\"");
            } else {
                csvGenerator.setConstColumnValues(5, "02124011251111001012231998", "\"");
            }
            csvGenerator.setColumnValues(6, "nr_rachunku_odbiorcy_gr", "\"");
            csvGenerator.setConstColumnValues(7, "LEROY MERLIN POLSKA SP. Z O.O.||TARGOWA 72|03-734 WARSZAWA", "\"");
            csvGenerator.setColumnValues(8, "odbiorca_gr", "\"");
            csvGenerator.setConstColumnValues(9, "0");
            csvGenerator.setColumnValues(10, "id_banku_odbiorcy");
            csvGenerator.setColumnValues(11, "tytul_przelewu_gr", "\"");
            csvGenerator.setConstColumnValues(12, "", "\"");
            csvGenerator.setConstColumnValues(13, "", "\"");
            csvGenerator.setConstColumnValues(14, "51");
            csvGenerator.setConstColumnValues(15, "", "\"");
            log.debug((Object)("Zawarto\u015b\u0107 pliku: " + csvGenerator.toString()));
            fileId = GenerateTransferFile.generateFileUsingCSVGenerator(csvGenerator, mProcessContext, sciezka_do_pliku);
            status.setValue((Object)"Oczekuje na wys\u0142anie");
        }
        catch (Exception e) {
            log.error((Object)("wyst\u0105pi\u0142 b\u0142\u0105d podczas generowania pliku przelew\u00f3w: " + e.getMessage()), (Throwable)e);
            sAction = "blad";
        }
        finally {
            action.setValue((Object)sAction);
            status.setValue((Object)sStatus);
        }
    }

    private static int generateFileUsingCSVGenerator(CSVGenerator csvGenerator, Map<String, Object> processContextMap, String path) {
        log.debug((Object)"Rozpoczynam dzia\u0142anie funkcji generateFile");
        File file = null;
        int fileId = 0;
        file = new File(path);
        String csvGeneratorString = csvGenerator.toString("\r\n");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(csvGeneratorString.getBytes());
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage());
            log.error((Object)e.getCause());
        }
        int read = 0;
        byte[] bytes = new byte[1024];
        try {
            while ((read = inputStream.read(bytes)) != -1) {
                ((OutputStream)outputStream).write(bytes, 0, read);
            }
            fileId = 1;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            log.error((Object)e.getCause());
        }
        log.debug((Object)("Fileid: " + String.valueOf(fileId)));
        return fileId;
    }

    private static void prepareData(Map<String, Object> mProcessContext) {
        String amount = (String)mProcessContext.get("kwota_do_wyplaty_gr");
        log.debug((Object)("amount: " + amount));
        String[] amounts = amount.split(";");
        csvLinesCount = amounts.length;
    }
}

