/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.lm.applications.deltransferprocess;

import com.suncode.cuf.math.MathFunctions;
import com.suncode.lm.ClientTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CSVGenerator {
    private static Logger log = Logger.getLogger(CSVGenerator.class);
    private String[][] values;
    public int iLineNo;
    public int iColumnNo;
    public String sSeparator;
    public String sQuote;
    public Map<String, Object> mProcessMap;

    public CSVGenerator(int iLineNo, int iColumnNo, Map<String, Object> mProcessMap, String sStandardQuote, String sSeparator) {
        this.sSeparator = sSeparator;
        this.iColumnNo = iColumnNo;
        this.iLineNo = iLineNo;
        this.values = new String[iLineNo][iColumnNo];
        this.mProcessMap = mProcessMap;
        this.sQuote = sStandardQuote;
    }

    public void setConstColumnValues(int iThisColumnNo, String value) {
        this.setConstColumnValues(iThisColumnNo, value, this.sQuote);
    }

    public void setColumnValues(int iThisColumnNo, String sMapId) {
        log.debug((Object)("Dane wejsciowe (iThisColumnNo): " + iThisColumnNo + ", sMapId: " + sMapId));
        this.setColumnValues(iThisColumnNo, sMapId, this.sQuote);
    }

    public void setConstColumnValues(int iThisColumnNo, String value, String sQuo) {
        int i;
        String[] aValue = new String[this.iLineNo];
        if (value.indexOf(";") > -1) {
            aValue = value.split(";");
        } else {
            for (i = 0; i < this.iLineNo; ++i) {
                aValue[i] = value;
            }
        }
        for (i = 0; i < this.iLineNo; ++i) {
            this.values[i][iThisColumnNo] = sQuo + aValue[i] + sQuo;
        }
    }

    public void setColumnValues(int iThisColumnNo, String sMapId, String sQuo) {
        String value = (String)this.mProcessMap.get(sMapId);
        log.debug((Object)("Dane wejsciowe (iThisColumnNo): " + iThisColumnNo + ", value: " + value));
        if (sMapId.equals("data_przelewu")) {
            value = ClientTools.changeDateFormat(value, "yyyyMMdd");
            this.setConstColumnValues(iThisColumnNo, value, sQuo);
            return;
        }
        if (sMapId.equals("id_banku_odbiorcy")) {
            value = (String)this.mProcessMap.get("nr_rachunku_odbiorcy_gr");
            this.setColumnValuesForBankId(iThisColumnNo, value);
            return;
        }
        if (sMapId.equals("kwota_do_wyplaty_gr")) {
            this.setColumnValuesForAmount(iThisColumnNo, value);
            return;
        }
        if (sMapId.equals("odbiorca_gr")) {
            this.setColumnValuesForColumnField(iThisColumnNo, value.toUpperCase(), sQuo);
            return;
        }
        if (sMapId.equals("tytul_przelewu_gr")) {
            this.setColumnValuesForColumnField(iThisColumnNo, value.toUpperCase(), sQuo);
            return;
        }
        this.setConstColumnValues(iThisColumnNo, value, sQuo);
    }

    public void setColumnValuesForAmount(int iThisColumnNo, String value) {
        int i;
        String[] aValue = this.getValuesArray(value);
        log.debug((Object)("setColumnValuesForAmount value: " + value));
        for (i = 0; i < this.iLineNo; ++i) {
            log.debug((Object)("aValue[i]: " + aValue[i]));
            double valueDouble = MathFunctions.multiply((double)Double.parseDouble(aValue[i]), (double)100.0);
            log.debug((Object)("valueDouble: " + valueDouble));
            int valueInt = (int)valueDouble;
            log.debug((Object)("valueInt: " + valueInt));
            aValue[i] = String.valueOf(valueInt);
            log.debug((Object)("aValue[i]: " + aValue[i]));
        }
        for (i = 0; i < this.iLineNo; ++i) {
            this.values[i][iThisColumnNo] = aValue[i];
        }
    }

    public void setColumnValuesForBankId(int iThisColumnNo, String value) {
        int i;
        String[] aValue = this.getValuesArray(value);
        for (i = 0; i < this.iLineNo; ++i) {
            aValue[i] = aValue[i].substring(2, 10);
        }
        for (i = 0; i < this.iLineNo; ++i) {
            this.values[i][iThisColumnNo] = aValue[i];
        }
    }

    public void setColumnValuesForColumnField(int iThisColumnNo, String value, String sQuo) {
        String[] aValue = this.getValuesArray(value);
        for (int i = 0; i < this.iLineNo; ++i) {
            Object sValue = "";
            int licznik = 1;
            for (int j = 0; j < 4; ++j) {
                ++licznik;
                sValue = aValue[i].length() >= (j + 1) * 35 ? (String)sValue + aValue[i].substring(j * 35, j * 35 + 35) : (String)sValue + aValue[i].substring(j * 35, aValue[i].length());
                sValue = (String)sValue + "|";
                if (aValue[i].length() / 35 < j + 1) break;
            }
            while (licznik < 4) {
                sValue = (String)sValue + "|";
                ++licznik;
            }
            this.values[i][iThisColumnNo] = sQuo + ClientTools.removePolishCharacters((String)sValue) + sQuo;
        }
    }

    public String[] getValuesArray(String value) {
        String[] aValue = new String[this.iLineNo];
        if (value.indexOf(";") > -1) {
            aValue = value.split(";");
        } else {
            for (int i = 0; i < this.iLineNo; ++i) {
                aValue[i] = value;
            }
        }
        return aValue;
    }

    public List<String> generateAllLines() {
        ArrayList<String> resultList = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < this.iLineNo; ++i) {
            for (int j = 0; j < this.iColumnNo; ++j) {
                if (line.length() == 0) {
                    line.append(this.values[i][j]);
                    continue;
                }
                line.append(this.sSeparator + this.values[i][j]);
            }
            resultList.add(line.toString());
            line = new StringBuilder();
        }
        return resultList;
    }

    public String toString(String sLineSeparator) {
        StringBuilder sb = new StringBuilder();
        List<String> resultList = this.generateAllLines();
        for (String line : resultList) {
            sb.append(line + sLineSeparator);
        }
        return sb.toString();
    }

    public String toString() {
        String sLineSeparator = System.getProperty("line.separator");
        return this.toString(sLineSeparator);
    }
}

