/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.lm;

import com.suncode.cuf.math.MathFunctions;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ClientTools {
    private static Logger log = Logger.getLogger(ClientTools.class);

    public static String changeDateFormat(String sDate, String newFormat) {
        String format = ClientTools.getDateFormat(sDate);
        String sDateToSet = sDate;
        if (format != null && !format.isEmpty()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            Date date = null;
            try {
                date = dateFormat.parse(sDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            SimpleDateFormat dateFormatToSet = new SimpleDateFormat(newFormat);
            if (date != null) {
                sDateToSet = dateFormatToSet.format(date);
            }
        }
        return sDateToSet;
    }

    public static String getDateFormat(String data) {
        String[] formats;
        SimpleDateFormat sdf = new SimpleDateFormat();
        for (String format : formats = new String[]{"dd-MM-yyyy", "dd-MMMM-yyyy", "dd.MM.yyyy", "dd.MM.yy", "dd/MM/yyyy", "yyyy-MM-dd", "yyyy-MMMM-dd", "yyyy.MM.dd", "yy.MM.dd", "yyyy/MM/dd"}) {
            sdf.applyPattern(format);
            sdf.setLenient(false);
            try {
                sdf.parse(data);
                return format;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static String removePolishCharacters(String t) {
        return t.replace("\u0105", "a").replace("\u0104", "A").replace("\u0119", "e").replace("\u0118", "E").replace("\u015b", "s").replace("\u015a", "S").replace("\u017c", "z").replace("\u017b", "Z").replace("\u0107", "c").replace("\u0106", "C").replace("\u017a", "z").replace("\u0179", "Z").replace("\u0144", "n").replace("\u0143", "N").replace("\u00f3", "o").replace("\u00d3", "O").replace("\u0142", "l").replace("\u0141", "L").replace("&", "").replace("*", "").replace("%", "").replace("#", "").replace("@", "");
    }

    public static String changeDoubleFormat(String sIn) {
        if (StringUtils.isNotBlank((CharSequence)sIn)) {
            DecimalFormat twoDForm = new DecimalFormat("# ###.##;-# ###.##");
            twoDForm.setMinimumFractionDigits(2);
            twoDForm.setGroupingUsed(true);
            twoDForm.setGroupingSize(3);
            DecimalFormatSymbols symbols = twoDForm.getDecimalFormatSymbols();
            symbols.setGroupingSeparator(' ');
            symbols.setDecimalSeparator('.');
            twoDForm.setDecimalFormatSymbols(symbols);
            String[] sAmount = ((String)sIn).split(";");
            sIn = "";
            for (String amount : sAmount) {
                double tmp;
                if (amount.compareToIgnoreCase("") != 0) {
                    tmp = Double.valueOf(amount);
                    tmp = MathFunctions.round((double)tmp, (int)2);
                    sIn = (String)sIn + twoDForm.format(tmp) + ";";
                    continue;
                }
                tmp = 0.0;
                sIn = (String)sIn + twoDForm.format(tmp) + ";";
            }
            sIn = ((String)sIn).substring(0, ((String)sIn).length() - 1);
        }
        return sIn;
    }

    public static void addCommentToActivity(String sProcessId, String sActivityId, String msg) {
        try {
            log.trace((Object)"************************* addCommentToActivity() ********************");
            Date dDate = new Date();
            Long lTime = dDate.getTime();
            CommentService cs = ServiceFactory.getCommentService();
            Comment comment = new Comment();
            comment.setActivityId(sActivityId);
            comment.setProcessId(sProcessId);
            comment.setTimestamp(lTime);
            comment.setUserId("admin");
            comment.setComment(msg);
            cs.createComment(comment);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static double changeStringToDouble(String sValue) {
        double fKwota = 0.0;
        if (sValue != null) {
            fKwota = (sValue = sValue.replace(" ", "")).compareTo("") == 0 ? 0.0 : Double.valueOf(sValue);
        }
        return fKwota;
    }

    public static int changeStringToInteger(String sValue) {
        int fKwota = 0;
        if (sValue != null) {
            fKwota = (sValue = sValue.replace(" ", "")).compareTo("") == 0 ? 0 : Integer.valueOf(sValue);
        }
        return fKwota;
    }
}

