/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.sprzedazowe;

import com.plusmpm.CUF.util.DataChoosers.ExecuteQueryDataChooser;
import com.plusmpm.CUF.util.extension.MathFunctions;
import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.exportMethods.ExportMethods;
import com.suncode.pwfl.database.sequence.SequenceService;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FSTools {
    private static Logger log = Logger.getLogger(FSTools.class);
    private static SQLFinder finder = FinderFactory.getSQLFinder();
    public static final String PACKAGE_ID = "LM";
    public static final String PROCESS_DEFINITION_ID = "faktury_sprzedazy";
    public static final String SUFFIX_FOR_AUTOMATIC_PROCESS = "_automatyczny";
    public static final String PREFIX_FOR_CYCLIC_PROCESS = "_cykliczny";
    public static final String PREFIX_FOR_UKRAINE = "UA";
    public static final String PREFIX_FOR_BRICOMAN = "M";
    public static final String PREFIX_FOR_ROMANIA = "MAG";
    public static final String FS_DOCUMENT_CLASS_NAME = "Faktury sprzeda\u017cy";
    public static final String TEMP_PATH = "/home/suncode/temp/";
    public static final String AUTO_REQUESTOR = "Automat";
    public static final String AP_SYMBOL = "AP";
    public static final String AR_SYMBOL = "AR";
    public static final String CLAUSE_SPLIT_PAYMENT = "W przypadku, je\u015bli przedmiotem transakcji, kt\u00f3r\u0105 dokumentuje niniejsza faktura, s\u0105 towary lub us\u0142ugi wymienione w za\u0142\u0105czniku nr 15 do ustawy z dnia 11 marca 2004 r. o podatku od towar\u00f3w i us\u0142ug, p\u0142atno\u015b\u0107 za te towary lub us\u0142ugi powinna zosta\u0107 dokonana w spos\u00f3b wykorzystuj\u0105cy \"mechanizm podzielonej p\u0142atno\u015bci\".";
    public static final String[] HEADER_IDS = new String[]{"sklep", "dzial", "nazwa_nabywcy", "adres_nabywcy", "nr_oracle", "nip", "kraj", "siedziba", "nr_oracle", "data_wykonania_uslugi", "tytul_faktury", "typ_faktury", "kod_typu_fakt", "konto_ksiegowe", "forma_platnonsci", "termin_platnosci", "warunki_platnosci", "adres_korespondencyjny", "adres_wysylki", "rodzaj_dokumentu", "nr_dokumentu_oryginalnego", "data_dok_korygowanego", "przyczyna_korekty", "waluta", "tytul_faktury_w_walucie", "kwota_slownie_w_walucie", "nr_zamowienia", "faktura_cykliczna", "data_generowania_kolejnej_faktury", "okres_generowania", "data_ostatniej_faktury", "typ_ksiegowania_pom", "typ_ksiegowania", "suma_netto", "nr_klienta"};
    public static final String[] POSITIONS_TABLE_IDS = new String[]{"tab2_opis_pozycji", "tab2_ilosc", "tab2_jm", "tab2_cena_netto", "tab2_wartosc_netto", "tab2_kod_vat", "tab2_stawka_vat", "tab2_kwota_vat", "tab2_wartosc_brutto", "tab2_ean", "tab2_nr_artykulu", "tab2_kod_celny", "tab2_kraj_pochodzenia"};
    public static final String[] CORRECTING_POSITIONS_TABLE_IDS = new String[]{"tab1_opis_pozycji", "tab1_ilosc", "tab1_jm", "tab1_cena_netto", "tab1_wartosc_netto", "tab1_kod_vat", "tab1_stawka_vat", "tab1_kwota_vat", "tab1_wartosc_brutto", "tab1_nr_artykulu", "tab1_kraj_pochodzenia"};
    public static final String[] GTU_TABLE_IDS = new String[]{"gtu", "procedura_jpk"};

    public static boolean hasUserRole(String sUser, String sRole, String sSklep, String queryname) {
        if (sSklep.indexOf(45) > 0) {
            sSklep = sSklep.split(" - ")[1];
        }
        ExecuteQueryDataChooser dc = new ExecuteQueryDataChooser();
        log.debug((Object)("NameForQuery: " + queryname));
        log.debug((Object)("sUser: " + sUser));
        log.debug((Object)("sRole: " + sRole));
        HashMap<String, String> customKeys = new HashMap<String, String>();
        customKeys.put("NameForQuery", queryname);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("user", sUser);
        criteria.put("role", sRole);
        criteria.put("sklep", sSklep);
        List result = dc.getDataChooserResult(0, 50, sRole, "DESC", criteria, customKeys);
        return result.size() > 0;
    }

    public static boolean userPositionSymbol(String sUser, String queryname) {
        ExecuteQueryDataChooser dc = new ExecuteQueryDataChooser();
        log.debug((Object)("NameForQuery: " + queryname));
        log.debug((Object)("sUser: " + sUser));
        HashMap<String, String> customKeys = new HashMap<String, String>();
        customKeys.put("NameForQuery", queryname);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("user", sUser);
        List result = dc.getDataChooserResult(0, 50, sUser, "DESC", criteria, customKeys);
        log.debug((Object)("Ilosc wynikow: " + result.toString()));
        return result.size() > 0;
    }

    public static String getQueryResultForStore(String sQueryName, String sUserColumn, String sSklep) {
        Object sListaOsob = "";
        if (sSklep.indexOf(45) > 0) {
            sSklep = sSklep.split(" - ")[0];
        }
        ExecuteQueryDataChooser dc = new ExecuteQueryDataChooser();
        HashMap<String, String> customKeys = new HashMap<String, String>();
        customKeys.put("NameForQuery", sQueryName);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("sklep", sSklep);
        List result = dc.getDataChooserResult(0, 50, sUserColumn, "DESC", criteria, customKeys);
        for (Map oneRes : result) {
            sListaOsob = (String)sListaOsob + (String)oneRes.get(sUserColumn) + ";";
        }
        if (((String)sListaOsob).length() > 0) {
            sListaOsob = ((String)sListaOsob).substring(0, ((String)sListaOsob).length() - 1);
        }
        if (((String)sListaOsob).compareTo("") == 0) {
            log.warn((Object)("B\u0142\u0105d! Brak wynikow dla zapytania " + sQueryName + " dla sklepu " + sSklep));
        }
        return sListaOsob;
    }

    public static String getQueryResultForTypeOfModule(String sQueryName, String sUserColumn, String sType) {
        Object sListaOsob = "";
        if (sType.indexOf(45) > 0) {
            sType = sType.split(" - ")[0];
        }
        ExecuteQueryDataChooser dc = new ExecuteQueryDataChooser();
        HashMap<String, String> customKeys = new HashMap<String, String>();
        customKeys.put("NameForQuery", sQueryName);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("typ_ksiegowania", sType);
        List result = dc.getDataChooserResult(0, 50, sUserColumn, "DESC", criteria, customKeys);
        for (Map oneRes : result) {
            sListaOsob = (String)sListaOsob + (String)oneRes.get(sUserColumn) + ";";
        }
        if (((String)sListaOsob).length() > 0) {
            sListaOsob = ((String)sListaOsob).substring(0, ((String)sListaOsob).length() - 1);
        }
        if (((String)sListaOsob).compareTo("") == 0) {
            log.warn((Object)("B\u0142\u0105d! Brak wynikow dla zapytania " + sQueryName + " dla typ_ksiegowania " + sType));
            sListaOsob = "admin";
        }
        return sListaOsob;
    }

    public static String getAccountantForStore(String sSklep) {
        return FSTools.getQueryResultForStore("fs_accountant_for_store", "user", sSklep);
    }

    public static String getAccountantForTypeOfModule(String sType) {
        return FSTools.getQueryResultForStore("fs_accountant_for_module", "user", sType);
    }

    public static String convertDateToString(Date date, String format) {
        String sDate = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        sDate = dateFormat.format(date);
        return sDate;
    }

    public static String getDocumentNumber(String moduleType, String documenType) {
        StringBuilder documentNumber = new StringBuilder();
        return documentNumber.toString();
    }

    public static List<Map<String, String>> executeInternalQuery(String query) {
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        Connection conn = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            log.trace((Object)"************* connecting... ***************");
            InitialContext initialContext = new InitialContext();
            DataSource dataSource = (DataSource)initialContext.lookup("java:comp/env/PlusWorkflowResource");
            conn = dataSource.getConnection();
            log.trace((Object)"************* connected ***************");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (conn != null) {
                DatabaseMetaData metaData = conn.getMetaData();
                if (metaData.supportsTransactionIsolationLevel(1)) {
                    conn.setTransactionIsolation(1);
                }
                log.debug((Object)("Query: " + query));
                log.trace((Object)"************* executing query... ***************");
                stat = conn.createStatement();
                rs = stat.executeQuery(query);
                ResultSetMetaData rsmd = rs.getMetaData();
                int colNumber = rsmd.getColumnCount();
                while (rs.next()) {
                    HashMap<String, String> oneResult = new HashMap<String, String>();
                    for (int i = 1; i <= colNumber; ++i) {
                        String name = rsmd.getColumnName(i);
                        Object obj = rs.getObject(i);
                        String value = "";
                        if (obj != null) {
                            value = obj.toString();
                        }
                        oneResult.put(name, value);
                    }
                    results.add(oneResult);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (rs != null) {
                rs.close();
            }
            if (stat != null) {
                stat.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"B\u0142\u0105d podczas zamykania ResultSet/Statement/Conection.");
        }
        return results;
    }

    public static String getPaymentTermCode(String paymentCode) {
        StringBuilder sb = new StringBuilder();
        if (paymentCode.contains(" d")) {
            log.debug((Object)("Proces z poprzednim formatem termin\u00f3w platnosci: " + paymentCode));
            sb.append("A");
            sb.append(paymentCode.substring(0, paymentCode.indexOf(" ")));
        } else {
            sb.append(paymentCode);
        }
        return sb.toString();
    }

    public static String getPaymentDays(String paymentCode) {
        return paymentCode.contains(" d") ? paymentCode.substring(0, paymentCode.indexOf(" ")) : paymentCode.substring(1, paymentCode.length());
    }

    public static Map<String, String> getIntercompanyData(String intercompany) {
        ExecuteQueryDataChooser dc = new ExecuteQueryDataChooser();
        String queryName = "export_intercompany";
        log.debug((Object)("NameForQuery: " + queryName));
        log.debug((Object)("Szukam danych Intercompany: " + intercompany));
        HashMap<String, String> customKeys = new HashMap<String, String>();
        customKeys.put("NameForQuery", queryName);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("kod_firmy", intercompany);
        List result = dc.getDataChooserResult(0, 50, null, "DESC", criteria, customKeys);
        HashMap<String, String> intercompanyData = new HashMap<String, String>();
        if (result != null && result.size() > 0) {
            intercompanyData.putAll((Map)result.get(0));
        }
        if (intercompanyData.isEmpty()) {
            intercompanyData.put("entite", "");
            intercompanyData.put("kod_firmy", "");
            intercompanyData.put("nr_kraju", "");
            intercompanyData.put("kod_bu", "");
        }
        return intercompanyData;
    }

    public static Map<String, String> getEanData(String ean) {
        ExecuteQueryDataChooser dc = new ExecuteQueryDataChooser();
        String queryName = "fs_ean_data";
        log.debug((Object)("NameForQuery: " + queryName));
        log.debug((Object)("Szukam danych fs_ean_data: " + ean));
        HashMap<String, String> customKeys = new HashMap<String, String>();
        customKeys.put("NameForQuery", queryName);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("ean", ean);
        HashMap<String, String> oneResult = new HashMap<String, String>();
        List results = dc.getDataChooserResult(0, 50, null, "DESC", criteria, customKeys);
        if (results != null && results.size() > 0) {
            oneResult.putAll((Map)results.get(0));
        }
        return oneResult;
    }

    public static String getCountryByNumber(String countryNumber) {
        ExecuteQueryDataChooser dc = new ExecuteQueryDataChooser();
        String queryName = "fs_country_by_number";
        log.debug((Object)("NameForQuery: " + queryName));
        log.debug((Object)("Szukam danych fs_country_by_number: " + countryNumber));
        HashMap<String, String> customKeys = new HashMap<String, String>();
        customKeys.put("NameForQuery", queryName);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("number", countryNumber);
        List results = dc.getDataChooserResult(0, 50, null, "DESC", criteria, customKeys);
        StringBuilder country = new StringBuilder();
        if (results != null && results.size() > 0) {
            country.append((String)((Map)results.get(0)).get("country"));
        }
        return country.toString();
    }

    public static int getMonthsForPeriod(String period) {
        log.debug((Object)("Pobieram liczbe miesiecy dla okresu: " + period));
        int numberOfMonths = 0;
        StringBuilder sbQuery = new StringBuilder();
        sbQuery.append("select months from pm_custom_fs_periods where period = '");
        sbQuery.append(period);
        sbQuery.append("'");
        List<Map<String, String>> results = FSTools.executeInternalQuery(sbQuery.toString());
        if (results != null && results.size() > 0) {
            try {
                numberOfMonths = Functions.changeStringToInteger(results.get(0).get("months"));
            }
            catch (Exception e) {
                log.error((Object)("Nie udalo sie ustalic liczby miesiecy: " + e.getMessage()), (Throwable)e);
            }
        }
        return numberOfMonths;
    }

    public static String addMonthsToDate(Date dateToChange, String dateFormat, int numberOfMonths) {
        log.debug((Object)("dateToChange" + String.valueOf(dateToChange)));
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateToChange);
        cal.add(2, numberOfMonths);
        dateToChange = cal.getTime();
        String nextDate = "";
        nextDate = Functions.getDate(dateToChange, dateFormat);
        log.debug((Object)("Data po zmianie" + nextDate));
        return nextDate;
    }

    public static String addDaysToDate(String dateToChange, String dateFormat, int numberOfDays, String nextDateFormat) {
        Date oDate = Functions.convertStringToDate(dateToChange, dateFormat);
        String nextDate = dateToChange;
        log.debug((Object)("oDate" + String.valueOf(oDate)));
        Calendar cal = Calendar.getInstance();
        cal.setTime(oDate);
        cal.add(5, numberOfDays);
        oDate = cal.getTime();
        nextDate = Functions.getDate(oDate, nextDateFormat);
        log.debug((Object)("Data po zmianie" + nextDate));
        return nextDate;
    }

    public static String getShopNameFromOU(String sOU) {
        String sResult = "";
        if (sOU.length() >= 7) {
            sResult = sOU.substring(0, sOU.length() - 3);
        }
        return sResult;
    }

    public static String insertValuesIfNotNull(String param1, String param2) {
        String sResult = "";
        if (param1 != null && param2 != null && param1.compareTo("") != 0 && param2.compareTo("") != 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(param1);
            sb.append(" - ");
            sb.append(param2);
            sResult = sb.toString();
        }
        return sResult;
    }

    public static String getDepartmentFromOU(String sOU) {
        String sResult = "";
        if (sOU.length() >= 7) {
            sResult = sOU.substring(sOU.length() - 3, sOU.length());
        }
        return sResult;
    }

    public static String getDefaultBankAccount() {
        String bankAccount = "";
        try {
            List records = null;
            HashMap criteria = new HashMap();
            HashMap<String, String> customKeys = new HashMap<String, String>();
            customKeys.put("NameForQuery", "fs_default_bank_account");
            ExecuteQueryDataChooser dc = new ExecuteQueryDataChooser();
            records = dc.getDataChooserResult(0, 1000, null, "ASC", criteria, customKeys);
            if (records != null && !records.isEmpty()) {
                bankAccount = (String)((Map)records.get(0)).get("konto_bankowe");
            } else {
                log.warn((Object)"W bazie brak domy\u015blnego konta bankowego");
            }
        }
        catch (Exception e) {
            log.error((Object)("Nie uda\u0142o si\u0119 pobrac domy\u015blnego konta bankowego" + e.getMessage()), (Throwable)e);
        }
        return bankAccount;
    }

    public static Map<String, String> getContractorDataByKey(String sNip, String sSiteCode, String sOracleNo) {
        Map<String, String> contractor = new HashMap<String, String>();
        ArrayList results = new ArrayList();
        String query = "select name as nazwa_nabywcy, oracle_no as nr_oracle, site_code as siedziba, address1, address2, address3, address4, zip, city, country as kraj, nip, customer_no as nr_klienta, email as adres_mailowy_nabywcy, payment_terms as termin_platnosci from pm_custom_contractors where upper(nip) = '" + sNip.toUpperCase() + "' and upper(customer_class) in ('XXLMPL_DOSTAWCY', 'XXLMPL_FAKTUROWANIE ROZNE','XXLMPL_GRUPA MULLIEZ', 'XXLMPL_INTERCO')";
        if (StringUtils.isNotBlank((String)sSiteCode)) {
            query = query + " and upper(site_code) = '" + sSiteCode.toUpperCase() + "'";
        }
        if (StringUtils.isNotBlank((String)sOracleNo)) {
            query = query + " and upper(oracle_no) = '" + sOracleNo.toUpperCase() + "'";
        }
        log.debug((Object)("Query: " + query));
        try {
            SQLBuilder builder = new SQLBuilder();
            builder.setQuery(query);
            List finder_results = finder.find(builder);
            if (results.size() > 0) {
                for (Map wiersz : finder_results) {
                    HashMap<String, String> oneResult = new HashMap<String, String>();
                    for (String key : wiersz.keySet()) {
                        oneResult.put(key, (String)wiersz.get(key));
                    }
                    results.add(oneResult);
                }
            }
            log.debug((Object)("Liczba znalezionych nabywc\u00f3w: " + results.size()));
            if (results.size() == 1) {
                contractor = (Map)results.get(0);
                String name = contractor.get("nazwa_nabywcy");
                String nip = contractor.get("nip");
                if (name.startsWith(AR_SYMBOL)) {
                    contractor.put("nazwa_nabywcy", name.substring(AR_SYMBOL.length() + 1));
                    contractor.put("typ_ksiegowania", AR_SYMBOL);
                } else if (name.startsWith(AP_SYMBOL)) {
                    contractor.put("nazwa_nabywcy", name.substring(AP_SYMBOL.length() + 1));
                    contractor.put("typ_ksiegowania", AP_SYMBOL);
                    if (nip.compareTo("-") != 0) {
                        nip = nip.replaceAll("-", "");
                    }
                    if (nip.startsWith("PL") || nip.startsWith("pl")) {
                        nip = nip.substring(2);
                    }
                }
                contractor.put("nip", nip);
                StringBuilder address = new StringBuilder();
                address.append(contractor.get("address1").trim());
                address.append(FSTools.clientConcat(contractor.get("address2").trim()));
                address.append(FSTools.clientConcat(contractor.get("address3").trim()));
                address.append(FSTools.clientConcat(contractor.get("address4").trim()));
                address.append("\n");
                address.append(contractor.get("zip").trim());
                address.append(FSTools.clientConcat(contractor.get("city").trim()));
                contractor.remove("address1");
                contractor.remove("address2");
                contractor.remove("address3");
                contractor.remove("address4");
                contractor.remove("zip");
                contractor.remove("city");
                contractor.put("adres_nabywcy", address.toString());
                contractor.put("adres_wysylki", address.toString());
            }
        }
        catch (Exception e) {
            log.error((Object)("WYst\u0105pi\u0142 b\u0142\u0105d podczas wyszukwiania nabywcy: " + e.getMessage()), (Throwable)e);
        }
        return contractor;
    }

    public static String clientConcat(String text) {
        text = StringUtils.isNotBlank((String)text) ? " " + (String)text : "";
        return text;
    }

    public static String getDateFormat(String data) {
        String[] formats;
        SimpleDateFormat sdf = new SimpleDateFormat();
        for (String format : formats = new String[]{"dd-MM-yyyy", "dd-MMMM-yyyy", "dd.MM.yyyy", "dd.MM.yy", "dd/MM/yyyy", "yyyy-MM-dd", "yyyy-MMMM-dd", "yyyy.MM.dd", "yy.MM.dd", "yyyy/MM/dd"}) {
            sdf.applyPattern(format);
            sdf.setLenient(false);
            try {
                sdf.parse(data);
                return format;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static String changeDateFormatToSystemFormat(String sDate) {
        return FSTools.changeDateFormat(sDate, "yyyy-MM-dd");
    }

    public static String changeDateFormat(String sDate, String newFormat) {
        String format = FSTools.getDateFormat(sDate);
        String sDateToSet = sDate;
        if (format != null && !format.isEmpty()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            Date date = null;
            try {
                date = dateFormat.parse(sDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            SimpleDateFormat dateFormatToSet = new SimpleDateFormat(newFormat);
            if (date != null) {
                sDateToSet = dateFormatToSet.format(date);
            }
        }
        return sDateToSet;
    }

    public static String getDescriptionForExport(Map<String, Object> map) {
        StringBuilder sbDescription = new StringBuilder();
        sbDescription.append(FSTools.removeCharactersOnStart("0", map.get("nr_protokolu").toString()));
        sbDescription.append(" ");
        sbDescription.append("[");
        sbDescription.append(map.get("nr_dokumentu").toString());
        sbDescription.append("]");
        sbDescription.append(map.get("nazwa_nabywcy").toString());
        String description = ExportMethods.removeSpaces(sbDescription.toString());
        if (description.length() > 50) {
            description = description.substring(0, 50);
        }
        return description;
    }

    public static String getPaymentDate(String sInvoiceDate, String sPaymentTerm, String sPaymentCondition) {
        int daysToAdd = 0;
        daysToAdd = Functions.changeStringToInteger(FSTools.getPaymentDays(sPaymentTerm));
        String dateFormat = "yyyy-MM-dd";
        String date = FSTools.addDaysToDate(sInvoiceDate, dateFormat, daysToAdd, dateFormat);
        return date;
    }

    public static String getVatRate(String code) {
        double dVatRate = 0.0;
        try {
            dVatRate = Double.valueOf(code);
            code = code.concat("%");
        }
        catch (Exception e) {
            log.debug((Object)"Stawka nieliczbowa. Nie dodaje znaku %");
        }
        return code;
    }

    public static String changeVatRateFormat(String inVatRates) {
        if (StringUtils.isNotBlank((String)inVatRates)) {
            String[] vatRates = ((String)inVatRates).split(";");
            inVatRates = "";
            for (String vatRate : vatRates) {
                inVatRates = (String)inVatRates + FSTools.getVatRate(vatRate) + ";";
            }
            inVatRates = ((String)inVatRates).substring(0, ((String)inVatRates).length() - 1);
        }
        return inVatRates;
    }

    private static String removeCharactersOnStart(String charachters, String text) {
        int lengthOfText = text.length();
        for (int i = 0; i < lengthOfText && text.startsWith(charachters); ++i) {
            text = text.substring(text.indexOf(charachters) + 1);
        }
        return text;
    }

    public static String changeVatCodeToOracleCode(String vatCodes) {
        String oracleVatCodes = "";
        log.debug((Object)"Pobieram kody vat wysylane do oracle");
        String query = "select kod_vat, kod_oracle from pm_custom_vat_fs";
        HashMap<String, String> mapOfCodes = new HashMap<String, String>();
        List<Map<String, String>> results = FSTools.executeInternalQuery(query);
        if (results != null && results.size() > 0) {
            for (Map<String, String> oneResult : results) {
                mapOfCodes.put(oneResult.get("kod_vat"), oneResult.get("kod_oracle"));
            }
        }
        return oracleVatCodes;
    }

    public static Map<String, String> getMapOfVatCodes() {
        log.debug((Object)"Pobieram kody vat wysylane do oracle");
        String query = "select kod_vat, kod_oracle from pm_custom_vat_fs";
        HashMap<String, String> mapOfCodes = new HashMap<String, String>();
        List<Map<String, String>> results = FSTools.executeInternalQuery(query);
        if (results != null && results.size() > 0) {
            for (Map<String, String> oneResult : results) {
                mapOfCodes.put(oneResult.get("kod_vat"), oneResult.get("kod_oracle"));
            }
        }
        return mapOfCodes;
    }

    public static String generateNextValue(String sValue, int iPosNr) {
        long lNr;
        Object sResult = "";
        sValue = sValue.replace("-", "_");
        String seqName = "seq_" + sValue;
        SequenceService sequenceService = ServiceFactory.getSequenceService();
        if (!sequenceService.sequenceExist(seqName)) {
            sequenceService.createSequence(seqName, 1, 1);
        }
        if ((lNr = sequenceService.getNextSequenceValue(seqName).longValue()) >= 0L) {
            boolean check = true;
            int nr = 0;
            if (--iPosNr >= 0) {
                nr = (int)Math.pow(10.0, iPosNr);
            }
            while (check) {
                if (lNr < (long)nr) {
                    sResult = (String)sResult + "0";
                    nr /= 10;
                    continue;
                }
                check = false;
            }
        }
        sResult = (String)sResult + lNr;
        return sResult;
    }

    public static String getDocsNotFromFSClass(String docIds) {
        StringBuilder sbQuery = null;
        StringBuilder sb = new StringBuilder();
        try {
            sbQuery = new StringBuilder();
            sbQuery.append("SELECT pmidx.fileid as fileid , pf.id as fileidtocopy FROM pm_files pf LEFT OUTER JOIN pm_idx00026 pmidx ON (pf.id = pmidx.fileid) WHERE pf.id in(");
            sbQuery.append(docIds);
            sbQuery.append(")");
            log.debug((Object)("Query: " + sbQuery.toString()));
            List<Map<String, String>> results = FSTools.executeInternalQuery(sbQuery.toString());
            String fileid = "";
            String fileidToCopy = "";
            for (int i = 0; i < results.size(); ++i) {
                fileid = results.get(i).get("fileid");
                fileidToCopy = results.get(i).get("fileidtocopy");
                if (!StringUtils.isBlank((String)fileid) || !StringUtils.isNotBlank((String)fileidToCopy)) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(fileidToCopy);
            }
        }
        catch (Exception e) {
            log.debug((Object)("Wyst\u0105pi\u0142 b\u0142ad podczas sprawdzania zalacznikow: " + e.getMessage()), (Throwable)e);
            sb = new StringBuilder();
        }
        return sb.toString();
    }

    public static String roundColumn(String values, int accuracy) {
        String[] sAmount = ((String)values).split(";");
        values = "";
        for (String amount : sAmount) {
            double tmp = 0.0;
            if (amount.compareToIgnoreCase("") != 0) {
                tmp = MathFunctions.round((double)Double.valueOf(amount), (int)accuracy);
            }
            values = (String)values + String.valueOf(tmp) + ";";
        }
        values = ((String)values).substring(0, ((String)values).length() - 1);
        return values;
    }

    public static String completeZero(String textToComplete, int lenght) {
        Object result = "";
        for (int l = textToComplete.length(); l < lenght; ++l) {
            result = (String)result + "0";
        }
        result = (String)result + textToComplete;
        return result;
    }

    public static String getPaymentTermsForDocument(String sPaymentCode) {
        int paymentDays = Functions.changeStringToInteger(FSTools.getPaymentDays(sPaymentCode));
        return paymentDays == 1 ? String.valueOf(paymentDays) + " dzie\u0144" : String.valueOf(paymentDays) + " dni";
    }
}

