/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd_pw;

import com.plusmpm.util.extension.P0015.ckd.CKDTools;
import com.suncode.lm.categories.Categories;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class PW_GetInitData {
    public static Logger log = Logger.getLogger(PW_GetInitData.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("pw_get_init_data-app")).name("pw_get_init_data-app.name")).description("pw_get_init_data-app.desc")).category(new Category[]{Categories.CLIENT})).icon((Icon)SilkIconPack.APPLICATION);
    }

    public void execute(ApplicationContext applicationContext, ActivityContextMap activityContext) throws ClassNotFoundException, Exception {
        String sProcessId = applicationContext.getProcessId();
        String sActivityId = applicationContext.getActivityId();
        Map<String, String> contextMap = new HashMap();
        log.info((Object)("PW_GetInitData - processid: " + sProcessId + ", activityid: " + sActivityId));
        try {
            contextMap = this.processService.getProcessContext(sProcessId);
            Object sJo = "";
            String sInitiator = (String)contextMap.get("Initiator");
            OrganizationalUnitFinder organizationalUnitFinder = FinderFactory.getOrganizationalUnitFinder();
            List organizationalUnits = organizationalUnitFinder.findByUserName(sInitiator, new String[0]);
            if (organizationalUnits != null && organizationalUnits.size() > 0) {
                String sNazwa_sklepu = ((OrganizationalUnit)organizationalUnits.get(0)).getName();
                sJo = ((OrganizationalUnit)organizationalUnits.get(0)).getSymbol().substring(0, 5) + " - " + sNazwa_sklepu;
            }
            log.debug((Object)("PW_GetInitData - slep: " + (String)sJo));
            contextMap.put("sklep", (String)sJo);
            contextMap.put("osoba_rejestrujaca", sInitiator);
            String sKsie = CKDTools.getKsieForShop((String)sJo);
            contextMap.put("lista_ksie", sKsie);
            this.activityService.setActivityContext(sProcessId, sActivityId, contextMap);
            this.processService.setProcessContext(sProcessId, contextMap);
        }
        catch (Exception e) {
            log.error((Object)("PW_GetInitData - blad pobierania danych: " + e.getMessage()), (Throwable)e);
        }
    }
}

