/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd_pw;

import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.OUMethods.OUData;
import com.suncode.lm.categories.Categories;
import com.suncode.plugin.lm.util.extension.P0015.ckd_pw.PWTools;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class PW_GetAccountants {
    public static Logger log = Logger.getLogger(PW_GetAccountants.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private PWTools pwToolsService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("pw_get_accountants-app")).name("pw_get_accountants-app.name")).description("pw_get_accountants-app.desc")).category(new Category[]{Categories.CLIENT})).icon((Icon)SilkIconPack.APPLICATION)).parameter().id("s_sklep").name("pw_get_accountants-app.s_sklep.name").type((Type)Types.STRING).create()).parameter().id("d_brutto_pln").name("pw_get_accountants-app.d_brutto_pln.name").type((Type)Types.FLOAT).create()).parameter().id("s_nr_oracle").name("pw_get_accountants-app.s_nr_oracle.name").type((Type)Types.STRING).create()).parameter().id("s_nip_dostawcy").name("pw_get_accountants-app.s_nip_dostawcy.name").type((Type)Types.STRING).create();
    }

    public void execute(ApplicationContext applicationContext, ActivityContextMap activityContext, @Param String s_sklep, @Param Double d_brutto_pln, @Param String s_nr_oracle, @Param String s_nip_dostawcy) throws Exception {
        String sProcessId = applicationContext.getProcessId();
        String sActivityId = applicationContext.getActivityId();
        log.info((Object)("PW_GetAccountants - processid: " + sProcessId + ", activityid: " + sActivityId));
        try {
            Map processContext = this.processService.getProcessContext(sProcessId);
            String sSklep = s_sklep;
            String sNrOracle = s_nr_oracle;
            String sOU = "";
            Object sRole = "";
            double plnGrossSum = d_brutto_pln;
            String gtu = (String)processContext.get("gtu");
            String sSplitPayment = "";
            if (gtu == null && plnGrossSum > 15000.0) {
                log.debug((Object)"Zaznaczam split payment");
                sSplitPayment = "TAK";
            } else if (gtu != null) {
                String[] gtuArray = gtu.split(";");
                List<Object> gtuList = new ArrayList();
                gtuList = Arrays.asList(gtuArray);
                sSplitPayment = plnGrossSum > 15000.0 && (gtuList.contains("GTU_02") || gtuList.contains("GTU_03") || gtuList.contains("GTU_05") || gtuList.contains("GTU_06") || gtuList.contains("GTU_07") || gtuList.contains("GTU_08") || gtuList.contains("GTU_11")) ? "TAK" : "NIE";
            } else {
                sSplitPayment = "NIE";
            }
            processContext.put("split_payment", sSplitPayment);
            if (sNrOracle != null) {
                String sNip = s_nip_dostawcy;
                Map<String, String> customer = PWTools.getCustomerDataByNip(sNip);
                if (customer != null && customer.size() > 0) {
                    log.debug((Object)"ustawiam klienta");
                    processContext.put("nr_oracle", customer.get("nr_oracle"));
                    processContext.put("siedziba", customer.get("siedziba"));
                    processContext.put("nr_klienta", customer.get("nr_klienta"));
                    processContext.put("termin_platnosci", customer.get("termin_platnosci"));
                } else {
                    processContext.put("nr_oracle", sNip);
                }
            }
            sOU = sSklep.substring(0, 5);
            sRole = "Ksiegowa_" + sOU;
            log.debug((Object)("Pobranie osob o roli " + (String)sRole));
            processContext.put("lista_fra", OUData.getUsersForRole((String)sRole));
            this.activityService.setActivityContext(sProcessId, sActivityId, processContext);
            this.processService.setProcessContext(sProcessId, processContext);
        }
        catch (Exception e) {
            log.error((Object)("PW_GetUsers - blad pobierania uzytkownikow: " + e.getMessage()), (Throwable)e);
            Functions.addCommentToActivity(sProcessId, sActivityId, "Nie uda\u0142o si\u0119 pobrac u\u017cytkownik\u00f3w: " + e.getMessage());
        }
    }
}

