/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd_pw;

import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.PrepeareDoc;
import com.plusmpm.database.DocumentTemplateTable;
import com.plusmpm.util.extension.P0015.Functions;
import com.suncode.lm.categories.Categories;
import com.suncode.plugin.lm.util.extension.P0015.ckd_pw.PWTools;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.DocumentTemplateService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class PW_GenerateLS {
    public static Logger log = Logger.getLogger(PW_GenerateLS.class);
    private static String _ls_template = "ckd_pw_ls";
    @Autowired
    private ProcessService processService;
    @Autowired
    private DocumentTemplateService documentTemplateService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private PWTools pwToolsService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("pw_generate_ls-app")).name("pw_generate_ls-app.name")).description("pw_generate_ls-app.desc")).category(new Category[]{Categories.CLIENT})).icon((Icon)SilkIconPack.APPLICATION);
    }

    public void execute(ApplicationContext applicationContext, ActivityContextMap activityContext) throws Exception {
        String sProcessId = applicationContext.getProcessId();
        String sActivityId = applicationContext.getActivityId();
        log.info((Object)("PW_GenerateLS - processid: " + sProcessId + ", activityid: " + sActivityId));
        try {
            String separator;
            Map conntextMap;
            Map mappings = this.processService.getProcessContext(sProcessId);
            String outputDocClassName = PWTools._lsDocClassName;
            DocumentTemplateTable dtt = this.documentTemplateService.getByName(_ls_template, new String[0]);
            String docxPath = dtt.getTemplatePath();
            String sDataDokumentu = Functions.getCurrentDate("yyyy-MM-dd");
            mappings.put("data_dokumentu", sDataDokumentu);
            mappings.put("nr_bonu_wyjsciazamowienia", mappings.get("nr_bonu_wyjsciazamowienia").toString().replaceAll(";", ";\t"));
            mappings.put("data_fizycznego_odbioru_przez_dostawce", mappings.get("data_fizycznego_odbioru_przez_dostawce").toString().replaceAll(";", ";\t"));
            if (mappings.get("forma_odbioru_zwrotu") != null && !mappings.get("forma_odbioru_zwrotu").toString().isEmpty()) {
                mappings.put("forma_odbioru_zwrotu", mappings.get("forma_odbioru_zwrotu").toString().replaceAll(";", ";\t"));
            }
            if (mappings.get("numer_listu_przewozowego") != null && !mappings.get("numer_listu_przewozowego").toString().isEmpty()) {
                mappings.put("numer_listu_przewozowego", mappings.get("numer_listu_przewozowego").toString().replaceAll(";", ";\t"));
            }
            if (mappings.get("nazwisko_osoby_odbierajacej") != null && !mappings.get("nazwisko_osoby_odbierajacej").toString().isEmpty()) {
                mappings.put("nazwisko_osoby_odbierajacej", mappings.get("nazwisko_osoby_odbierajacej").toString().replaceAll(";", ";\t"));
            }
            String[] tLp = mappings.get("lp").toString().split(";");
            String[] tReferencjaLm = mappings.get("referencja_lm").toString().split(";");
            String[] tOpisReferencji = mappings.get("opis").toString().split(";");
            String[] tCenaZam = mappings.get("cena_z_zamowienia").toString().split(";");
            String[] tIloscZwalo = mappings.get("ilosc_zwalo").toString().split(";");
            String[] tWartosc = mappings.get("wartosc_waloryzacji").toString().split(";");
            Object sLp = "";
            Object sReferencjaLm = "";
            Object sOpisReferencji = "";
            Object sCenaZam = "";
            Object sIloscZwalo = "";
            Object sWartosc = "";
            double suma_netto = 0.0;
            boolean flaga = false;
            for (int i = 0; i < tReferencjaLm.length; ++i) {
                double wartosc = Functions.changeStringToDouble(Functions.getValueFromTable(tWartosc, i));
                suma_netto += wartosc;
                if (flaga) {
                    sLp = (String)sLp + ";";
                    sReferencjaLm = (String)sReferencjaLm + ";";
                    sOpisReferencji = (String)sOpisReferencji + ";";
                    sCenaZam = (String)sCenaZam + ";";
                    sIloscZwalo = (String)sIloscZwalo + ";";
                    sWartosc = (String)sWartosc + ";";
                }
                sLp = (String)sLp + Functions.getValueFromTable(tLp, i);
                sReferencjaLm = (String)sReferencjaLm + Functions.getValueFromTable(tReferencjaLm, i);
                sOpisReferencji = (String)sOpisReferencji + Functions.getValueFromTable(tOpisReferencji, i);
                sCenaZam = (String)sCenaZam + Functions.getValueFromTable(tCenaZam, i);
                sIloscZwalo = (String)sIloscZwalo + Functions.getValueFromTable(tIloscZwalo, i);
                sWartosc = (String)sWartosc + Functions.getValueFromTable(tWartosc, i);
                flaga = true;
            }
            mappings.put("lp", sLp);
            mappings.put("referencja_lm", sReferencjaLm);
            mappings.put("opis", sOpisReferencji);
            mappings.put("cena_z_zamowienia", Functions.changeDoubleFormat((String)sCenaZam));
            mappings.put("ilosc_zwalo", Functions.changeDoubleFormat((String)sIloscZwalo));
            mappings.put("wartosc_waloryzacji", Functions.changeDoubleFormat((String)sWartosc));
            mappings.put("suma_netto", Functions.changeDoubleFormat(String.valueOf(suma_netto)));
            HashMap<String, Object> optionalParameters = new HashMap<String, Object>();
            ArrayList<Boolean> lWhichTables = new ArrayList<Boolean>();
            lWhichTables.add(false);
            lWhichTables.add(true);
            lWhichTables.add(false);
            ArrayList<Boolean> lWhichHeaders = new ArrayList<Boolean>();
            lWhichHeaders.add(false);
            lWhichHeaders.add(true);
            lWhichHeaders.add(false);
            optionalParameters.put("variablesMarker", "@");
            optionalParameters.put("whichTables", lWhichTables);
            optionalParameters.put("whichHeaders", lWhichHeaders);
            Long docId = PrepeareDoc.createPdfAndSaveInArchive((String)docxPath, (String)outputDocClassName, (Map)mappings, (String)sProcessId, optionalParameters);
            if (docId != null && docId != -1L) {
                conntextMap = this.processService.getProcessContext(sProcessId);
                String sDocIds = conntextMap.get("DocIds").toString();
                if (sDocIds.compareTo("") == 0) {
                    conntextMap.put("DocIds", String.valueOf(docId));
                } else {
                    sDocIds = sDocIds.concat(",").concat(String.valueOf(docId));
                    conntextMap.put("DocIds", sDocIds);
                }
                DocumentClass documentClass = this.documentClassService.getDocumentClass(outputDocClassName, new String[0]);
                WfDocument wfDocument = this.documentFinder.findByFileId(docId, documentClass.getId());
                this.documentService.attachDocumentToProcess(wfDocument, "admin", sProcessId, sActivityId);
                String tmp_data = conntextMap.get("login_osoby_uzupelniajacej").toString();
                separator = "";
                if (tmp_data != null && !tmp_data.isEmpty()) {
                    separator = ";";
                }
            } else {
                throw new Exception("Wyst\u0105pi\u0142 b\u0142\u0105d podczas generowania dokumentu.");
            }
            conntextMap.put("rodzaj_dokumentu", conntextMap.get("rodzaj_dokumentu").toString().concat(separator).concat(PWTools._lsFileDesc));
            conntextMap.put("ls", conntextMap.get("ls").toString().concat(separator));
            conntextMap.put("login_osoby_uzupelniajacej", conntextMap.get("login_osoby_uzupelniajacej").toString().concat(separator).concat("admin"));
            conntextMap.put("zal_fileid", conntextMap.get("zal_fileid").toString().concat(separator).concat(String.valueOf(docId)));
            conntextMap.put("zal_docclass", conntextMap.get("zal_docclass").toString().concat(separator).concat(outputDocClassName));
            conntextMap.put("status", "Oczekiwanie na wys\u0142anie maila");
            this.processService.setProcessContext(sProcessId, conntextMap);
            log.debug((Object)"DocId = ".concat(String.valueOf(docId)).concat(", dodano dokument do procesu"));
        }
        catch (Exception e) {
            log.error((Object)("PW_GenerateLS - Generowanie listu spornego nie powiod\u0142o si\u0119 - processid: " + sProcessId + ": " + e.getMessage()), (Throwable)e);
            Functions.addCommentToActivity(sProcessId, sActivityId, "Dodawanie listu spornego zako\u0144czone niepowodzeniem: " + e.getMessage());
            throw e;
        }
    }
}

