/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd_pw;

import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.PrepeareDoc;
import com.plusmpm.database.DocumentTemplateTable;
import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.Value2Txt;
import com.plusmpm.util.extension.P0015.getDataMethods.GetDataFromProcess;
import com.plusmpm.util.extension.P0015.sprzedazowe.FSTools;
import com.suncode.lm.categories.Categories;
import com.suncode.plugin.lm.util.extension.P0015.ckd_pw.PWTools;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.DocumentTemplateService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class PW_GenerateInvoice {
    public static Logger log = Logger.getLogger(PW_GenerateInvoice.class);
    private static String _fv_template = "ckd_pw_fv";
    private static String _kfv_template = "ckd_pw_kfv";
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private DocumentTemplateService documentTemplateService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private PWTools pwToolsService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("pw_generate_invoice-app")).name("pw_generate_invoice-app.name")).description("pw_generate_invoice-app.desc")).category(new Category[]{Categories.CLIENT})).icon((Icon)SilkIconPack.APPLICATION);
    }

    public void execute(ApplicationContext applicationContext, ActivityContextMap activityContext) throws Exception {
        String sProcessId = applicationContext.getProcessId();
        String sActivityId = applicationContext.getActivityId();
        log.info((Object)("PW_GenerateInvoice - processid: " + sProcessId + ", activityid: " + sActivityId));
        try {
            String separator;
            Map conntextMap;
            String sSplitPayment;
            Map mappings = this.processService.getProcessContext(sProcessId);
            boolean is_correct = false;
            String sRodzajRej = (String)mappings.get("rodzaj_rejestracji");
            if (sRodzajRej.compareTo(PWTools._status_for_cancel) == 0) {
                is_correct = true;
            }
            String sDataDokumentu = (String)mappings.get("data_wystawienia_faktury");
            String sNip = (String)mappings.get("nip_dostawca_faktura");
            if (sNip.startsWith("PL")) {
                mappings.put("nip_dostawca_faktura", sNip.substring(2));
            }
            String outputDocClassName = PWTools._fvDocClassName;
            DocumentTemplateTable dtt = this.documentTemplateService.getByName(_fv_template, new String[0]);
            if (is_correct) {
                dtt = this.documentTemplateService.getByName(_kfv_template, new String[0]);
                Object oDataFryOrg = GetDataFromProcess.getVariableValueFromProcess("przyjscia_wyjscia", "nr_faktury", (String)mappings.get("numer_faktury_korygowanej"), "data_wystawienia_faktury");
                String sDataFryOrg = "";
                if (oDataFryOrg == null) {
                    sDataFryOrg = PWTools.getInvoiceDate(sProcessId);
                    log.debug((Object)("Znaleziona data " + sDataFryOrg));
                } else {
                    sDataFryOrg = String.valueOf(oDataFryOrg);
                }
                mappings.put("data_faktury_korygowanej", sDataFryOrg);
                sDataDokumentu = "";
            }
            String docxPath = dtt.getTemplatePath();
            String sTerminPlatnosci = (String)mappings.get("termin_platnosci");
            if (StringUtils.isNotBlank((String)sTerminPlatnosci)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Kompensata ");
                sb.append(FSTools.getPaymentTermsForDocument(sTerminPlatnosci));
                sb.append(" od daty wystawienia");
                mappings.put("opis_faktury", sb.toString());
            }
            if (sDataDokumentu == null || sDataDokumentu.isEmpty()) {
                sDataDokumentu = Functions.getCurrentDate("yyyy-MM-dd");
            }
            mappings.put("data_wystawienia_faktury", sDataDokumentu);
            String sNrFaktury = (String)mappings.get("nr_faktury");
            if (sNrFaktury == null || sNrFaktury.isEmpty()) {
                String sSklep = ((String)mappings.get("sklep")).split(" - ")[0];
                sNrFaktury = PWTools.getFvNr(is_correct, sDataDokumentu, sSklep);
                log.info((Object)("Wygenerowano nr faktury " + sNrFaktury));
            }
            if (StringUtils.isNotBlank((String)(sSplitPayment = (String)mappings.get("split_payment"))) && sSplitPayment.compareToIgnoreCase("TAK") == 0) {
                log.debug((Object)"Zaznaczam split payment");
                mappings.put("split_payment", "W przypadku, je\u015bli przedmiotem transakcji, kt\u00f3r\u0105 dokumentuje niniejsza faktura, s\u0105 towary lub us\u0142ugi wymienione w za\u0142\u0105czniku nr 15 do ustawy z dnia 11 marca 2004 r. o podatku od towar\u00f3w i us\u0142ug, p\u0142atno\u015b\u0107 za te towary lub us\u0142ugi powinna zosta\u0107 dokonana w spos\u00f3b wykorzystuj\u0105cy \"mechanizm podzielonej p\u0142atno\u015bci\".");
            } else {
                mappings.put("split_payment", "");
            }
            mappings.put("cena_fakturowania", Functions.changeDoubleFormat((String)mappings.get("cena_fakturowania")));
            mappings.put("rabat", Functions.changeDoubleFormat((String)mappings.get("rabat")));
            mappings.put("ilosc_zwalo", Functions.changeDoubleFormat((String)mappings.get("ilosc_zwalo")));
            mappings.put("wartosc_faktury_sprzedazy", Functions.changeDoubleFormat((String)mappings.get("wartosc_faktury_sprzedazy")));
            mappings.put("kwota_vat", Functions.changeDoubleFormat((String)mappings.get("kwota_vat")));
            mappings.put("kwota_brutto", Functions.changeDoubleFormat((String)mappings.get("kwota_brutto")));
            mappings.put("nr_faktury", sNrFaktury);
            mappings.put("kwota_slownie", Value2Txt.formStringWithCurrency((Double)mappings.get("suma_brutto"), (String)mappings.get("waluta")));
            mappings.put("suma_netto_fra", Functions.changeDoubleFormat(String.valueOf(mappings.get("suma_netto_fra"))));
            mappings.put("suma_vat", Functions.changeDoubleFormat(String.valueOf(mappings.get("suma_vat"))));
            mappings.put("suma_brutto", Functions.changeDoubleFormat(String.valueOf(mappings.get("suma_brutto"))));
            mappings.put("zb_kwota_netto", Functions.changeDoubleFormat((String)mappings.get("zb_kwota_netto")));
            mappings.put("zb_kwota_vat", Functions.changeDoubleFormat((String)mappings.get("zb_kwota_vat")));
            mappings.put("zb_kwota_brutto", Functions.changeDoubleFormat((String)mappings.get("zb_kwota_brutto")));
            HashMap<String, Object> optionalParameters = new HashMap<String, Object>();
            ArrayList<Boolean> lWhichTables = new ArrayList<Boolean>();
            ArrayList<Boolean> lWhichHeaders = new ArrayList<Boolean>();
            lWhichTables.add(false);
            lWhichHeaders.add(false);
            lWhichTables.add(true);
            lWhichHeaders.add(true);
            lWhichTables.add(false);
            lWhichHeaders.add(false);
            lWhichTables.add(true);
            lWhichHeaders.add(true);
            lWhichTables.add(false);
            lWhichHeaders.add(false);
            optionalParameters.put("variablesMarker", "@");
            optionalParameters.put("whichTables", lWhichTables);
            optionalParameters.put("whichHeaders", lWhichHeaders);
            Long docId = PrepeareDoc.createPdfAndSaveInArchive((String)docxPath, (String)outputDocClassName, (Map)mappings, (String)sProcessId, optionalParameters);
            if (docId != null && docId != -1L) {
                conntextMap = this.processService.getProcessContext(sProcessId);
                String sDocIds = conntextMap.get("DocIds").toString();
                if (sDocIds.compareTo("") == 0) {
                    conntextMap.put("DocIds", String.valueOf(docId));
                } else {
                    sDocIds = sDocIds.concat(",").concat(String.valueOf(docId));
                    conntextMap.put("DocIds", sDocIds);
                }
                DocumentClass documentClass = this.documentClassService.getDocumentClass(outputDocClassName, new String[0]);
                WfDocument wfDocument = this.documentFinder.findByFileId(docId, documentClass.getId());
                this.documentService.attachDocumentToProcess(wfDocument, "admin", sProcessId, sActivityId);
                String tmp_data = conntextMap.get("login_osoby_uzupelniajacej").toString();
                separator = "";
                if (tmp_data != null && !tmp_data.isEmpty()) {
                    separator = ";";
                }
                conntextMap.put("data_wystawienia_faktury", sDataDokumentu);
                conntextMap.put("nr_faktury", sNrFaktury);
            } else {
                throw new Exception("Wyst\u0105pi\u0142 b\u0142\u0105d podczas generowania dokumentu.");
            }
            conntextMap.put("rodzaj_dokumentu", conntextMap.get("rodzaj_dokumentu").toString().concat(separator).concat(is_correct ? PWTools._fvCorFileDesc : PWTools._fvFileDesc));
            conntextMap.put("ls", conntextMap.get("ls").toString().concat(separator));
            conntextMap.put("login_osoby_uzupelniajacej", conntextMap.get("login_osoby_uzupelniajacej").toString().concat(separator).concat("admin"));
            conntextMap.put("zal_fileid", conntextMap.get("zal_fileid").toString().concat(separator).concat(String.valueOf(docId)));
            conntextMap.put("zal_docclass", conntextMap.get("zal_docclass").toString().concat(separator).concat(outputDocClassName));
            conntextMap.put("status", "W KSIE wystawiono fv");
            this.activityService.setActivityContext(sProcessId, sActivityId, conntextMap);
            this.processService.setProcessContext(sProcessId, conntextMap);
            log.debug((Object)"DocId = ".concat(String.valueOf(docId)).concat(", dodano dokument do procesu"));
        }
        catch (Exception e) {
            log.error((Object)("PW_GenerateInvoice - Generowanie faktury nie powiod\u0142o si\u0119 - processid: " + sProcessId + ": " + e.getMessage()), (Throwable)e);
            Functions.addCommentToActivity(sProcessId, sActivityId, "Dodawanie faktury zako\u0144czone niepowodzeniem: " + e.getMessage());
            throw e;
        }
    }
}

