/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd_pw;

import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.ckd.CKDTools;
import com.plusmpm.util.extension.P0015.ckd.integrations.ws.IPAO_WServices;
import com.plusmpm.util.extension.P0015.ckd_pw.data.ReturnTable;
import com.plusmpm.util.extension.P0015.ckd_pw.data.dao.ReturnTableDao;
import com.suncode.lm.categories.Categories;
import com.suncode.plugin.lm.DirectDB.copyInitData.Sklepy;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.SklepyDao;
import com.suncode.plugin.lm.util.extension.P0015.ckd_pw.PWTools;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class PW_GedDataFromPO {
    public static Logger log = Logger.getLogger(PW_GedDataFromPO.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private SklepyDao sklepyDao;
    @Autowired
    private PWTools pwToolsService;
    @Autowired
    private ReturnTableDao returnTableDao;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("pw_ged_data_from_po-app")).name("pw_ged_data_from_po-app.name")).description("pw_ged_data_from_po-app.desc")).category(new Category[]{Categories.CLIENT})).icon((Icon)SilkIconPack.APPLICATION);
    }

    public void execute(ApplicationContext applicationContext, ActivityContextMap activityContext) throws Exception {
        String sProcessId = applicationContext.getProcessId();
        String sActivityId = applicationContext.getActivityId();
        log.info((Object)("PW_GedDataFromPO - processid: " + sProcessId + ", activityid: " + sActivityId));
        try {
            Map contextMap = this.processService.getProcessContext(sProcessId);
            String sSklep = (String)contextMap.get("sklep");
            String sNrBonu = (String)contextMap.get("nr_bonu_wyjsciazamowienia");
            String sNrOdbioru = (String)contextMap.get("nr_odbioru");
            log.info((Object)("** CKD ** PW_GedDataFromPO process " + sProcessId + ", sklep " + sSklep + ", nr_bonu " + sNrBonu + ", nr_bonu " + sNrOdbioru));
            if (sSklep == null || sSklep.isEmpty()) {
                throw new Exception("Brak numeru sklepu");
            }
            if (sNrBonu == null || sNrBonu.isEmpty()) {
                throw new Exception("Nie podano nr bonu");
            }
            String sSymbol = sSklep.split(" - ")[0];
            Sklepy shop = this.sklepyDao.getSklepBySymbol(sSymbol);
            int store_no = Integer.valueOf(shop.getCkd());
            ReturnTable doss = null;
            if (sNrBonu == null || sNrBonu.isEmpty()) {
                throw new Exception("Nr bonu musi by\u0107 podany");
            }
            log.debug((Object)("** CKD ** PW_GedDataFromPO sprawdzanie po nr bonu " + sNrBonu));
            doss = this.returnTableDao.getIfExistsByNrBonuAndSklep(sNrBonu, store_no);
            if (doss != null) {
                log.debug((Object)"** CKD ** PW_GedDataFromPO odnaleziono dossier w SOD");
                if (doss.getStatus_dossier().compareToIgnoreCase(PWTools._closed_fv) == 0 && doss.isFaktura_do_anulacji()) {
                    log.info((Object)"** CKD ** PW_GedDataFromPO BRAK INTEGRACJI Z BO ");
                } else {
                    JSONObject dossierJSON = IPAO_WServices.get_rec(store_no, sNrBonu);
                    if (dossierJSON != null) {
                        log.debug((Object)"** CKD ** PW_GedDataFromPO aktualizacja danych z BO ");
                        Map<String, Object> ws_data = this.pwToolsService.translateDoss(dossierJSON);
                        contextMap.putAll(PWTools.setAddictionalAmounds(contextMap, ws_data));
                    }
                }
            }
            String sAkcja = (String)contextMap.get("akcja");
            if (sAkcja.compareTo("zatwierdz") == 0) {
                String sDataOdbioru = (String)contextMap.get("data_fizycznego_odbioru_przez_dostawce");
                if (sDataOdbioru != null && !sDataOdbioru.isEmpty()) {
                    Date dDataOdbioru = Functions.convertStringToDate(sDataOdbioru, "yyyy-MM-dd");
                    Calendar cal_odbior = Calendar.getInstance();
                    cal_odbior.setTime(dDataOdbioru);
                    cal_odbior.add(5, -2);
                    long diff = Calendar.getInstance().getTimeInMillis() - cal_odbior.getTimeInMillis();
                    long h_diff = 0L;
                    if (diff > 0L) {
                        h_diff = TimeUnit.MILLISECONDS.toDays(diff);
                    }
                    contextMap.put("terminowosc_realizacji_zadania_dpt", Double.valueOf(h_diff));
                }
                String sKsie = CKDTools.getKsieForShop(sSklep);
                contextMap.put("lista_ksie", sKsie);
            }
            this.activityService.setActivityContext(sProcessId, sActivityId, contextMap);
            this.processService.setProcessContext(sProcessId, contextMap);
        }
        catch (Exception e) {
            log.error((Object)("PW_GedDataFromPO - blad pobierania danych: " + e.getMessage()), (Throwable)e);
            Functions.addCommentToActivity(sProcessId, sActivityId, "Nie uda\u0142o si\u0119 pobra\u0107 danych: " + e.getMessage());
            throw e;
        }
    }
}

