/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd_pw;

import com.plusmpm.util.extension.P0015.Functions;
import com.suncode.lm.categories.Categories;
import com.suncode.plugin.lm.DirectDB.copyInitData.OracleHistory;
import com.suncode.plugin.lm.DirectDB.copyInitData.SendToOracle;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.OracleHistoryDao;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.SendToOracleDao;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.sql.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class PW_ExportDataToOracle {
    public static Logger log = Logger.getLogger(PW_ExportDataToOracle.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private OracleHistoryDao oracleHistoryDao;
    @Autowired
    private SendToOracleDao sendToOracleDao;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("pw_export_data_to_oracle-app")).name("pw_export_data_to_oracle-app.name")).description("pw_export_data_to_oracle-app.desc")).category(new Category[]{Categories.CLIENT})).icon((Icon)SilkIconPack.APPLICATION);
    }

    public void execute(ApplicationContext applicationContext, ActivityContextMap activityContext) throws Exception {
        String sProcessId = applicationContext.getProcessId();
        String sActivityId = applicationContext.getActivityId();
        log.info((Object)("PW_ExportDataToOracle - processid: " + sProcessId + ", activityid: " + sActivityId));
        try {
            Map contextMap = this.processService.getProcessContext(sProcessId);
            Date dCurrentDate = new Date(System.currentTimeMillis());
            int checkIfAP = 0;
            try {
                checkIfAP = this.oracleHistoryDao.checkIfExistOracleHistoryByCategoryAndOperationAndDate(sProcessId, "R", dCurrentDate);
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage());
            }
            if (checkIfAP > 0) {
                log.warn((Object)"Operacja zostala juz wykonana");
            } else {
                String sWaluta = (String)contextMap.get("waluta");
                String sNrDokumentu = (String)contextMap.get("nr_faktury");
                String sKategoriaDokumentu = "WFPW";
                log.debug((Object)("Wysylamy AR dla  nr dokumentu: " + sNrDokumentu + ", sKategoriaDokumentu: " + sKategoriaDokumentu + ", sWaluta: " + sWaluta));
                SendToOracle toOracleAP = new SendToOracle(sProcessId, sActivityId, "R", dCurrentDate, sNrDokumentu, sKategoriaDokumentu, sWaluta);
                this.sendToOracleDao.addToTable(toOracleAP);
                OracleHistory toOracleHistAP = new OracleHistory(sProcessId, sActivityId, "R", dCurrentDate, sNrDokumentu, sKategoriaDokumentu, sWaluta);
                this.oracleHistoryDao.addToTable(toOracleHistAP);
            }
        }
        catch (Exception e) {
            log.error((Object)("PW_ExportDataToOracle - blad przy eksporcie do Oracle: " + e.getMessage()), (Throwable)e);
            Functions.addCommentToActivity(sProcessId, sActivityId, "Nie uda\u0142o si\u0119 wys\u0142a\u0107 do Oracle: " + e.getMessage());
        }
    }
}

