/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.processTools;

import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.Dossier;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.dao.DossierDao;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.DossierListElement;
import com.plusmpm.util.extension.P0015.ckd.integrations.ws.IPAO_WServices;
import com.plusmpm.util.extension.P0015.ckd.processTools.SetVariables;
import com.plusmpm.util.extension.P0015.getDataMethods.GetDataFromProcess;
import com.suncode.plugin.lm.DirectDB.copyInitData.Addresses;
import com.suncode.plugin.lm.DirectDB.copyInitData.MPK;
import com.suncode.plugin.lm.DirectDB.copyInitData.Sklepy;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.AddressesDao;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.MPKDao;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.SklepyDao;
import com.suncode.plugin.lm.util.extension.P0015.Tools_ProcessManager;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.transaction.SharkTransactionManager;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.transaction.support.SharkTransactionCallback;
import com.suncode.pwfl.transaction.support.SharkTransactionTemplate;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.util.ProcessBuilderDefinition;
import java.sql.Connection;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Transactional
public class ProcessManager {
    public static Logger log = Logger.getLogger(ProcessManager.class);
    @Autowired
    private DossierDao dossierDao;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private AddressesDao addressesDao;
    @Autowired
    private MPKDao mpkDao;
    @Autowired
    private SklepyDao sklepyDao;
    @Autowired
    private Tools_ProcessManager tools_ProcessManagerService;

    public String createProcess(final DossierListElement dossier_to_open) throws Exception {
        SharkTransactionTemplate tx = new SharkTransactionTemplate();
        String result = (String)tx.execute((SharkTransactionCallback)new SharkTransactionCallback<String>(){

            public String doInSharkTransaction(SharkTransaction transaction, TransactionStatus status) throws Exception {
                String sProcessId = "";
                log.debug((Object)("****** tworzenie procesu dla dossier " + dossier_to_open.keyToString() + " ******"));
                try {
                    try {
                        String sProcessDefId = "kwestie_spo";
                        HashMap<String, Object> variables = new HashMap<String, Object>();
                        Dossier dossier = ProcessManager.this.dossierDao.getByKey(dossier_to_open.getPrimaryKey());
                        Sklepy tmp_sklep = ProcessManager.this.sklepyDao.getSklepyByNrCkd(dossier.getStore_no());
                        Object sSklep = "";
                        if (tmp_sklep == null) {
                            sSklep = String.valueOf(dossier.getStore_no()) + " - BRAK DANYCH SKLEPU";
                            throw new Exception("Brak definicji sklepu w tabeli sklepy!");
                        }
                        sSklep = tmp_sklep.getSklep() + " - " + tmp_sklep.getOpis();
                        variables.put("sklep", sSklep);
                        ProcessBuilderDefinition definition = new ProcessBuilderDefinition();
                        definition.setPackageId("wyjasnianie_kwestii_spornych");
                        definition.setCreator("admin");
                        definition.setVariables(variables);
                        definition.setProcessDefId(sProcessDefId);
                        sProcessId = ProcessManager.this.processService.createProcess(definition);
                        log.debug((Object)("Utworzono proces o id: " + sProcessId));
                        Map<String, Object> processContextMap = ProcessManager.this.processService.getProcessContext(sProcessId);
                        processContextMap = ProcessManager.this.setContextforOpenedProcess(processContextMap, dossier_to_open);
                        ProcessManager.this.processService.setProcessContext(sProcessId, processContextMap);
                        List openedActivities = ProcessManager.this.activityFinder.findOpenedActivities(sProcessId);
                        for (Activity wfActivity : openedActivities) {
                            String activityId = wfActivity.getActivityId();
                            log.debug((Object)"Aktualizowane zadanie to: ".concat(activityId));
                            Map activityContext = ProcessManager.this.activityService.getActivityContext(sProcessId, activityId);
                            activityContext.putAll(processContextMap);
                            ProcessManager.this.activityService.setActivityContext(sProcessId, activityId, activityContext);
                        }
                        log.debug((Object)("Variable values saved for : " + sProcessDefId));
                        log.debug((Object)"createDelegationProcess Finished succesful");
                    }
                    catch (Exception e) {
                        log.error((Object)("Creating processes error: " + e.getMessage()), (Throwable)e);
                        throw e;
                    }
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
                return sProcessId;
            }
        });
        return result;
    }

    private Map<String, Object> setContextforOpenedProcess(Map<String, Object> contextMap, DossierListElement doss) throws Exception {
        Dossier dossier = this.dossierDao.getByKey(doss.getPrimaryKey());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        contextMap.put("nr_dossier_ipao", String.valueOf(dossier.getNr_dossier()));
        contextMap.put("store_no", String.valueOf(dossier.getStore_no()));
        contextMap.put("ipao_date", sdf.format(dossier.getIpao_date()));
        Sklepy tmp_sklep = this.sklepyDao.getSklepyByNrCkd(dossier.getStore_no());
        Object sSklep = "";
        String sSymbolSklepu = "";
        if (tmp_sklep == null) {
            sSymbolSklepu = String.valueOf(dossier.getStore_no());
            sSklep = String.valueOf(dossier.getStore_no()) + " - BRAK DANYCH SKLEPU";
            throw new Exception("Brak definicji sklepu w tabeli sklepy!");
        }
        sSymbolSklepu = tmp_sklep.getSklep();
        sSklep = tmp_sklep.getSklep() + " - " + tmp_sklep.getOpis();
        contextMap.put("sklep", sSklep);
        MPK tmp_mpk = this.mpkDao.getMPKByNrCkd(dossier.getDzial());
        Object sDzial = "";
        sDzial = tmp_mpk == null ? String.valueOf(dossier.getDzial()) : tmp_mpk.getMpk() + " - " + tmp_mpk.getOpis();
        contextMap.put("dzial", sDzial);
        SimpleDateFormat sdf_year = new SimpleDateFormat("yyyy");
        String id_rozbieznosci = sdf_year.format(dossier.getIpao_date()) + "/" + sSymbolSklepu + "/" + String.valueOf(dossier.getNr_dossier());
        int iCount = GetDataFromProcess.checkDuplicate("kwestie_spo", "id_rozbieznosci", id_rozbieznosci);
        if (iCount > 0) {
            log.error((Object)("Tworze duplikat procesu wyjasnienia rozbieznosci o nr: " + id_rozbieznosci));
            id_rozbieznosci = id_rozbieznosci + "_DUPLIKAT";
        }
        contextMap.put("id_rozbieznosci", id_rozbieznosci);
        String supp_name = "";
        String sLocalTest = SystemProperties.getString((String)"CKD_LOCAL_TEST");
        if (!StringUtils.isEmpty((CharSequence)sLocalTest) && sLocalTest.compareTo("true") == 0) {
            supp_name = "LOCAL TEST";
        } else {
            JSONObject jsonResult = IPAO_WServices.getSuppilerData(dossier.getStore_no(), Integer.valueOf(dossier.getNr_dostawcy_ipao()));
            supp_name = jsonResult.getJSONObject("fourcom").getString("nomfou28");
        }
        contextMap.put("nazwa_dostawcy", supp_name);
        contextMap.put("nr_dostawcy_ipao", dossier.getNr_dostawcy_ipao());
        contextMap.put("numer_oracle", String.valueOf(dossier.getNr_oracle()));
        contextMap.put("data_zakwestionowania", sdf.format(dossier.getData_zakwestionowania()));
        contextMap.put("kwota_rozbieznosci_w_walucie", Functions.RoundValue(dossier.getKwota_rozbieznosci(), 2));
        contextMap.put("waluta", dossier.getWaluta());
        double kwota_pln = Functions.RoundValue(dossier.getKurs_spot() * dossier.getKwota_rozbieznosci(), 2);
        contextMap.put("kwota_rozbieznosci_w_pln", kwota_pln);
        contextMap.put("kurs_spot", Functions.RoundValue(dossier.getKurs_spot(), 2));
        contextMap.putAll(SetVariables.setZamFvatKosztyTables(contextMap, dossier, false));
        Map<String, Object> machedLines = SetVariables.matchLines(dossier, false);
        if (!contextMap.containsKey("ean")) {
            machedLines.remove("ean");
        }
        contextMap.putAll(machedLines);
        contextMap.putAll(SetVariables.sumTab(contextMap, false));
        double suma_wf = Functions.sumColumn((String)contextMap.get("roznica_w_f"));
        double tmp_roznica = dossier.getKwota_rozbieznosci();
        double pozostalo_do_przeanalizowania = tmp_roznica - suma_wf;
        contextMap.put("pozostalo_do_przeanalizowania", Functions.RoundValue(pozostalo_do_przeanalizowania, 2));
        Addresses adres_centrum_ksie = this.addressesDao.getAddressesByLocalization(sSymbolSklepu);
        if (adres_centrum_ksie != null) {
            contextMap.put("adres_centrum_ksie", adres_centrum_ksie.getAddress_ck());
        }
        long nr_zdz = Double.valueOf(Functions.changeStringToDouble(dossier.getNr_zdz())).intValue();
        contextMap.put("nr_zdz_z_ipao", nr_zdz);
        return contextMap;
    }

    public void reopenProcess(final DossierListElement dossier_to_open) throws Exception {
        log.info((Object)"****** przywracanie procesu dla dossier ".concat(dossier_to_open.keyToString()).concat(" ******"));
        final ActivityService activityService = ServiceFactory.getActivityService();
        final SharkTransactionManager mgr = TransactionManagerFactory.getSharkTransactionManager();
        TransactionTemplate tt = new TransactionTemplate((PlatformTransactionManager)mgr);
        tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                SharkTransaction st = null;
                String sProcessid = "";
                try {
                    st = mgr.getSharkTransaction();
                    ExecutionAdministration ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
                    String admin = SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
                    String password = SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
                    ea.connect(st, admin, password, "KlientTestowy", null);
                    sProcessid = dossier_to_open.getProcessid();
                    Map contextMap = ProcessManager.this.processService.getProcessContext(sProcessid);
                    contextMap.put("status", "W analizie ponownie");
                    ProcessManager.this.processService.setProcessContext(sProcessid, contextMap);
                    WfProcess wfProcess = SharkFunctions.GetWfProcess((ExecutionAdministration)ea, (String)sProcessid);
                    wfProcess.reopen(st);
                    String startedActivityId = ea.startActivity(st, sProcessid, null, "sprawdzanie_statusu_ipao", "admin");
                    activityService.setActivityContext(sProcessid, startedActivityId, contextMap);
                }
                catch (Exception ex) {
                    log.debug((Object)"Wzbudzanie procesu ".concat(sProcessid).concat(" nie powiod\u0142o si\u0119."));
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                    try {
                        st.rollback();
                    }
                    catch (TransactionException e1) {
                        log.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                    try {
                        throw ex;
                    }
                    catch (Exception e2) {
                        log.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                }
            }
        });
    }

    public void setContextforUpdatedProcess(String sProcessId, String sActivityId, Dossier dossier) throws Exception {
        Map contextMap = this.processService.getProcessContext(sProcessId);
        contextMap.put("kwota_rozbieznosci_w_walucie", Functions.RoundValue(dossier.getKwota_rozbieznosci(), 2));
        double kwota_pln = Functions.RoundValue(dossier.getKurs_spot() * dossier.getKwota_rozbieznosci(), 2);
        contextMap.put("kwota_rozbieznosci_w_pln", kwota_pln);
        contextMap.putAll(SetVariables.setZamFvatKosztyTables(contextMap, dossier, true));
        contextMap.putAll(SetVariables.updateLines(contextMap, dossier));
        contextMap.putAll(SetVariables.sumTab(contextMap, true));
        double suma_wf = Functions.sumColumn((String)contextMap.get("roznica_w_f"));
        double suma_waloryzacji = (Double)contextMap.get("suma_waloryzacji");
        double suma_faktur_netto = (Double)contextMap.get("suma_faktur_netto");
        double suma_pozostalych_kosztow = (Double)contextMap.get("suma_pozostalych_kosztow");
        double tmp_roznica = Functions.RoundValue(suma_waloryzacji - suma_faktur_netto, 2);
        double pozostalo_do_przeanalizowania = tmp_roznica - suma_wf + suma_pozostalych_kosztow;
        contextMap.put("pozostalo_do_przeanalizowania", Functions.RoundValue(pozostalo_do_przeanalizowania, 2));
        long nr_zdz = Double.valueOf(Functions.changeStringToDouble(dossier.getNr_zdz())).intValue();
        contextMap.put("nr_zdz_z_ipao", nr_zdz);
        this.activityService.setActivityContext(sProcessId, sActivityId, contextMap);
        this.processService.setProcessContext(sProcessId, contextMap);
    }

    @Transactional
    public void acceptAllActivities(String sProcessId, String sAkcja, String sStatus) throws Exception {
        log.info((Object)("ZAMYKANIE ZADAN procesu : " + sProcessId + ", akcja: " + sAkcja == null ? "BRAK AKCJI" : (sAkcja + ", status: " + sStatus == null ? "BRAK STATUSU" : sStatus)));
        try {
            HashMap<String, Object> valuesToSet = new HashMap<String, Object>();
            valuesToSet.put("akcja", sAkcja);
            valuesToSet.put("Action", sAkcja);
            if (sStatus.compareTo("") != 0) {
                valuesToSet.put("status", sStatus);
            }
            this.tools_ProcessManagerService.acceptActivity(sProcessId, null, valuesToSet);
            log.debug((Object)("ZAMYKANIE ZADAN procesu zakonczone sukcesem : " + sProcessId));
        }
        catch (Exception e) {
            log.error((Object)("ZAMYKANIE ZADAN: Nie udalo sie zamknac zadania procesu " + sProcessId + " :" + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean reopenProcessInDB(String processId) {
        Boolean answer = false;
        Connection conn = null;
        try {
            InitialContext initialContext = new InitialContext();
            DataSource dataSource = (DataSource)initialContext.lookup("java:comp/env/PlusWorkflowResource");
            conn = dataSource.getConnection();
            Statement stat = conn.createStatement();
            String sQuery = "UPDATE processes SET state=1000000 WHERE id='" + processId + "'";
            log.debug((Object)sQuery);
            stat.executeUpdate(sQuery);
            log.debug((Object)"Query executed");
            answer = true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return answer;
    }

    public void reopenProcessPW(final String sProcessid, final String sUser) throws Exception {
        log.info((Object)"****** przywracanie procesu PW ".concat(sProcessid).concat(" ******"));
        final ActivityService activityService = ServiceFactory.getActivityService();
        final SharkTransactionManager mgr = TransactionManagerFactory.getSharkTransactionManager();
        TransactionTemplate tt = new TransactionTemplate((PlatformTransactionManager)mgr);
        tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                SharkTransaction st = null;
                try {
                    st = mgr.getSharkTransaction();
                    ExecutionAdministration ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
                    String admin = SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
                    String password = SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
                    ea.connect(st, admin, password, "KlientTestowy", null);
                    ProcessService processService = ServiceFactory.getProcessService();
                    Map contextMap = processService.getProcessContext(sProcessid);
                    String status_dossier = (String)contextMap.get("status_dossier");
                    String status = "W DPT";
                    if (status_dossier.compareTo("Zamkniete-faktura") == 0 || status_dossier.compareTo("Zamkniete-LS") == 0 || status_dossier.compareTo("Zamkniete") == 0) {
                        status = "W KSIE";
                    }
                    contextMap.put("status", status);
                    contextMap.put("uzytkownik_uruchamiajacy", sUser);
                    processService.setProcessContext(sProcessid, contextMap);
                    WfProcess wfProcess = SharkFunctions.GetWfProcess((ExecutionAdministration)ea, (String)sProcessid);
                    wfProcess.reopen(st);
                    String startedActivityId = ea.startActivity(st, sProcessid, null, "pobieranie_danych", "admin");
                    activityService.setActivityContext(sProcessid, startedActivityId, contextMap);
                }
                catch (Exception ex) {
                    log.debug((Object)"Wzbudzanie procesu ".concat(sProcessid).concat(" nie powiod\u0142o si\u0119."));
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                    try {
                        st.rollback();
                    }
                    catch (TransactionException e1) {
                        log.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                    try {
                        throw ex;
                    }
                    catch (Exception e2) {
                        log.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                }
            }
        });
    }
}

