/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.integrations.ws;

import com.google.gson.Gson;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.util.extension.P0015.ckd.integrations.DossierTranslator;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.DossierKey;
import com.plusmpm.util.extension.P0015.ckd.integrations.ws.IPAOException;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class IPAO_WServices {
    public static Logger log = Logger.getLogger(IPAO_WServices.class);
    private static String CKD_WS_URL = SystemProperties.getString((String)"CKD_WS_URL");
    private static String CKD_WS_CHARSET = SystemProperties.getString((String)"CKD_WS_CHARSET");
    private static String CKD_WS_SKEY = SystemProperties.getString((String)"CKD_WS_SKEY");

    public static JSONArray getDossierListForShop(int store_no) throws Exception {
        log.info((Object)("** Integracje IPAO - WS1 get_list - Pobieranie listy dossier, nr sklepu: " + store_no));
        long startTime = new Date().getTime();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skey", CKD_WS_SKEY);
        map.put("method", "get_list");
        map.put("store_no", store_no);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("params", map);
        JSONObject resultJson = IPAO_WServices.getResponseFromWS(paramsMap);
        long stopTime = new Date().getTime();
        log.debug((Object)("** Integracje IPAO - Czas wykonywania WS1 dla sklepu " + store_no + ": " + CUFTools.plannedTaskDuration((long)(stopTime - startTime))));
        log.debug((Object)("** Integracje IPAO - WS1 get_list - status: " + resultJson.getString("status")));
        JSONArray dossierArray = (JSONArray)resultJson.get("dsm");
        log.info((Object)("** Integracje IPAO - WS1 get_list - ilosc dossier w sklepie: " + dossierArray.length()));
        return dossierArray;
    }

    public static JSONObject getAllRefData(int store_no, String sArticle) throws Exception {
        log.trace((Object)("** Integracje IPAO - WS2 - Pobieranie referencji, nr sklepu: " + store_no));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skey", CKD_WS_SKEY);
        map.put("method", "get_article");
        map.put("store_no", store_no);
        map.put("reflm", sArticle);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("params", map);
        return IPAO_WServices.getResponseFromWS(paramsMap);
    }

    public static JSONObject getDossierData(int store_no, String nr_dossier, Date ipao_date) throws Exception {
        log.debug((Object)("** Integracje IPAO - WS3 get_dossier - Pobieranie szczegolow dossier, nr sklepu: " + store_no + ", nr dossier: " + nr_dossier));
        long startTime = new Date().getTime();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skey", CKD_WS_SKEY);
        map.put("method", "get_dossier");
        map.put("store_no", store_no);
        map.put("num_dsm", nr_dossier);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DossierTranslator._ipao_date_format);
        map.put("dat_dsm", dateFormat.format(ipao_date));
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("params", map);
        JSONObject result = IPAO_WServices.getResponseFromWS(paramsMap);
        long stopTime = new Date().getTime();
        log.debug((Object)("** Integracje IPAO - Czas wykonywania WS3 dla sklepu " + store_no + " i dossier " + nr_dossier + ": " + CUFTools.plannedTaskDuration((long)(stopTime - startTime))));
        return result;
    }

    public static JSONObject getDossierData(DossierKey dossKey) throws Exception {
        return IPAO_WServices.getDossierData(dossKey.getStore_no(), String.valueOf(dossKey.getNr_dossier()), dossKey.getIpao_date());
    }

    public static JSONObject getSuppilerData(int store_no, int supplier_no) throws Exception {
        log.info((Object)("** Integracje IPAO - WS4 get_supplier_data - Pobieranie danych dostacy, nr sklepu: " + store_no + ", nr dostawcy: " + supplier_no));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skey", CKD_WS_SKEY);
        map.put("method", "get_supplier_data");
        map.put("store_no", store_no);
        map.put("codfou", supplier_no);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("params", map);
        return IPAO_WServices.getResponseFromWS(paramsMap);
    }

    public static JSONObject sendZDZ(int store_no, String nr_dossier, Date ipao_date, String motyw) throws Exception {
        log.info((Object)("** Integracje IPAO - WS9 - Wysylanie ZDZ, nr sklepu: " + store_no + ", nr dossier: " + nr_dossier));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skey", CKD_WS_SKEY);
        map.put("method", "set_bap");
        map.put("store_no", store_no);
        map.put("num_dsm", nr_dossier);
        map.put("motyw", motyw);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("params", map);
        return IPAO_WServices.getResponseFromWS(paramsMap);
    }

    public static JSONObject get_rec(int store_no, String sRecNo) throws Exception {
        log.info((Object)("** Integracje IPAO - REC - Pobieranie listy referencji, nr sklepu: " + store_no));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skey", CKD_WS_SKEY);
        map.put("method", "get_rec");
        map.put("store_no", store_no);
        map.put("num_rec", sRecNo);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("params", map);
        return IPAO_WServices.getResponseFromWS(paramsMap);
    }

    private static JSONObject getResponseFromWS(Map<String, Object> paramsMap) throws Exception {
        log.debug((Object)"** Integracje getResponseFromWS() -  wywolywanie WS z IPAO");
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        log.debug((Object)("CKD_WS_URL: " + CKD_WS_URL));
        URL url = new URL(CKD_WS_URL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setConnectTimeout(1800000);
        connection.setReadTimeout(1800000);
        log.debug((Object)("connection timeout " + connection.getConnectTimeout()));
        log.debug((Object)("connection readtimeout " + connection.getReadTimeout()));
        log.debug((Object)("CKD_WS_CHARSET: " + CKD_WS_CHARSET));
        connection.setRequestProperty("Accept-Charset", CKD_WS_CHARSET);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + CKD_WS_CHARSET);
        FilterOutputStream os = null;
        BufferedReader in = null;
        try {
            String decodedString;
            String jsonParams = new Gson().toJson(paramsMap);
            log.debug((Object)("** Integracje getResponseFromWS() - params=" + jsonParams));
            os = new DataOutputStream(connection.getOutputStream());
            ((DataOutputStream)os).writeBytes("params=" + URLEncoder.encode(jsonParams, CKD_WS_CHARSET));
            int responseCode = connection.getResponseCode();
            log.debug((Object)("** Integracje getResponseFromWS() - response code: " + responseCode));
            String responseMessage = connection.getResponseMessage();
            log.debug((Object)("** Integracje getResponseFromWS() - response message: " + responseMessage));
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            Object stringResult = "";
            while ((decodedString = in.readLine()) != null) {
                stringResult = (String)stringResult + decodedString;
            }
            log.debug((Object)("** Integracje getResponseFromWS() - response: " + (String)stringResult));
            JSONObject jsonResult = new JSONObject((String)stringResult);
            JSONObject resultSataus = jsonResult.getJSONObject("result");
            String sResultStatus = resultSataus.getString("result");
            log.debug((Object)("** Integracje getResponseFromWS() - status pobierania danych: " + sResultStatus));
            if (sResultStatus.compareTo("success") != 0) {
                String sError = jsonResult.getString("errors");
                log.debug((Object)("** Integracje getResponseFromWS() - blad z IPAO: " + sError));
                throw new IPAOException(sError);
            }
            jsonResult = jsonResult.getJSONObject("data");
            log.debug((Object)("** Integracje getResponseFromWS() - pobieranie danych zakonczone sukcesem: " + jsonResult.toString()));
            JSONObject jSONObject = jsonResult;
            return jSONObject;
        }
        catch (IPAOException ipaoe) {
            log.warn((Object)("** Integracje komunikat IPAO :" + ipaoe.getMessage()), (Throwable)ipaoe);
            throw ipaoe;
        }
        catch (Exception e) {
            log.error((Object)("** Integracje blad :" + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException logOrIgnore) {
                    log.error((Object)("** Integracje blad :" + logOrIgnore.getMessage()), (Throwable)logOrIgnore);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException logOrIgnore) {
                    log.error((Object)("** Integracje blad :" + logOrIgnore.getMessage()), (Throwable)logOrIgnore);
                }
            }
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception ex) {
                    log.error((Object)("** Integracje blad :" + ex.getMessage()), (Throwable)ex);
                }
            }
        }
    }
}

