/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.dao;

import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.DossierKey;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.DossierListElement;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.dao.DossierListElementDao;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="DossierListElementDao")
public class DossierListElementImpl
extends HibernateEditableDao<DossierListElement, DossierKey>
implements DossierListElementDao {
    public Logger log = Logger.getLogger(DossierListElementImpl.class);

    @Transactional
    public DossierKey save(DossierListElement dossierToAdd) {
        this.log.debug((Object)("************************* dodawanie dossier " + dossierToAdd.keyToString() + "  ********************"));
        return (DossierKey)super.save((Object)dossierToAdd);
    }

    @Transactional
    public void update(DossierListElement dossierToUpdate) {
        this.log.debug((Object)("************************* aktualizowanie dossier " + dossierToUpdate.keyToString() + "  ********************"));
        super.merge((Object)dossierToUpdate);
    }

    @Transactional
    public void delete(DossierListElement dossierToRemove) {
        this.log.debug((Object)("************************* usuwanie dossier " + dossierToRemove.keyToString() + " **************"));
        super.delete((Object)dossierToRemove);
    }

    @Override
    @Transactional
    public boolean checkIfExistsByKey(DossierKey key) {
        int store_no = key.getStore_no();
        long nr_dossier = key.getNr_dossier();
        Date ipao_date = key.getIpao_date();
        Session session = null;
        Object result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("select count(nr_dossier) from DossierListElement where store_no = :store_no and nr_dossier=:nr_dossier and ipao_date=:ipao_date").setParameter("store_no", (Object)store_no).setParameter("nr_dossier", (Object)nr_dossier).setParameter("ipao_date", (Object)ipao_date).uniqueResult();
            session.flush();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        String sTemp = String.valueOf(result);
        int iResult = Integer.valueOf(sTemp);
        return iResult > 0;
    }

    @Override
    @Transactional
    public DossierListElement getIfExistsByKey(DossierKey key) throws HibernateException {
        this.log.debug((Object)"*********getIfExistsByKey*********");
        int store_no = key.getStore_no();
        long nr_dossier = key.getNr_dossier();
        Date ipao_date = key.getIpao_date();
        Session session = null;
        DossierListElement result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = (DossierListElement)session.createQuery(" from DossierListElement where store_no = :store_no and nr_dossier=:nr_dossier and ipao_date=:ipao_date").setParameter("store_no", (Object)store_no).setParameter("nr_dossier", (Object)nr_dossier).setParameter("ipao_date", (Object)ipao_date).uniqueResult();
            session.flush();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public List<DossierListElement> getAllIpaoOpenNotUpdated(int store_no, Date last_update_date) throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("from DossierListElement  where store_no = :store_no and ipao_open = true and date_of_check<:date_of_check").setParameter("store_no", (Object)store_no).setParameter("date_of_check", (Object)last_update_date).list();
            session.flush();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage());
        }
        return result;
    }

    @Override
    @Transactional
    public List<DossierListElement> getAllToOpenInSod(int store_no) throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("from DossierListElement  where store_no = :store_no and ipao_open = true and sod_open = false").setParameter("store_no", (Object)store_no).list();
            session.flush();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage());
        }
        return result;
    }

    @Override
    @Transactional
    public List<DossierListElement> getAllToCloseInSod(int store_no) throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("from DossierListElement  where store_no = :store_no and ipao_open = false and sod_open = true").setParameter("store_no", (Object)store_no).list();
            session.flush();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage());
        }
        return result;
    }

    @Override
    @Transactional
    public List<DossierListElement> getAllToUpdateInSod(int store_no) throws HibernateException {
        Session session = null;
        List result = null;
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery("from DossierListElement  where store_no = :store_no and ipao_open = true and sod_open = true").setParameter("store_no", (Object)store_no).list();
            session.flush();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage());
        }
        return result;
    }
}

