/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.dao;

import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.Dossier;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierRecLine;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierRecLineKey;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.dao.DossierRecLineDao;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="DossierRecLineDao")
public class DossierRecLineImpl
extends HibernateEditableDao<DossierRecLine, DossierRecLineKey>
implements DossierRecLineDao {
    public Logger log = Logger.getLogger(DossierRecLineImpl.class);

    public DossierRecLineKey save(DossierRecLine recLineToAdd) {
        this.log.debug((Object)("************************* dodawanie linii zamowien " + recLineToAdd.getRec().getId() + "  ********************"));
        return (DossierRecLineKey)super.save((Object)recLineToAdd);
    }

    public void update(DossierRecLine recLineToUpdate) {
        this.log.debug((Object)("************************* aktualizacja linii zamowienia " + recLineToUpdate.getRec().getId() + "  ********************"));
        super.merge((Object)recLineToUpdate);
    }

    public void delete(DossierRecLine recLineToDelete) {
        this.log.debug((Object)("************************* usuwanie linii zamowinia " + recLineToDelete.getRec().getId() + "  ********************"));
        super.delete((Object)recLineToDelete);
    }

    @Override
    @Transactional
    public List<DossierRecLine> getRecLineByDossier(Dossier dossier) throws HibernateException {
        Session session = null;
        List<DossierRecLine> result = new ArrayList<DossierRecLine>();
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery(" from DossierRecLine where dossier = :dossier order by rec, nr_linii").setParameter("dossier", (Object)dossier).list();
            for (DossierRecLine line : result) {
                Hibernate.initialize((Object)line.getRec());
            }
            session.flush();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }
}

