/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.dao;

import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.Dossier;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierFvat;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierFvatLine;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierFvatLineKey;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.dao.DossierFvatLineDao;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="DossierFvatLineDao")
public class DossierFvatLineDaoImpl
extends HibernateEditableDao<DossierFvatLine, DossierFvatLineKey>
implements DossierFvatLineDao {
    public Logger log = Logger.getLogger(DossierFvatLineDaoImpl.class);

    public DossierFvatLineKey save(DossierFvatLine fvatLineToAdd) {
        this.log.debug((Object)("************************* dodawanie faktury " + fvatLineToAdd.getFvat().getId() + "  ********************"));
        return (DossierFvatLineKey)super.save((Object)fvatLineToAdd);
    }

    public void update(DossierFvatLine fvatLineToUpdate) {
        this.log.debug((Object)("************************* aktualizacja linii faktury " + fvatLineToUpdate.getFvat().getId() + "  ********************"));
        super.merge((Object)fvatLineToUpdate);
    }

    public void delete(DossierFvatLine fvatLineToDelete) {
        this.log.debug((Object)("************************* usuwanie faktury " + fvatLineToDelete.getFvat().getId() + "  ********************"));
        super.delete((Object)fvatLineToDelete);
    }

    @Override
    @Transactional
    public List<DossierFvatLine> getFvatLineByDossier(Dossier dossier) throws HibernateException {
        Session session = null;
        List<DossierFvatLine> result = new ArrayList<DossierFvatLine>();
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery(" from DossierFvatLine where dossier = :dossier order by fvat, nr_linii").setParameter("dossier", (Object)dossier).list();
            for (DossierFvatLine line : result) {
                Hibernate.initialize((Object)line.getFvat());
            }
            session.flush();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public List<DossierFvatLine> getFvatLineByDossierAndFvat(Dossier dossier, DossierFvat fvat) throws HibernateException {
        Session session = null;
        List<DossierFvatLine> result = new ArrayList<DossierFvatLine>();
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = session.createQuery(" from DossierFvatLine where dossier = :dossier and fvat=:fvat").setParameter("dossier", (Object)dossier.getId()).setParameter("fvat", (Object)fvat.getId()).list();
            session.flush();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }
}

