/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.dao;

import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.Dossier;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierFvat;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierFvatLine;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierRec;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierRecLine;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.dao.DossierDao;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.dao.DossierFvatDao;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.dao.DossierFvatLineDao;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.dao.DossierRecDao;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.dao.DossierRecLineDao;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.DossierKey;
import com.suncode.pwfl.support.HibernateEditableDao;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="DossierDao")
public class DossierDaoImpl
extends HibernateEditableDao<Dossier, Long>
implements DossierDao {
    public Logger log = Logger.getLogger(DossierDaoImpl.class);
    @Autowired
    private DossierRecDao dossierRecDao;
    @Autowired
    private DossierRecLineDao dossierRecLineDao;
    @Autowired
    private DossierFvatDao dossierFvatDao;
    @Autowired
    private DossierFvatLineDao dossierFvatLineDao;
    @Autowired
    private ProcessService processService;

    @Transactional
    public Long save(Dossier dossierToAdd) {
        this.log.debug((Object)("************************* dodawanie dossier " + dossierToAdd.keyToString() + "  ********************"));
        Long result = null;
        try {
            result = (Long)super.save((Object)dossierToAdd);
            dossierToAdd = (Dossier)this.get(result);
            this.log.debug((Object)"Po zapisie dossier");
            Map<Long, DossierRec> dossZam = dossierToAdd.getRec();
            TreeSet<Long> keys = new TreeSet<Long>(dossZam.keySet());
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                long order_no = (Long)iterator.next();
                DossierRec dossierRec = dossZam.get(order_no);
                dossierRec.setDossier(dossierToAdd);
                long idRec = (Long)this.dossierRecDao.save(dossierRec);
                dossierRec = (DossierRec)this.dossierRecDao.get(Long.valueOf(idRec));
                List<DossierRecLine> dossZamLines = dossierToAdd.getRec_line();
                for (DossierRecLine singleLine : dossZamLines) {
                    if (singleLine.getRec().getId_zamowienia() != order_no) continue;
                    singleLine.setRec(dossierRec);
                    singleLine.setDossier(dossierToAdd);
                    this.dossierRecLineDao.save(singleLine);
                }
            }
            this.log.debug((Object)"Po zapisie dossierRecLine");
            Map<Long, DossierFvat> dossFvat = dossierToAdd.getFvat();
            TreeSet<Long> fvat_keys = new TreeSet<Long>(dossFvat.keySet());
            Iterator iterator2 = fvat_keys.iterator();
            while (iterator2.hasNext()) {
                long fvat_no = (Long)iterator2.next();
                DossierFvat dossierFvatToSave = dossFvat.get(fvat_no);
                dossierFvatToSave.setDossier(dossierToAdd);
                long idDossierFvat = (Long)this.dossierFvatDao.save(dossierFvatToSave);
                dossierFvatToSave = (DossierFvat)this.dossierFvatDao.get(Long.valueOf(idDossierFvat));
                List<DossierFvatLine> dossFvatLines = dossierToAdd.getFvat_line();
                for (DossierFvatLine singleLine : dossFvatLines) {
                    if (singleLine.getFvat().getId_faktury() != fvat_no) continue;
                    singleLine.setFvat(dossierFvatToSave);
                    singleLine.setDossier(dossierToAdd);
                    this.dossierFvatLineDao.save(singleLine);
                }
            }
            this.getSession().flush();
            this.log.debug((Object)"Po zapisie dossierFvatLine");
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    public void update(Dossier dossierToUpdate) {
        this.log.debug((Object)("************************* aktualizowanie dossier " + dossierToUpdate.keyToString() + "  ********************"));
        super.merge((Object)dossierToUpdate);
    }

    public void delete(Dossier dossierToRemove) {
        this.log.debug((Object)("************************* usuwanie dossier " + dossierToRemove.keyToString() + " **************"));
        super.delete((Object)dossierToRemove);
    }

    @Override
    @Transactional
    public Dossier getByKey(DossierKey dossierToAdd) {
        this.log.debug((Object)("************************* pobieranie danych dossier " + dossierToAdd.keyToString() + "  ********************"));
        Dossier dossier = null;
        try {
            dossier = this.getIfExistsByKey(dossierToAdd.getStore_no(), dossierToAdd.getNr_dossier(), dossierToAdd.getIpao_date());
            if (dossier == null) {
                throw new Exception("Brak szczegolow wskazanego dossier");
            }
            Map<Long, DossierRec> rec = this.dossierRecDao.getRecByDossier(dossier);
            dossier.setRec(rec);
            List<DossierRecLine> rec_line = this.dossierRecLineDao.getRecLineByDossier(dossier);
            dossier.setRec_line(rec_line);
            Map<Long, DossierFvat> fvat = this.dossierFvatDao.getFvatByDossier(dossier);
            dossier.setFvat(fvat);
            List<DossierFvatLine> fvat_line = this.dossierFvatLineDao.getFvatLineByDossier(dossier);
            dossier.setFvat_line(fvat_line);
            return dossier;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return dossier;
        }
    }

    @Override
    @Transactional
    public Dossier getIfExistsByKey(int store_no, long nr_dossier, Date ipao_date) throws HibernateException {
        Session session = null;
        Dossier result = null;
        this.log.debug((Object)("store_no: " + store_no + " nr_dossier: " + nr_dossier + " ipao_date: " + String.valueOf(ipao_date)));
        try {
            session = this.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            result = (Dossier)session.createQuery(" from Dossier where store_no = :store_no and nr_dossier=:nr_dossier and ipao_date=:ipao_date").setParameter("store_no", (Object)store_no).setParameter("nr_dossier", (Object)nr_dossier).setParameter("ipao_date", (Object)ipao_date).uniqueResult();
            session.flush();
        }
        catch (HibernateException he) {
            this.log.error((Object)he.getMessage(), (Throwable)he);
        }
        return result;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(Dossier dossierToAdd) {
        this.log.debug((Object)("************************* zapis/aktualizacja dossier " + dossierToAdd.keyToString() + "  ********************"));
        boolean result = false;
        try {
            Dossier sod_dossier = this.getIfExistsByKey(dossierToAdd.getStore_no(), dossierToAdd.getNr_dossier(), dossierToAdd.getIpao_date());
            if (sod_dossier == null) {
                this.log.debug((Object)("zapis dossier w tabeli pm_ckd_dossier_header, store: " + dossierToAdd.getStore_no() + " nr dossier: " + dossierToAdd.getNr_dossier() + " ipao date: " + String.valueOf(dossierToAdd.getIpao_date())));
                this.save(dossierToAdd);
                result = true;
                this.log.debug((Object)("koniec zapisu nr dossier " + dossierToAdd.getNr_dossier()));
            } else {
                this.log.debug((Object)("dossier juz istnieje w tabeli pm_ckd_dossier_header, store: " + dossierToAdd.getStore_no() + " nr dossier: " + dossierToAdd.getNr_dossier() + " ipao date: " + String.valueOf(dossierToAdd.getIpao_date())));
                dossierToAdd.setId(sod_dossier.getId());
                dossierToAdd.setDate_of_update(new Date());
                this.update(dossierToAdd);
                if (dossierToAdd.getKwota_rozbieznosci() != sod_dossier.getKwota_rozbieznosci()) {
                    this.log.debug((Object)("*************************** kwota rozbieznosci ulegla zmiane, przed : " + sod_dossier.getKwota_rozbieznosci() + " kwota po " + dossierToAdd.getKwota_rozbieznosci() + " ***************************"));
                    result = true;
                }
                this.log.debug((Object)"*************************** weryfikacja listy zamowien  ***************************");
                Map<Long, DossierRec> rec_list_to_add = dossierToAdd.getRec();
                Map<Long, DossierRec> rec_list_sod = this.dossierRecDao.getRecByDossier(sod_dossier);
                Set<Long> key_set = rec_list_to_add.keySet();
                for (long key : key_set) {
                    DossierRec rec_to_ver = rec_list_to_add.get(key);
                    rec_to_ver.setDossier(dossierToAdd);
                    if (rec_list_sod.containsKey(key)) {
                        DossierRec rec_sod = rec_list_sod.get(key);
                        if (rec_sod.equal(rec_to_ver)) {
                            rec_to_ver.setId(rec_sod.getId());
                        } else {
                            this.log.debug((Object)("*************************** zamowienie " + rec_sod.getId_zamowienia() + " do aktualizacji ***************************"));
                            rec_to_ver.setId(rec_sod.getId());
                            this.dossierRecDao.update(rec_to_ver);
                            result = true;
                        }
                        rec_list_sod.remove(key);
                        continue;
                    }
                    this.log.debug((Object)("*************************** dodaje zamowienie " + rec_to_ver.getId_zamowienia() + " ***************************"));
                    this.dossierRecDao.save(rec_to_ver);
                    result = true;
                }
                if (rec_list_sod.size() > 0) {
                    this.log.debug((Object)("*************************** usuwam nadmiarowe zamowienia z SOD " + rec_list_sod.size() + " ***************************"));
                    Set<Long> rm_key_set = rec_list_sod.keySet();
                    for (long key : rm_key_set) {
                        this.dossierRecDao.delete(rec_list_sod.get(key));
                    }
                    result = true;
                }
                this.log.debug((Object)"*************************** weryfikacja listy linii zamowien  ***************************");
                List<DossierRecLine> rec_line_list_to_add = dossierToAdd.getRec_line();
                List<DossierRecLine> rec_line_list_sod = this.dossierRecLineDao.getRecLineByDossier(sod_dossier);
                for (DossierRecLine line_to_ver : rec_line_list_to_add) {
                    DossierRec tmp_rec = line_to_ver.getRec();
                    int nr_linii = line_to_ver.getNr_linii();
                    line_to_ver.setDossier(dossierToAdd);
                    DossierRecLine tmp_line_sod = null;
                    for (DossierRecLine line_sod : rec_line_list_sod) {
                        if (line_sod.getRec().getId_zamowienia() != tmp_rec.getId_zamowienia() || line_sod.getNr_linii() != nr_linii) continue;
                        tmp_line_sod = line_sod;
                        rec_line_list_sod.remove(line_sod);
                        break;
                    }
                    if (tmp_line_sod != null) {
                        if (tmp_line_sod.equal(line_to_ver)) {
                            line_to_ver = tmp_line_sod;
                            continue;
                        }
                        this.log.debug((Object)("*************************** linia zammowienia " + line_to_ver.getNr_linii() + " do aktualizacji ***************************"));
                        this.dossierRecLineDao.update(line_to_ver);
                        result = true;
                        continue;
                    }
                    this.log.debug((Object)("*************************** dodaje linie zammowienia " + line_to_ver.getNr_linii() + " ***************************"));
                    this.dossierRecLineDao.save(line_to_ver);
                    result = true;
                }
                if (rec_line_list_sod.size() > 0) {
                    this.log.debug((Object)"*************************** usuwanie starych linii zamowien ***************************");
                    for (DossierRecLine line_to_rm : rec_line_list_sod) {
                        this.dossierRecLineDao.delete(line_to_rm);
                    }
                    result = true;
                }
                this.log.debug((Object)"*************************** weryfikacja listy faktur  ***************************");
                Map<Long, DossierFvat> fvat_list_to_add = dossierToAdd.getFvat();
                Map<Long, DossierFvat> fvat_list_sod = this.dossierFvatDao.getFvatByDossier(sod_dossier);
                Set<Long> fvat_key_set = fvat_list_to_add.keySet();
                for (long key : fvat_key_set) {
                    DossierFvat fvat_to_ver = fvat_list_to_add.get(key);
                    fvat_to_ver.setDossier(dossierToAdd);
                    if (fvat_list_sod.containsKey(key)) {
                        DossierFvat fvat_sod = fvat_list_sod.get(key);
                        if (fvat_sod.equal(fvat_to_ver)) {
                            fvat_to_ver.setId(fvat_sod.getId());
                        } else {
                            this.log.debug((Object)("*************************** faktura " + fvat_sod.getNr_faktury() + " do aktualizacji ***************************"));
                            fvat_to_ver.setId(fvat_sod.getId());
                            this.dossierFvatDao.update(fvat_to_ver);
                            result = true;
                        }
                        fvat_list_sod.remove(key);
                        continue;
                    }
                    this.log.debug((Object)("*************************** dodaje fakture " + fvat_to_ver.getNr_faktury() + " ***************************"));
                    this.dossierFvatDao.save(fvat_to_ver);
                    result = true;
                }
                this.log.debug((Object)"*************************** weryfikacja listy linii faktur  ***************************");
                List<DossierFvatLine> fvat_line_list_to_add = dossierToAdd.getFvat_line();
                List<DossierFvatLine> fvat_line_list_sod = this.dossierFvatLineDao.getFvatLineByDossier(sod_dossier);
                for (DossierFvatLine line_to_ver : fvat_line_list_to_add) {
                    DossierFvat tmp_fvat = line_to_ver.getFvat();
                    int nr_linii = line_to_ver.getNr_linii();
                    line_to_ver.setDossier(dossierToAdd);
                    DossierFvatLine tmp_line_sod = null;
                    for (DossierFvatLine line_sod : fvat_line_list_sod) {
                        if (line_sod.getFvat().getId_faktury() != tmp_fvat.getId_faktury() || line_sod.getNr_linii() != nr_linii) continue;
                        tmp_line_sod = line_sod;
                        fvat_line_list_sod.remove(line_sod);
                        break;
                    }
                    if (tmp_line_sod != null) {
                        if (tmp_line_sod.equal(line_to_ver)) {
                            line_to_ver = tmp_line_sod;
                            continue;
                        }
                        this.log.debug((Object)("*************************** linia faktury " + line_to_ver.getNr_linii() + " do aktualizacji ***************************"));
                        this.dossierFvatLineDao.update(line_to_ver);
                        result = true;
                        continue;
                    }
                    this.log.debug((Object)("*************************** dodaje linie fakture " + line_to_ver.getNr_linii() + " ***************************"));
                    this.dossierFvatLineDao.save(line_to_ver);
                    result = true;
                }
                if (fvat_line_list_sod.size() > 0) {
                    this.log.debug((Object)("*************************** usuwanie starych linii faktury " + fvat_line_list_sod.size() + " ***************************"));
                    for (DossierFvatLine line_to_rm : fvat_line_list_sod) {
                        this.dossierFvatLineDao.delete(line_to_rm);
                    }
                    result = true;
                }
                if (fvat_list_sod.size() > 0) {
                    this.log.debug((Object)("*************************** usuwam nadmiarowe faktury z SOD " + fvat_list_sod.size() + " ***************************"));
                    Set<Long> rm_fvat_key_set = fvat_list_sod.keySet();
                    for (long key : rm_fvat_key_set) {
                        this.dossierFvatDao.delete(fvat_list_sod.get(key));
                    }
                    result = true;
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return result;
    }

    @Override
    @Transactional
    public boolean isDossierChanged(Dossier dossierToCheck, String sProcessid) {
        this.log.debug((Object)("************************* weryfikacja zmian w dossier " + dossierToCheck.keyToString() + "  ********************"));
        this.log.debug((Object)dossierToCheck.getNr_dossier());
        boolean result = false;
        try {
            Dossier sod_dossier = this.getIfExistsByKey(dossierToCheck.getStore_no(), dossierToCheck.getNr_dossier(), dossierToCheck.getIpao_date());
            if (sod_dossier == null) {
                return true;
            }
            this.log.debug((Object)"*************************** 1. weryfikacja listy zamowien  ***************************");
            Map<Long, DossierRec> rec_list_to_ver = dossierToCheck.getRec();
            this.log.debug(rec_list_to_ver);
            Map<Long, DossierRec> rec_list_sod = this.dossierRecDao.getRecByDossier(sod_dossier);
            this.log.debug(rec_list_sod);
            Set<Long> key_set = rec_list_to_ver.keySet();
            for (long key : key_set) {
                this.log.debug((Object)key);
                DossierRec rec_to_ver = rec_list_to_ver.get(key);
                if (rec_list_sod.containsKey(key)) {
                    DossierRec rec_sod = rec_list_sod.get(key);
                    this.log.debug((Object)rec_sod.getId_zamowienia());
                    this.log.debug((Object)rec_to_ver.getId_zamowienia());
                    if (!rec_sod.equal(rec_to_ver)) {
                        this.log.debug((Object)("*************************** zamowienie" + rec_sod.getId_zamowienia() + " do aktualizacji ***************************"));
                        return true;
                    }
                    this.log.debug((Object)"*************************** zamowienie niezmienione ***************************");
                    rec_list_sod.remove(key);
                    continue;
                }
                this.log.debug((Object)("*************************** do zamowienia nalezy dodac nowe zamowienie " + rec_to_ver.getId_zamowienia() + " do aktualizacji ***************************"));
                return true;
            }
            if (rec_list_sod.size() > 0) {
                this.log.debug((Object)("*************************** w SOD wiecej zamowien niz w IPAO nadmiarowo: " + rec_list_sod.size() + " do aktualizacji ***************************"));
                result = true;
            }
            this.log.debug((Object)"*************************** 2. weryfikacja listy linii zamowien  ***************************");
            List<DossierRecLine> rec_line_list_to_ver = dossierToCheck.getRec_line();
            List<DossierRecLine> rec_line_list_sod = this.dossierRecLineDao.getRecLineByDossier(sod_dossier);
            for (DossierRecLine line_to_ver : rec_line_list_to_ver) {
                DossierRec tmp_rec = line_to_ver.getRec();
                int nr_linii = line_to_ver.getNr_linii();
                DossierRecLine tmp_line_sod = null;
                for (DossierRecLine line_sod : rec_line_list_sod) {
                    if (line_sod.getRec().getId_zamowienia() != tmp_rec.getId_zamowienia() || line_sod.getNr_linii() != nr_linii) continue;
                    tmp_line_sod = line_sod;
                    rec_line_list_sod.remove(line_sod);
                    break;
                }
                if (tmp_line_sod != null) {
                    if (tmp_line_sod.equal(line_to_ver)) {
                        this.log.debug((Object)"*************************** linia zamowienia niezmieniona ***************************");
                        continue;
                    }
                    this.log.debug((Object)("*************************** linia zammowienia " + line_to_ver.getNr_linii() + " do aktualizacji ***************************"));
                    return true;
                }
                this.log.debug((Object)("*************************** do linii zamowienia nalezy dodac nowe linie " + line_to_ver.getNr_linii() + " do aktualizacji ***************************"));
                return true;
            }
            if (rec_line_list_sod.size() > 0) {
                this.log.debug((Object)("*************************** w SOD wiecej linii zamowien niz w IPAO nadmiarowo: " + rec_line_list_sod.size() + " do aktualizacji ***************************"));
                return true;
            }
            this.log.debug((Object)"*************************** 3. weryfikacja listy faktur  ***************************");
            Map<Long, DossierFvat> fvat_list_to_ver = dossierToCheck.getFvat();
            Map<Long, DossierFvat> fvat_list_sod = this.dossierFvatDao.getFvatByDossier(sod_dossier);
            Set<Long> fvat_key_set = fvat_list_to_ver.keySet();
            this.log.debug((Object)("processid: " + sProcessid));
            Map mProcessMap = this.processService.getProcessContext(sProcessid);
            String sNrFaktury = mProcessMap.get("numer_faktury").toString();
            this.log.debug((Object)("numer_faktury: " + sNrFaktury));
            String[] NrFaktury = Functions.splitStringIntoTable(sNrFaktury, ";");
            ArrayList<String> atemp = new ArrayList<String>();
            for (int i = 0; i < NrFaktury.length; ++i) {
                if (atemp.contains(NrFaktury[i])) continue;
                atemp.add(NrFaktury[i]);
            }
            NrFaktury = atemp.toArray(new String[atemp.size()]);
            ArrayList<String> afvat_to_ver = new ArrayList<String>();
            for (long k : fvat_key_set) {
                String sfvat_to_ver = fvat_list_to_ver.get(k).getNr_faktury();
                if (afvat_to_ver.contains(sfvat_to_ver)) continue;
                afvat_to_ver.add(sfvat_to_ver);
            }
            String[] Faktury_IPAO = afvat_to_ver.toArray(new String[afvat_to_ver.size()]);
            int check = 0;
            for (String fakt : NrFaktury) {
                for (String faktIPAO : Faktury_IPAO) {
                    this.log.debug((Object)("Faktura z procesu: " + fakt));
                    this.log.debug((Object)("Faktura z IPAO: " + faktIPAO));
                    if (fakt.compareToIgnoreCase(faktIPAO) != 0) continue;
                    this.log.debug((Object)("fakt.compareToIgnoreCase(faktIPAO): " + ++check));
                }
            }
            if (NrFaktury.length != check || Faktury_IPAO.length != check || NrFaktury.length != Faktury_IPAO.length) {
                this.log.debug((Object)"Lista Nr faktur si\u0119 nie zgadza");
                this.log.debug((Object)("NrFaktury.length: " + NrFaktury.length));
                this.log.debug((Object)("Faktury_IPAO.length: " + Faktury_IPAO.length));
                this.log.debug((Object)("check: " + check));
                return true;
            }
            Iterator<Long> k = fvat_key_set.iterator();
            while (k.hasNext()) {
                long key = (Long)k.next();
                DossierFvat fvat_to_ver = fvat_list_to_ver.get(key);
                if (fvat_list_sod.containsKey(key)) {
                    DossierFvat fvat_sod = fvat_list_sod.get(key);
                    this.log.debug((Object)("fvat_sod: " + fvat_sod.getNr_faktury() + "|"));
                    this.log.debug((Object)("fvat_to_ver: " + fvat_to_ver.getNr_faktury() + "|"));
                    if (!fvat_sod.equal(fvat_to_ver)) {
                        this.log.debug((Object)("*************************** faktura " + fvat_sod.getNr_faktury() + " do aktualizacji ***************************"));
                        return true;
                    }
                    this.log.debug((Object)"*************************** faktura niezmieniona ***************************");
                    fvat_list_sod.remove(key);
                    continue;
                }
                this.log.debug((Object)("*************************** do faktur nalezy dodac nowa  " + fvat_to_ver.getNr_faktury() + " do aktualizacji ***************************"));
                return true;
            }
            if (fvat_list_sod.size() > 0) {
                this.log.debug((Object)("*************************** w SOD wiecej faktur niz w IPAO nadmiarowo: " + fvat_list_sod.size() + " do aktualizacji ***************************"));
                return true;
            }
            this.log.debug((Object)"*************************** 4. weryfikacja listy linii faktur  ***************************");
            List<DossierFvatLine> fvat_line_list_to_ver = dossierToCheck.getFvat_line();
            List<DossierFvatLine> fvat_line_list_sod = this.dossierFvatLineDao.getFvatLineByDossier(sod_dossier);
            for (DossierFvatLine line_to_ver : fvat_line_list_to_ver) {
                DossierFvat tmp_fvat = line_to_ver.getFvat();
                int nr_linii = line_to_ver.getNr_linii();
                DossierFvatLine tmp_line_sod = null;
                for (DossierFvatLine line_sod : fvat_line_list_sod) {
                    if (line_sod.getFvat().getId_faktury() != tmp_fvat.getId_faktury() || line_sod.getNr_linii() != nr_linii) continue;
                    tmp_line_sod = line_sod;
                    fvat_line_list_sod.remove(line_sod);
                    this.log.debug((Object)("line_sod.getFvat().getId_faktury(): " + line_sod.getFvat().getId_faktury()));
                    this.log.debug((Object)("tmp_fvat.getId_faktury(): " + tmp_fvat.getId_faktury()));
                    this.log.debug((Object)("line_sod.getNr_linii(): " + line_sod.getNr_linii()));
                    this.log.debug((Object)("nr_linii: " + nr_linii));
                    break;
                }
                if (tmp_line_sod != null) {
                    if (tmp_line_sod.equal(line_to_ver)) {
                        this.log.debug((Object)"*************************** linia faktury niezmieniona ***************************");
                        continue;
                    }
                    this.log.debug((Object)("*************************** linia faktury " + line_to_ver.getNr_linii() + " do aktualizacji ***************************"));
                    this.log.debug((Object)line_to_ver.getFvat());
                    return true;
                }
                this.log.debug((Object)("*************************** do linii faktur nalezy dodac nowe linie " + line_to_ver.getNr_linii() + " do aktualizacji ***************************"));
                return true;
            }
            if (fvat_line_list_sod.size() > 0) {
                this.log.debug((Object)("*************************** w SOD wiecej linii faktur niz w IPAO nadmiarowo: " + fvat_line_list_sod.size() + " do aktualizacji ***************************"));
                return true;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            try {
                throw e;
            }
            catch (Exception e1) {
                this.log.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        this.log.debug((Object)result);
        return result;
    }
}

