/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata;

import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.Dossier;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierRec;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierRecLineKey;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="pm_ckd_dossier_rec_line")
@IdClass(value=DossierRecLineKey.class)
public class DossierRecLine {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dossier")
    private Dossier dossier;
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="rec")
    private DossierRec rec;
    @Id
    private int nr_linii;
    @Column(name="referencja_lm")
    private String referencja_lm;
    @Column(name="opis")
    private String opis;
    @Column(name="przelicznik")
    private double przelicznik;
    @Column(name="jednostka_przel")
    private String jednostka_przel;
    @Column(name="ilosc_wz")
    private double ilosc_wz;
    @Column(name="uszkodzenia")
    private double uszkodzenia;
    @Column(name="ilosc_zwalo")
    private double ilosc_zwalo;
    @Column(name="cena")
    private double cena;
    @Column(name="ean")
    private String ean;

    public DossierRecLine() {
    }

    public DossierRecLine(DossierRecLine line) {
        this.dossier = line.dossier;
        this.rec = line.rec;
        this.nr_linii = line.nr_linii;
        this.referencja_lm = line.referencja_lm;
        this.opis = line.opis;
        this.przelicznik = line.przelicznik;
        this.jednostka_przel = line.jednostka_przel;
        this.ilosc_wz = line.ilosc_wz;
        this.uszkodzenia = line.uszkodzenia;
        this.ilosc_zwalo = line.ilosc_zwalo;
        this.cena = line.cena;
    }

    public Dossier getDossier() {
        return this.dossier;
    }

    public void setDossier(Dossier dossier) {
        this.dossier = dossier;
    }

    public DossierRec getRec() {
        return this.rec;
    }

    public void setRec(DossierRec rec) {
        this.rec = rec;
    }

    public int getNr_linii() {
        return this.nr_linii;
    }

    public void setNr_linii(int nr_linii) {
        this.nr_linii = nr_linii;
    }

    public String getReferencja_lm() {
        return this.referencja_lm;
    }

    public void setReferencja_lm(String referencja_lm) {
        this.referencja_lm = referencja_lm;
    }

    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    public double getPrzelicznik() {
        return this.przelicznik;
    }

    public void setPrzelicznik(double przelicznik) {
        this.przelicznik = przelicznik;
    }

    public String getJednostka_przel() {
        if (this.jednostka_przel == null) {
            return "";
        }
        return this.jednostka_przel;
    }

    public void setJednostka_przel(String jednostka_przel) {
        this.jednostka_przel = jednostka_przel;
    }

    public double getIlosc_wz() {
        return this.ilosc_wz;
    }

    public void setIlosc_wz(double ilosc_wz) {
        this.ilosc_wz = ilosc_wz;
    }

    public double getUszkodzenia() {
        return this.uszkodzenia;
    }

    public void setUszkodzenia(double uszkodzenia) {
        this.uszkodzenia = uszkodzenia;
    }

    public double getIlosc_zwalo() {
        return this.ilosc_zwalo;
    }

    public void setIlosc_zwalo(double ilosc_zwalo) {
        this.ilosc_zwalo = ilosc_zwalo;
    }

    public double getCena() {
        return Functions.RoundValue(this.cena, 2);
    }

    public void setCena(double cena) {
        this.cena = cena;
    }

    public String getEan() {
        return this.ean;
    }

    public void setEan(String ean) {
        this.ean = ean;
    }

    public boolean equal(DossierRecLine rec_line) {
        boolean result = true;
        if (StringUtils.isEmpty((CharSequence)this.referencja_lm) && !StringUtils.isEmpty((CharSequence)rec_line.getReferencja_lm()) || !StringUtils.isEmpty((CharSequence)rec_line.getReferencja_lm()) && this.referencja_lm.compareTo(rec_line.getReferencja_lm()) != 0) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.opis) && !StringUtils.isEmpty((CharSequence)rec_line.getOpis()) || !StringUtils.isEmpty((CharSequence)rec_line.getOpis()) && this.opis.compareTo(rec_line.getOpis()) != 0) {
            return false;
        }
        if (this.getIlosc_wz() != rec_line.getIlosc_wz()) {
            return false;
        }
        if (this.getUszkodzenia() != rec_line.getUszkodzenia()) {
            return false;
        }
        if (this.getIlosc_zwalo() != rec_line.getIlosc_zwalo()) {
            return false;
        }
        if (this.getCena() != rec_line.getCena()) {
            return false;
        }
        return result;
    }
}

