/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata;

import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.Dossier;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="pm_ckd_dossier_rec")
@SequenceGenerator(name="dossier_rec_seq", sequenceName="dossier_rec_seq")
public class DossierRec {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="dossier_rec_seq")
    @Column(name="id", unique=true, nullable=false)
    private long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dossier", nullable=false)
    private Dossier dossier;
    @Column(name="id_zamowienia")
    private long id_zamowienia;
    @Column(name="nr_zamowienia")
    private long nr_zamowienia;
    @Column(name="data_zamowienia")
    private Date data_zamowienia;
    @Column(name="odbior")
    private long odbior;
    @Column(name="data_odbioru")
    private Date data_odbioru;
    @Column(name="data_waloryzacji")
    private Date data_waloryzacji;
    @Column(name="kwota_zwalo")
    private double kwota_zwalo;
    @Column(name="kwota_boni")
    private double kwota_boni;
    @Column(name="kwota_franco")
    private double kwota_franco;
    @Column(name="wielkosc_franco")
    private double wielkosc_franco;
    @Column(name="jednostka_franco")
    private String jednostka_franco;
    @Column(name="tryb_odbioru")
    private String tryb_odbioru;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Dossier getDossier() {
        return this.dossier;
    }

    public void setDossier(Dossier dossier) {
        this.dossier = dossier;
    }

    public long getId_zamowienia() {
        return this.id_zamowienia;
    }

    public void setId_zamowienia(long id_zamowienia) {
        this.id_zamowienia = id_zamowienia;
    }

    public long getNr_zamowienia() {
        return this.nr_zamowienia;
    }

    public void setNr_zamowienia(long nr_zamowienia) {
        this.nr_zamowienia = nr_zamowienia;
    }

    public Date getData_zamowienia() {
        return this.data_zamowienia;
    }

    public void setData_zamowienia(Date data_zamowienia) {
        this.data_zamowienia = data_zamowienia;
    }

    public long getOdbior() {
        return this.odbior;
    }

    public void setOdbior(long odbior) {
        this.odbior = odbior;
    }

    public Date getData_odbioru() {
        return this.data_odbioru;
    }

    public void setData_odbioru(Date data_odbioru) {
        this.data_odbioru = data_odbioru;
    }

    public Date getData_waloryzacji() {
        return this.data_waloryzacji;
    }

    public void setData_waloryzacji(Date data_waloryzacji) {
        this.data_waloryzacji = data_waloryzacji;
    }

    public double getKwota_zwalo() {
        return Functions.RoundValue(this.kwota_zwalo, 2);
    }

    public void setKwota_zwalo(double kwota_zwalo) {
        this.kwota_zwalo = kwota_zwalo;
    }

    public double getKwota_boni() {
        return Functions.RoundValue(this.kwota_boni, 2);
    }

    public void setKwota_boni(double kwota_boni) {
        this.kwota_boni = kwota_boni;
    }

    public double getKwota_franco() {
        return Functions.RoundValue(this.kwota_franco, 2);
    }

    public void setKwota_franco(double kwota_franco) {
        this.kwota_franco = kwota_franco;
    }

    public double getWielkosc_franco() {
        return Functions.RoundValue(this.wielkosc_franco, 2);
    }

    public void setWielkosc_franco(double wielkosc_franco) {
        this.wielkosc_franco = wielkosc_franco;
    }

    public String getJednostka_franco() {
        return this.jednostka_franco;
    }

    public void setJednostka_franco(String jednostka_franco) {
        this.jednostka_franco = jednostka_franco;
    }

    public String getTryb_odbioru() {
        if (StringUtils.isEmpty((CharSequence)this.tryb_odbioru)) {
            return "";
        }
        if (this.tryb_odbioru.compareToIgnoreCase("c") == 0) {
            return "liczenie";
        }
        if (this.tryb_odbioru.compareToIgnoreCase("s") == 0) {
            return "sonda\u017c";
        }
        return this.tryb_odbioru;
    }

    public void setTryb_odbioru(String tryb_odbioru) {
        this.tryb_odbioru = tryb_odbioru;
    }

    public boolean equal(DossierRec rec_to_compare) {
        boolean result = true;
        if (this.data_zamowienia == null && rec_to_compare.getData_zamowienia() != null || rec_to_compare.getData_zamowienia() != null && rec_to_compare.getData_zamowienia().compareTo(this.data_zamowienia) != 0) {
            return false;
        }
        if (this.odbior != rec_to_compare.getOdbior()) {
            return false;
        }
        if (this.data_odbioru == null && rec_to_compare.getData_odbioru() != null || rec_to_compare.getData_odbioru() != null && this.data_odbioru.compareTo(rec_to_compare.getData_odbioru()) != 0) {
            return false;
        }
        if (this.data_waloryzacji == null && rec_to_compare.getData_waloryzacji() != null || rec_to_compare.getData_waloryzacji() != null && this.data_waloryzacji.compareTo(rec_to_compare.getData_waloryzacji()) != 0) {
            return false;
        }
        if (this.getKwota_zwalo() != rec_to_compare.getKwota_zwalo()) {
            return false;
        }
        if (this.getKwota_boni() != rec_to_compare.getKwota_boni()) {
            return false;
        }
        if (this.getKwota_franco() != rec_to_compare.getKwota_franco()) {
            return false;
        }
        if (this.getWielkosc_franco() != rec_to_compare.getWielkosc_franco()) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.jednostka_franco) && !StringUtils.isEmpty((CharSequence)rec_to_compare.getJednostka_franco()) || !StringUtils.isEmpty((CharSequence)rec_to_compare.getJednostka_franco()) && this.jednostka_franco.compareToIgnoreCase(rec_to_compare.getJednostka_franco()) != 0) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.getTryb_odbioru()) && !StringUtils.isEmpty((CharSequence)rec_to_compare.getTryb_odbioru()) || !StringUtils.isEmpty((CharSequence)rec_to_compare.getTryb_odbioru()) && this.getTryb_odbioru().compareToIgnoreCase(rec_to_compare.getTryb_odbioru()) != 0) {
            return false;
        }
        return result;
    }
}

