/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata;

import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.Dossier;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierFvat;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierFvatLineKey;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@Entity
@Table(name="pm_ckd_dossier_fvat_line")
@IdClass(value=DossierFvatLineKey.class)
public class DossierFvatLine {
    public static Logger log = Logger.getLogger(DossierFvatLine.class);
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dossier")
    private Dossier dossier;
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fvat")
    private DossierFvat fvat;
    @Id
    private int nr_linii;
    @Column(name="referencja_lm")
    private String referencja_lm;
    @Column(name="opis")
    private String opis;
    @Column(name="ilosc")
    private double ilosc;
    @Column(name="cena")
    private double cena;
    @Column(name="typ_kosztu")
    private String typ_kosztu;
    @Column(name="kwota_kosztu")
    private double kwota_kosztu;
    @Column(name="ean")
    private String ean;

    public DossierFvatLine() {
    }

    public DossierFvatLine(DossierFvatLine line) {
        this.dossier = line.dossier;
        this.fvat = line.fvat;
        this.nr_linii = line.nr_linii;
        this.referencja_lm = line.referencja_lm;
        this.opis = line.opis;
        this.ilosc = line.ilosc;
        this.cena = line.cena;
        this.typ_kosztu = line.typ_kosztu;
        this.kwota_kosztu = line.kwota_kosztu;
    }

    public Dossier getDossier() {
        return this.dossier;
    }

    public void setDossier(Dossier dossier) {
        this.dossier = dossier;
    }

    public DossierFvat getFvat() {
        return this.fvat;
    }

    public void setFvat(DossierFvat fvat) {
        this.fvat = fvat;
    }

    public int getNr_linii() {
        return this.nr_linii;
    }

    public void setNr_linii(int nr_linii) {
        this.nr_linii = nr_linii;
    }

    public String getReferencja_lm() {
        return this.referencja_lm;
    }

    public void setReferencja_lm(String referencja_lm) {
        this.referencja_lm = referencja_lm;
    }

    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    public double getIlosc() {
        return this.ilosc;
    }

    public void setIlosc(double ilosc) {
        this.ilosc = ilosc;
    }

    public double getCena() {
        return Functions.RoundValue(this.cena, 2);
    }

    public void setCena(double cena) {
        this.cena = cena;
    }

    public String getTyp_kosztu() {
        return this.typ_kosztu;
    }

    public void setTyp_kosztu(String typ_kosztu) {
        this.typ_kosztu = typ_kosztu;
    }

    public double getKwota_kosztu() {
        return Functions.RoundValue(this.kwota_kosztu, 2);
    }

    public void setKwota_kosztu(double kwota_kosztu) {
        this.kwota_kosztu = kwota_kosztu;
    }

    public String getEan() {
        return this.ean;
    }

    public void setEan(String ean) {
        this.ean = ean;
    }

    public boolean equal(DossierFvatLine fvat_line) {
        boolean result = true;
        if (StringUtils.isEmpty((CharSequence)this.getTyp_kosztu()) && !StringUtils.isEmpty((CharSequence)fvat_line.getTyp_kosztu()) || !StringUtils.isEmpty((CharSequence)fvat_line.getTyp_kosztu()) && this.getTyp_kosztu().compareToIgnoreCase(fvat_line.getTyp_kosztu()) != 0) {
            log.debug((Object)("Zmieniono typ kosztu old: " + this.getTyp_kosztu() + " new: " + fvat_line.getTyp_kosztu()));
            return false;
        }
        if (!StringUtils.isEmpty((CharSequence)this.getTyp_kosztu()) && this.getTyp_kosztu().compareToIgnoreCase("F") == 0) {
            if (this.getKwota_kosztu() != fvat_line.getKwota_kosztu()) {
                return false;
            }
            if (!StringUtils.isEmpty((CharSequence)this.opis) && StringUtils.isEmpty((CharSequence)fvat_line.getOpis()) || !StringUtils.isEmpty((CharSequence)fvat_line.getOpis()) && this.opis.compareTo(fvat_line.getOpis()) != 0) {
                return false;
            }
        } else if (StringUtils.isEmpty((CharSequence)this.referencja_lm) && !StringUtils.isEmpty((CharSequence)fvat_line.getReferencja_lm()) || !StringUtils.isEmpty((CharSequence)fvat_line.getReferencja_lm()) && this.referencja_lm.compareTo(fvat_line.getReferencja_lm()) != 0) {
            log.debug((Object)("Zmieniono referencej old: " + this.opis + " new: " + fvat_line.getOpis()));
            log.debug((Object)fvat_line.getReferencja_lm());
            log.debug((Object)this.referencja_lm);
            log.debug((Object)fvat_line.getIlosc());
            log.debug((Object)fvat_line.getCena());
            log.debug((Object)this.fvat);
            log.debug((Object)fvat_line.getFvat());
            return false;
        }
        return result;
    }
}

