/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata;

import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.Dossier;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="pm_ckd_dossier_fvat")
@SequenceGenerator(name="dossier_fvat_seq", sequenceName="dossier_fvat_seq")
public class DossierFvat {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="dossier_fvat_seq")
    @Column(name="id", unique=true, nullable=false)
    private long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dossier", nullable=false)
    private Dossier dossier;
    @Column(name="id_faktury")
    private long id_faktury;
    @Column(name="protokol")
    private long protokol;
    @Column(name="typ")
    private char typ;
    @Column(name="rodzaj")
    private String rodzaj;
    @Column(name="nr_faktury")
    private String nr_faktury;
    @Column(name="data_faktury")
    private Date data_faktury;
    @Column(name="suma_brutto")
    private double suma_brutto;
    @Column(name="suma_netto")
    private double suma_netto;
    @Column(name="data_zdz")
    private Date data_zdz;
    @Column(name="termin_platnosci")
    private Date termin_platnosci;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Dossier getDossier() {
        return this.dossier;
    }

    public void setDossier(Dossier dossier) {
        this.dossier = dossier;
    }

    public long getId_faktury() {
        return this.id_faktury;
    }

    public void setId_faktury(long id_faktury) {
        this.id_faktury = id_faktury;
    }

    public long getProtokol() {
        return this.protokol;
    }

    public void setProtokol(long protokol) {
        this.protokol = protokol;
    }

    public char getTyp() {
        if (this.typ == 'A') {
            return 'K';
        }
        return this.typ;
    }

    public void setTyp(char typ) {
        this.typ = typ;
    }

    public String getRodzaj() {
        if (StringUtils.isEmpty((CharSequence)this.rodzaj)) {
            return "";
        }
        if (this.rodzaj.compareTo("M") == 0) {
            return "PAP";
        }
        if (this.rodzaj.compareTo("E") == 0) {
            return "EDI";
        }
        return this.rodzaj;
    }

    public void setRodzaj(String rodzaj) {
        this.rodzaj = rodzaj;
    }

    public String getNr_faktury() {
        return this.nr_faktury;
    }

    public void setNr_faktury(String nr_faktury) {
        this.nr_faktury = nr_faktury;
    }

    public Date getData_faktury() {
        return this.data_faktury;
    }

    public void setData_faktury(Date data_faktury) {
        this.data_faktury = data_faktury;
    }

    public double getSuma_brutto() {
        return Functions.RoundValue(this.suma_brutto, 2);
    }

    public void setSuma_brutto(double suma_brutto) {
        this.suma_brutto = suma_brutto;
    }

    public double getSuma_netto() {
        return Functions.RoundValue(this.suma_netto, 2);
    }

    public void setSuma_netto(double suma_netto) {
        this.suma_netto = suma_netto;
    }

    public Date getData_zdz() {
        return this.data_zdz;
    }

    public void setData_zdz(Date data_zdz) {
        this.data_zdz = data_zdz;
    }

    public Date getTermin_platnosci() {
        return this.termin_platnosci;
    }

    public void setTermin_platnosci(Date termin_platnosci) {
        this.termin_platnosci = termin_platnosci;
    }

    public boolean equal(DossierFvat fvat_to_compare) {
        boolean result = true;
        if (this.protokol != fvat_to_compare.getProtokol()) {
            return false;
        }
        if (this.getTyp() != fvat_to_compare.getTyp()) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.getRodzaj()) && !StringUtils.isEmpty((CharSequence)fvat_to_compare.getRodzaj()) || !StringUtils.isEmpty((CharSequence)fvat_to_compare.getRodzaj()) && this.getRodzaj().compareToIgnoreCase(fvat_to_compare.getRodzaj()) != 0) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.getNr_faktury()) && !StringUtils.isEmpty((CharSequence)fvat_to_compare.getNr_faktury()) || !StringUtils.isEmpty((CharSequence)fvat_to_compare.getNr_faktury()) && this.getNr_faktury().compareToIgnoreCase(fvat_to_compare.getNr_faktury()) != 0) {
            return false;
        }
        if (this.data_faktury == null && fvat_to_compare.getData_faktury() != null || fvat_to_compare.getData_faktury() != null && this.data_faktury.compareTo(fvat_to_compare.getData_faktury()) != 0) {
            return false;
        }
        if (this.getSuma_brutto() != fvat_to_compare.getSuma_brutto()) {
            return false;
        }
        if (this.getSuma_netto() != fvat_to_compare.getSuma_netto()) {
            return false;
        }
        if (this.data_zdz == null && fvat_to_compare.getData_zdz() != null || fvat_to_compare.getData_zdz() != null && this.data_zdz.compareTo(fvat_to_compare.getData_zdz()) != 0) {
            return false;
        }
        return result;
    }
}

