/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.integrations;

import com.plusmpm.util.extension.P0015.ckd.CKDTools;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.Dossier;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierFvat;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierFvatLine;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierRec;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierRecLine;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.DossierKey;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.DossierListElement;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.dao.DossierListElementDao;
import com.plusmpm.util.extension.P0015.ckd.integrations.ws.IPAO_WServices;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DossierTranslator {
    public static Logger log = Logger.getLogger(DossierTranslator.class);
    @Autowired
    private DossierListElementDao dossierListElementDao;
    public static String _ipao_date_format = "dd/MM/yyyy";
    public static String _zgrupowane = "ZGRUPOWANE";

    public void synchronizeAllFromShop(int store_no) throws Exception {
        log.info((Object)("**** dodawanie/aktualizacja dossier SKLEP " + store_no + " ****"));
        JSONArray ipaoOpen = IPAO_WServices.getDossierListForShop(store_no);
        log.info((Object)("**** ilosc do zweryfikowania " + ipaoOpen.length() + " ****"));
        Date date_of_check = new Date();
        for (int i = 0; i < ipaoOpen.length(); ++i) {
            JSONObject dossierJSON = ipaoOpen.getJSONObject(i);
            this.addOrUpdateDossier(dossierJSON, store_no, date_of_check);
        }
        log.debug((Object)"**** zmiana statusu dossier ktorych nie ma na liscie na ipao_open=false ****");
        List<DossierListElement> to_close = this.dossierListElementDao.getAllIpaoOpenNotUpdated(store_no, date_of_check);
        log.info((Object)("**** ilosc dossier do zmiany statusu na ipao_open=false " + to_close.size() + " ****"));
        for (DossierListElement dossier_to_change : to_close) {
            this.updateDossierListElement(dossier_to_change, date_of_check);
        }
    }

    @Transactional
    private void updateDossierListElement(DossierListElement dossier_to_change, Date date_of_check) throws Exception {
        dossier_to_change.closeInIpao();
        dossier_to_change.setDate_of_check(date_of_check);
        this.dossierListElementDao.update(dossier_to_change);
        log.debug((Object)("**** zmieniono status dossier " + dossier_to_change.keyToString()));
    }

    @Transactional
    private void addOrUpdateDossier(JSONObject dossierJSON, int store_no, Date date_of_check) throws Exception {
        try {
            long nr_dossier = dossierJSON.getLong("num_dsm");
            Date ipao_date = DossierTranslator.changeStringToDate(dossierJSON.getString("dat_dsm"));
            log.trace((Object)("**** weryfikacja dossier " + nr_dossier + " ze sklepu " + store_no));
            DossierKey dossKey = new DossierKey(store_no, nr_dossier, ipao_date);
            DossierListElement dossElem = this.dossierListElementDao.getIfExistsByKey(dossKey);
            if (dossElem != null) {
                log.debug((Object)("**** dossier " + nr_dossier + " ze sklepu " + store_no + " ISTNIEJE aktualizuje wpis w tabeli pm_ckd_dossier_list "));
                dossElem.setDate_of_check(date_of_check);
                dossElem.setIpao_open(true);
                this.dossierListElementDao.update(dossElem);
            } else {
                log.debug((Object)("**** dossier " + nr_dossier + " ze sklepu " + store_no + " BRAK tworze wpis w tabeli pm_ckd_dossier_list "));
                dossElem = new DossierListElement(dossKey);
                dossElem.setDate_of_check(date_of_check);
                dossElem.setIpao_open(true);
                DossierKey returnedDossierKey = (DossierKey)this.dossierListElementDao.save(dossElem);
                log.debug((Object)("**** returned dossier " + returnedDossierKey.getNr_dossier() + " ze sklepu " + returnedDossierKey.getStore_no()));
                DossierListElement dossElemAfterSave = this.dossierListElementDao.getIfExistsByKey(dossKey);
                if (dossElemAfterSave != null) {
                    log.debug((Object)("Powodzenie zapisu do tabeli, dossier: " + nr_dossier));
                } else {
                    log.debug((Object)("Niepowodzenie zapisu do tabeli, dossier: " + nr_dossier));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static Dossier getAllDossierData(DossierKey dossKey) throws Exception {
        String mess;
        log.debug((Object)("****** getAllDossierData() - POBIERANIE DANYCH DOSSIER " + dossKey.keyToString() + " ******"));
        JSONObject dossierJSON = IPAO_WServices.getDossierData(dossKey);
        if (!dossierJSON.has("dsm") && (mess = dossierJSON.getString("description")).indexOf(_zgrupowane) >= 0) {
            throw new Exception(_zgrupowane);
        }
        JSONObject headerJSON = dossierJSON.getJSONObject("dsm");
        Dossier dossier = DossierTranslator.getDossierHeader(headerJSON);
        JSONObject zamJSON = dossierJSON.getJSONObject("rec");
        JSONArray suppJSON = dossierJSON.getJSONArray("condliv");
        dossier.setRec(DossierTranslator.getOrderList(dossier, zamJSON, suppJSON));
        JSONObject zamLinesJSON = null;
        List<DossierRecLine> rec_lines = new ArrayList<DossierRecLine>();
        if (dossierJSON.optJSONObject("linie_rec") != null) {
            zamLinesJSON = dossierJSON.getJSONObject("linie_rec");
            log.debug((Object)("linie_rec: " + zamLinesJSON.toString()));
            rec_lines = DossierTranslator.getOrderLinesList(dossier, zamLinesJSON);
        }
        dossier.setRec_line(rec_lines);
        JSONObject fvatJSON = dossierJSON.getJSONObject("fvat");
        log.debug((Object)("fvat: " + fvatJSON.toString()));
        dossier.setFvat(DossierTranslator.getFvatList(dossier, fvatJSON, headerJSON));
        JSONObject fvatLinesJSON = dossierJSON.getJSONObject("linie_fvat");
        log.debug((Object)("linie_fvat: " + fvatLinesJSON.toString()));
        List<DossierFvatLine> fvat_lines = DossierTranslator.getFvatLinesList(dossier, fvatLinesJSON);
        dossier.setFvat_line(fvat_lines);
        return dossier;
    }

    public static Dossier getDossierHeader(JSONObject headerJSON) throws Exception {
        Dossier dossier = new Dossier();
        dossier.setStore_no(headerJSON.getInt("codcentfu"));
        log.debug((Object)("store no" + headerJSON.getInt("codcentfu")));
        dossier.setNr_dossier(headerJSON.getInt("numdoss"));
        log.debug((Object)("nr dossier" + headerJSON.getInt("numdoss")));
        dossier.setIpao_date(DossierTranslator.changeStringToDate(headerJSON.getString("datcreat")));
        log.debug((Object)("ipao date" + String.valueOf(DossierTranslator.changeStringToDate(headerJSON.getString("datcreat")))));
        dossier.setDzial(headerJSON.getString("numray"));
        dossier.setData_zakwestionowania(DossierTranslator.changeStringToDate(headerJSON.getString("datcreat")));
        dossier.setNr_dostawcy_ipao(headerJSON.getString("numfoucial"));
        dossier.setNr_oracle(headerJSON.getString("numfoujuri"));
        dossier.setKwota_rozbieznosci(headerJSON.getDouble("monecardos"));
        dossier.setWaluta(headerJSON.getString("coddevfou"));
        dossier.setKurs_spot(headerJSON.getDouble("taux_change"));
        dossier.setNr_zdz(headerJSON.getString("numbap"));
        return dossier;
    }

    public static Map<Long, DossierRec> getOrderList(Dossier dossier, JSONObject ordersJSON, JSONArray condliv) throws Exception {
        log.trace((Object)"****** getOrderList() - Pobieranie listy zam\u00f3wie\u0144 ******");
        HashMap<Long, DossierRec> dossierOrders = new HashMap<Long, DossierRec>();
        Iterator it = ordersJSON.keys();
        log.trace((Object)"****** getOrderList() - Pobieranie danych dostawcy dla zamowien ******");
        String jednostka_franco = "";
        double wielkosc_franco = 0.0;
        try {
            if (condliv.length() > 0) {
                JSONObject tmp = condliv.getJSONObject(0);
                wielkosc_franco = tmp.getDouble("val_fco");
                jednostka_franco = tmp.getString("lib_unifco");
            }
        }
        catch (Exception ex) {
            log.error((Object)("Blad parsowania danych: " + ex.getMessage()), (Throwable)ex);
        }
        while (it.hasNext()) {
            String order_no = (String)it.next();
            JSONObject orderJSON = ordersJSON.getJSONObject(order_no);
            DossierRec singleOrder = new DossierRec();
            singleOrder.setDossier(dossier);
            singleOrder.setId_zamowienia(Long.valueOf(order_no));
            singleOrder.setNr_zamowienia(orderJSON.getLong("numcde"));
            singleOrder.setData_zamowienia(DossierTranslator.changeStringToDate(orderJSON.getString("datcde")));
            singleOrder.setOdbior(orderJSON.getLong("numrecmag"));
            singleOrder.setData_odbioru(DossierTranslator.changeStringToDate(orderJSON.getString("datrec1")));
            singleOrder.setData_waloryzacji(DossierTranslator.changeStringToDate(orderJSON.getString("datvalrec")));
            singleOrder.setKwota_zwalo(orderJSON.getDouble("monvalrec"));
            singleOrder.setKwota_boni(orderJSON.getDouble("montboni"));
            singleOrder.setWielkosc_franco(wielkosc_franco);
            singleOrder.setJednostka_franco(jednostka_franco);
            singleOrder.setTryb_odbioru(orderJSON.getString("modrec2"));
            dossierOrders.put(Long.valueOf(order_no), singleOrder);
        }
        return dossierOrders;
    }

    public static List<DossierRecLine> getOrderLinesList(Dossier dossier, JSONObject ordersLinesJSON) throws Exception {
        log.debug((Object)"****** getOrderLinesList() - Pobieranie listy linii zamowien ******");
        ArrayList<DossierRecLine> dossierOrderLines = new ArrayList<DossierRecLine>();
        Iterator it = ordersLinesJSON.keys();
        while (it.hasNext()) {
            String sOrder_no = (String)it.next();
            long order_no = Long.valueOf(sOrder_no);
            JSONObject orderJSON = null;
            if (ordersLinesJSON.optJSONObject(sOrder_no) == null) continue;
            orderJSON = ordersLinesJSON.getJSONObject(sOrder_no);
            Iterator itLines = orderJSON.keys();
            while (itLines.hasNext()) {
                String current_line = (String)itLines.next();
                JSONObject lineJSON = orderJSON.getJSONObject(current_line);
                DossierRecLine singleLine = new DossierRecLine();
                DossierRec recForLine = dossier.getRec().get(order_no);
                singleLine.setDossier(dossier);
                singleLine.setRec(recForLine);
                singleLine.setNr_linii(Integer.valueOf(current_line));
                singleLine.setReferencja_lm(lineJSON.getString("numart").trim());
                singleLine.setOpis(lineJSON.getString("desart").trim());
                if (lineJSON.getString("valcontart").compareTo("null") != 0) {
                    singleLine.setPrzelicznik(lineJSON.getDouble("valcontart"));
                }
                if (lineJSON.getString("libunitcontart").compareTo("null") != 0) {
                    singleLine.setJednostka_przel(lineJSON.getString("libunitcontart"));
                }
                singleLine.setIlosc_wz(lineJSON.getDouble("qteartvalo"));
                singleLine.setCena(lineJSON.getDouble("priachrec"));
                singleLine.setIlosc_zwalo(lineJSON.getDouble("ilosc_wal"));
                if (lineJSON.getString("qteartcasse").compareTo("null") != 0) {
                    singleLine.setUszkodzenia(lineJSON.getDouble("qteartcasse"));
                }
                singleLine.setEan(lineJSON.getString("codeancde"));
                dossierOrderLines.add(singleLine);
            }
        }
        return dossierOrderLines;
    }

    public static Map<Long, DossierFvat> getFvatList(Dossier dossier, JSONObject fvatsJSON, JSONObject jsonHeader) throws Exception {
        log.trace((Object)"****** getFvatList() - Pobieranie listy faktur ******");
        HashMap<Long, DossierFvat> dossierFvats = new HashMap<Long, DossierFvat>();
        Iterator it = fvatsJSON.keys();
        String warunki_platnosci = "";
        try {
            warunki_platnosci = jsonHeader.getString("codcondpaie");
        }
        catch (Exception ex) {
            log.error((Object)("Blad parsowania danych: " + ex.getMessage()), (Throwable)ex);
        }
        while (it.hasNext()) {
            JSONObject invoiceJSON = fvatsJSON.getJSONObject((String)it.next());
            DossierFvat singleFvat = new DossierFvat();
            singleFvat.setDossier(dossier);
            singleFvat.setId_faktury(invoiceJSON.getLong("ordfactfou"));
            singleFvat.setProtokol(invoiceJSON.getLong("numdanreg"));
            singleFvat.setTyp(invoiceJSON.getString("codnatfact").charAt(0));
            singleFvat.setRodzaj(invoiceJSON.getString("typemet"));
            singleFvat.setNr_faktury(invoiceJSON.getString("numfactavori").trim());
            singleFvat.setData_faktury(DossierTranslator.changeStringToDate(invoiceJSON.getString("datfactav")));
            singleFvat.setSuma_brutto(invoiceJSON.getDouble("ttcfacfou"));
            double sumaNetto = invoiceJSON.getDouble("mhtmarfou") + invoiceJSON.getDouble("mhtfraifou");
            singleFvat.setSuma_netto(sumaNetto);
            if (!StringUtils.isBlank((CharSequence)invoiceJSON.getString("datbap"))) {
                singleFvat.setData_zdz(DossierTranslator.changeStringToDate(invoiceJSON.getString("datbap")));
            }
            if (!StringUtils.isBlank((CharSequence)warunki_platnosci)) {
                Map<Long, DossierRec> rec = dossier.getRec();
                Set<Long> set = rec.keySet();
                for (Long key : set) {
                    Date dDataOdbioru = rec.get(key).getData_odbioru();
                    Date dTermin = CKDTools.getTerminPlatnosci(warunki_platnosci.trim(), dDataOdbioru, singleFvat.getData_faktury());
                    if (dTermin == null) continue;
                    singleFvat.setTermin_platnosci(dTermin);
                }
            }
            dossierFvats.put(invoiceJSON.getLong("ordfactfou"), singleFvat);
        }
        return dossierFvats;
    }

    public static List<DossierFvatLine> getFvatLinesList(Dossier dossier, JSONObject fvatlinesJSON) throws Exception {
        log.debug((Object)"****** getFvatLinesList() - Pobieranie listy linii faktur ******");
        ArrayList<DossierFvatLine> dossierFvatLines = new ArrayList<DossierFvatLine>();
        Iterator it = fvatlinesJSON.keys();
        while (it.hasNext()) {
            String sFvat_id = (String)it.next();
            long fvat_id = Long.valueOf(sFvat_id);
            JSONObject fvatJSON = null;
            if (fvatlinesJSON.optJSONObject(sFvat_id) == null) continue;
            fvatJSON = fvatlinesJSON.getJSONObject(sFvat_id);
            Iterator itLines = fvatJSON.keys();
            while (itLines.hasNext()) {
                String current_line = (String)itLines.next();
                JSONObject lineJSON = fvatJSON.getJSONObject(current_line);
                DossierFvatLine singleLine = new DossierFvatLine();
                DossierFvat fvat = dossier.getFvat().get(fvat_id);
                singleLine.setDossier(dossier);
                singleLine.setFvat(fvat);
                singleLine.setNr_linii(Integer.valueOf(current_line));
                singleLine.setReferencja_lm(lineJSON.getString("reflm").trim());
                singleLine.setOpis(lineJSON.getString("opis_ref").trim());
                singleLine.setIlosc(lineJSON.getDouble("qtefact"));
                singleLine.setCena(lineJSON.getDouble("priligfou"));
                if (fvat.getTyp() == 'A') {
                    singleLine.setIlosc(-1.0 * lineJSON.getDouble("qtefact"));
                    singleLine.setCena(-1.0 * lineJSON.getDouble("priligfou"));
                }
                singleLine.setTyp_kosztu(lineJSON.getString("typligfac"));
                if (singleLine.getTyp_kosztu().compareToIgnoreCase("F") == 0) {
                    singleLine.setOpis(lineJSON.getString("desligfac").trim());
                    singleLine.setKwota_kosztu(lineJSON.getDouble("mhtligfou"));
                }
                singleLine.setEan(lineJSON.getString("codean"));
                dossierFvatLines.add(singleLine);
            }
        }
        return dossierFvatLines;
    }

    public static Date changeStringToDate(String sDate) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(_ipao_date_format);
        Date date = dateFormat.parse(sDate);
        return date;
    }
}

