/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.integrations;

import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.ckd.integrations.DossierTranslator;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.Dossier;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.dao.DossierDao;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.DossierKey;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.DossierListElement;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.dao.DossierListElementDao;
import com.plusmpm.util.extension.P0015.ckd.processTools.ProcessManager;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DossierManager {
    public static Logger log = Logger.getLogger(DossierManager.class);
    @Autowired
    private ProcessManager processManagerService;
    @Autowired
    private DossierDao dossierDao;
    @Autowired
    private DossierListElementDao dossierListElementDao;

    public void openAllFromShop(int store_no, boolean update, Date dataOd) {
        Object not_opened = "";
        try {
            List<DossierListElement> dossierToOpen = this.dossierListElementDao.getAllToOpenInSod(store_no);
            log.info((Object)("**** otwieranie/pryzwracanie procesow SKLEP " + store_no + ", ilosc do zweryfikowania " + dossierToOpen.size() + " ****"));
            for (DossierListElement dossier_from_list : dossierToOpen) {
                not_opened = (String)not_opened + this.openFromShop(update, dataOd, dossier_from_list);
            }
        }
        catch (Exception e) {
            log.error((Object)("**** blad aktualizacji elementu listy dossier " + e.getMessage()), (Throwable)e);
        }
        if (((String)not_opened).compareTo("") != 0) {
            log.warn((Object)("**** Niekt\u00f3rych procesow nie udalo sie utworzyc/przywrocis " + (String)not_opened));
        }
    }

    @Transactional
    private String openFromShop(boolean update, Date dataOd, DossierListElement dossier_from_list) {
        Object not_opened = "";
        try {
            if (update) {
                log.debug((Object)("**** Aktualizacja danych dossier " + dossier_from_list.keyToString() + " ****"));
                Dossier dossier = DossierTranslator.getAllDossierData(dossier_from_list.getPrimaryKey());
                this.updateDossierDataIfChanged(dossier);
                dossier_from_list.setMessage(Functions.getCurrentDate("yyyy-MM-dd HH:mm:ss.S") + ": updated for open");
            }
            if (StringUtils.isBlank((CharSequence)dossier_from_list.getProcessid())) {
                if (dossier_from_list.getPrimaryKey().getIpao_date().compareTo(dataOd) >= 0) {
                    DossierKey key = dossier_from_list.getPrimaryKey();
                    if (this.processExist(key)) {
                        log.debug((Object)("**** proces dla dossier " + dossier_from_list.keyToString() + " ISTNIEJE ju\u017c w systemie PlusWorkflow ****"));
                    } else {
                        log.debug((Object)("**** TWORZENIE procesu dla dossier " + dossier_from_list.keyToString() + " ****"));
                        String sDossierProcessid = this.processManagerService.createProcess(dossier_from_list);
                        dossier_from_list.setProcessid(sDossierProcessid);
                        log.debug((Object)("sDossierProcessid: " + sDossierProcessid));
                        log.debug((Object)("**** zmieniono status dossier na sod_open " + dossier_from_list.keyToString()));
                        dossier_from_list.setSod_start_date(new Date());
                        dossier_from_list.setSod_open(true);
                        this.dossierListElementDao.update(dossier_from_list);
                        log.debug((Object)("ustawiono w tabeli pm_ckd_dossier_list processid " + dossier_from_list.getProcessid()));
                    }
                } else {
                    log.debug((Object)("**** NIE UTWORZONO procesu dla dossier " + dossier_from_list.keyToString() + " ****"));
                }
            } else {
                log.debug((Object)("**** PRZYWRACANIE procesu " + dossier_from_list.getProcessid() + " ****"));
                this.processManagerService.reopenProcess(dossier_from_list);
                log.debug((Object)("**** zmieniono status dossier na sod_open " + dossier_from_list.keyToString()));
                dossier_from_list.setSod_start_date(new Date());
                dossier_from_list.setSod_open(true);
                this.dossierListElementDao.update(dossier_from_list);
                this.processManagerService.acceptAllActivities(dossier_from_list.getProcessid(), "ipao", "W analizie ponownie");
            }
        }
        catch (Exception eo) {
            log.error((Object)("**** blad podczas pobieraniadanych badz otwierania procesu dla dossier " + dossier_from_list.keyToString() + ", error:" + eo.getMessage()), (Throwable)eo);
            not_opened = (String)not_opened + "{" + dossier_from_list.keyToString() + "},";
            try {
                String mess = eo.getMessage();
                if (!StringUtils.isBlank((CharSequence)mess) && mess.length() > 255) {
                    mess = mess.substring(0, 250);
                }
                dossier_from_list.setMessage(mess);
                this.dossierListElementDao.update(dossier_from_list);
            }
            catch (Exception ex) {
                log.error((Object)("Blad aktualizacji wpisu z listy dossier: " + ex.getMessage()), (Throwable)ex);
            }
        }
        return not_opened;
    }

    public void closeAllFromShop(int store_no, boolean update) {
        Object not_closed = "";
        try {
            List<DossierListElement> dossierToClose = this.dossierListElementDao.getAllToCloseInSod(store_no);
            log.info((Object)("**** zamykanie zadan dla dossier SKLEP " + store_no + ", ilosc do zweryfikowania " + dossierToClose.size() + " ****"));
            for (DossierListElement dossier_from_list : dossierToClose) {
                not_closed = (String)not_closed + this.acceptActivities(dossier_from_list);
            }
        }
        catch (Exception e) {
            log.error((Object)("**** blad zamykania zadan da zamknietych dossier " + e.getMessage()), (Throwable)e);
        }
        if (((String)not_closed).compareTo("") != 0) {
            log.warn((Object)("**** Niekt\u00f3rych procesow nie udalo sie zamknac " + (String)not_closed));
        }
    }

    @Transactional
    private String acceptActivities(DossierListElement dossier_from_list) {
        log.debug((Object)("**ProcessId: " + dossier_from_list.getProcessid() + "**"));
        Object not_closed = "";
        try {
            this.processManagerService.acceptAllActivities(dossier_from_list.getProcessid(), "ipao", "ZDZ");
        }
        catch (Exception eo) {
            log.error((Object)("**** blad podczas zamykania procesu dla dossier " + dossier_from_list.keyToString() + ", error:" + eo.getMessage()), (Throwable)eo);
            not_closed = (String)not_closed + "{" + dossier_from_list.keyToString() + "},";
            String mess = eo.getMessage();
            if (!StringUtils.isBlank((CharSequence)mess) && mess.length() > 255) {
                mess = mess.substring(0, 250);
            }
            dossier_from_list.setMessage(mess);
            this.dossierListElementDao.update(dossier_from_list);
        }
        return not_closed;
    }

    public void updateAllFromShop(int store_no, boolean update) {
        Object not_updated = "";
        try {
            List<DossierListElement> dossierToUpdate = this.dossierListElementDao.getAllToUpdateInSod(store_no);
            log.info((Object)("**** aktualizacja procesow dla dossier SKLEP " + store_no + ", ilosc do zweryfikowania " + dossierToUpdate.size() + " ****"));
            for (DossierListElement dossier_from_list : dossierToUpdate) {
                not_updated = (String)not_updated + this.acceptActivityOrUpdateData(dossier_from_list);
            }
        }
        catch (Exception e) {
            log.error((Object)("**** blad akrualizacji procesowe dla dossier " + e.getMessage()), (Throwable)e);
        }
        if (((String)not_updated).compareTo("") != 0) {
            log.warn((Object)("**** Niekt\u00f3rych procesow nie udalo sie zaktualizowac " + (String)not_updated));
        }
    }

    @Transactional
    private String acceptActivityOrUpdateData(DossierListElement dossier_from_list) {
        Object not_updated = "";
        try {
            if (this.checkIfDossierChanged(dossier_from_list.getPrimaryKey(), dossier_from_list.getProcessid())) {
                log.info((Object)("**** dane procesu zostaly zmienione, akceptuje zadanie " + dossier_from_list.keyToString() + " ****"));
                this.processManagerService.acceptAllActivities(dossier_from_list.getProcessid(), "ipao", "");
            } else {
                log.debug((Object)("**** dane procesu bez zmian " + dossier_from_list.keyToString() + " ****"));
                dossier_from_list.setMessage(Functions.getCurrentDate("yyyy-MM-dd HH:mm:ss.S") + ": no changes");
                this.dossierListElementDao.update(dossier_from_list);
            }
        }
        catch (Exception eo) {
            log.error((Object)("**** blad podczas aktualizacji procesu dla dossier " + dossier_from_list.keyToString() + ", error:" + eo.getMessage()), (Throwable)eo);
            not_updated = (String)not_updated + "{" + dossier_from_list.keyToString() + "},";
            String mess = eo.getMessage();
            if (!StringUtils.isBlank((CharSequence)mess) && mess.length() > 244) {
                mess = mess.substring(0, 244);
            }
            dossier_from_list.setMessage(Functions.getCurrentDate("yyyy-MM-dd") + ":" + mess);
            this.dossierListElementDao.update(dossier_from_list);
        }
        return not_updated;
    }

    @Transactional
    public boolean updateDossierDataIfChanged(Dossier dossier) throws Exception {
        DossierListElement dossier_from_list;
        log.debug((Object)("**** aktualizacja danych dossier SKLEP " + dossier.getStore_no() + ", dossier " + dossier.getNr_dossier() + " ****"));
        boolean result = false;
        result = this.dossierDao.saveOrUpdate(dossier);
        if (result && (dossier_from_list = this.dossierListElementDao.getIfExistsByKey(new DossierKey(dossier.getStore_no(), dossier.getNr_dossier(), dossier.getIpao_date()))) != null) {
            dossier_from_list.setMessage("updated: " + String.valueOf(new Date()));
            this.dossierListElementDao.update(dossier_from_list);
        }
        return result;
    }

    public boolean checkIfDossierChanged(DossierKey dossKey, String sProcessid) throws Exception {
        log.debug((Object)("**** weryfikacja zmiany danych dossier SKLEP " + dossKey.getStore_no() + ", dossier " + dossKey.getNr_dossier() + " ****sProcessid " + sProcessid));
        boolean result = false;
        Dossier dossier = DossierTranslator.getAllDossierData(dossKey);
        result = this.dossierDao.isDossierChanged(dossier, sProcessid);
        return result;
    }

    public void closeDossierInSod(String store_no, String dossier_no, String ipao_date) throws Exception {
        this.closeDossierInSod(Integer.valueOf(store_no), Integer.valueOf(dossier_no).intValue(), Functions.convertStringToDate(ipao_date, "yyyy-MM-dd"));
    }

    public void closeDossierInSod(int store_no, long dossier_no, Date ipao_date) throws Exception {
        log.debug((Object)("**** zamykanie dossier SKLEP " + store_no + ", dossier " + dossier_no + " ****"));
        DossierKey doss_key = new DossierKey(store_no, dossier_no, ipao_date);
        DossierListElement doss_elem = this.dossierListElementDao.getIfExistsByKey(doss_key);
        if (doss_elem == null) {
            throw new Exception("Nie odnaleziono wskazanego dossier na liscie");
        }
        doss_elem.setSod_open(false);
        this.dossierListElementDao.update(doss_elem);
    }

    private boolean processExist(DossierKey dossierKey) {
        boolean exist = false;
        log.debug((Object)"Start checking process already exist");
        try {
            SQLFinder finder = FinderFactory.getSQLFinder();
            String nr_dossier = String.valueOf(dossierKey.getNr_dossier());
            Date ipaoDate = dossierKey.getIpao_date();
            String nr_sklepu = String.valueOf(dossierKey.getStore_no());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String dateString = sdf.format(ipaoDate);
            SQLBuilder builder = new SQLBuilder();
            builder.setQuery("select distinct nr_dossier_ipao from pm_idx_kwestie_spo where nr_dossier_ipao=:textcol AND ipao_date=:textcol2 AND store_no=:textcol3");
            builder.setParameter("textcol", (Object)nr_dossier);
            builder.setParameter("textcol2", (Object)dateString);
            builder.setParameter("textcol3", (Object)nr_sklepu);
            builder.addScalar("nr_dossier_ipao", (Type)StandardBasicTypes.STRING);
            List records = finder.find(builder);
            if (records != null && records.size() > 0) {
                exist = true;
            }
        }
        catch (Exception e) {
            log.error((Object)("**** B\u0142\u0105d podczas pr\u00f3by odnalezienia procesu dla dossier: " + dossierKey.keyToString() + ". B\u0142\u0105d: " + e.getMessage()), (Throwable)e);
            exist = false;
        }
        log.debug((Object)("Dossier: " + dossierKey.keyToString() + ". Process already exist: " + exist));
        return exist;
    }
}

