/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.util.extension.P0015.ckd.PlannedExternalTask.IPAO_SyncDossierList;
import com.suncode.plugin.lm.DirectDB.copyInitData.Sklepy;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.SklepyDao;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.util.Date;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class openCloseUpdateRange {
    public static Logger log = Logger.getLogger(IPAO_SyncDossierList.class);
    @Autowired
    private IPAO_SyncDossierList IPAO_SyncDossierListService;
    @Autowired
    private SklepyDao sklepyDao;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("openCloseUpdateRange")).name("44.02 Wyja\u015bnianie kwestii spornych - CKD Synchronizacja")).description("Aktualizacja")).cancelable().parameter().id("id_startShop").name("Nr sklepu od").description("zakres nr sklep\u00f3w od").type((Type)Types.INTEGER).create()).parameter().id("id_stopShop").name("Nr sklepu do").description("zakres nr sklep\u00f3w do").type((Type)Types.INTEGER).create()).parameter().id("date_from").name("Data od").description("Data od").type((Type)Types.DATETIME).create();
    }

    public void execute(@Param(value="id_startShop") Integer startShop, @Param(value="id_stopShop") Integer stopShop, @Param(value="date_from") Date dateFrom, Logger taskLog) throws InterruptedException {
        taskLog.info((Object)("startShop: " + startShop + " stopShop: " + stopShop));
        long startTime = new Date().getTime();
        if (startShop > stopShop || stopShop < 0 || startShop < 0) {
            log.warn((Object)"Niew\u0142a\u015bciwe nr sklep\u00f3w");
            taskLog.warn((Object)"Niew\u0142a\u015bciwe nr sklep\u00f3w");
            return;
        }
        boolean toContinue = false;
        int counter = 0;
        for (int nr = startShop.intValue(); nr <= stopShop; ++nr) {
            toContinue = false;
            do {
                log.debug((Object)("counter: " + counter + " nr sklepu: " + nr + " z zakresu: (" + startShop + "-" + stopShop + ")"));
                taskLog.debug((Object)("counter: " + counter + " nr sklepu: " + nr + " z zakresu: (" + startShop + "-" + stopShop + ")"));
                try {
                    Sklepy store = this.sklepyDao.getSklepyByNrCkd(nr);
                    if (store != null) {
                        log.info((Object)("** Aktualizacja IPAO dla slepu " + store.getSklep()));
                        this.IPAO_SyncDossierListService.openCloseUpdateDossierInShop_2(nr, dateFrom);
                    }
                    toContinue = false;
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    if (!e.getMessage().toLowerCase().contains("WS przed 5 nie dziala".toLowerCase())) continue;
                    toContinue = true;
                    ++counter;
                    try {
                        log.error((Object)("Zadanie zaplanowane jest zawieszone na 5 minut, proba nr: " + counter));
                        taskLog.debug((Object)("Zadanie zaplanowane jest zawieszone na 5 minut, proba nr: " + counter));
                        Thread.sleep(300000L);
                    }
                    catch (InterruptedException e1) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        toContinue = false;
                    }
                }
            } while (toContinue && counter <= 12);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("** Czas wykonywania aktualizacji LISTY DOSSIER ZE SKLEPOW: " + CUFTools.plannedTaskDuration((long)(stopTime - startTime))));
        taskLog.debug((Object)("** Czas wykonywania aktualizacji LISTY DOSSIER ZE SKLEPOW: " + CUFTools.plannedTaskDuration((long)(stopTime - startTime))));
    }
}

