/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.PlannedExternalTask;

import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.ckd.CKDTools;
import com.plusmpm.util.extension.P0015.ckd.integrations.DossierManager;
import com.plusmpm.util.extension.P0015.ckd.integrations.DossierTranslator;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.Dossier;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.DossierKey;
import com.plusmpm.util.extension.P0015.ckd.processTools.ProcessManager;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@ScheduledTask
public class UpdateDataDev2 {
    public static Logger log = Logger.getLogger(UpdateDataDev2.class);
    @Autowired
    private DossierManager dossierManagerService;
    @Autowired
    private ProcessManager processManagerService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("UpdateDataDev2")).name("Aktualizacja danych w starym procesie po processid")).cancelable().parameter().id("process_id").name("Process Id").type((Type)Types.STRING).create();
    }

    @Transactional
    public void execute(@Param(value="process_id") String process_id, Logger taskLog) throws Exception {
        ActivityFinder activityFinder = FinderFactory.getActivityFinder();
        ProcessService processService = ServiceFactory.getProcessService();
        ActivityService activityService = ServiceFactory.getActivityService();
        Process oneProcess = processService.getProcess(process_id, new String[]{"processDefinition"});
        String sProcessId = "";
        String sActivityId = "";
        Map<String, String> contextMap = new HashMap();
        try {
            sProcessId = oneProcess.getProcessId();
            List activities = activityFinder.findOpenedActivities(sProcessId);
            sActivityId = ((Activity)activities.get(0)).getActivityId();
            log.info((Object)("UpdateDataDev - processid: " + sProcessId + ", activityid: " + sActivityId));
            contextMap = processService.getProcessContext(sProcessId);
            String sStore = contextMap.get("store_no").toString();
            String sDossierNo = contextMap.get("nr_dossier_ipao").toString();
            String sIpaoDate = contextMap.get("ipao_date").toString();
            String sklep = contextMap.get("sklep").toString();
            DossierKey dossKey = new DossierKey(Integer.valueOf(sStore), Long.valueOf(sDossierNo), Functions.convertStringToDate(sIpaoDate, "yyyy-MM-dd"));
            Dossier dossier = DossierTranslator.getAllDossierData(dossKey);
            Dossier doss2update = new Dossier(dossier);
            log.info((Object)("UpdateDataDev DEV -aktualizuje proces processid: " + sProcessId));
            this.processManagerService.setContextforUpdatedProcess(sProcessId, sActivityId, dossier);
            contextMap = new HashMap();
            contextMap = processService.getProcessContext(sProcessId);
            boolean data_changed = this.dossierManagerService.updateDossierDataIfChanged(doss2update);
            if (data_changed) {
                log.info((Object)("UpdateDataDev DEV - dane dossier zostaly zmidenione, proces zaktualizowano: " + sProcessId));
            }
            String sSklep = sklep;
            String sKsie = CKDTools.getKsieForShop(sSklep);
            log.debug((Object)("lista_ksie: " + contextMap.get("lista_ksie").toString()));
            contextMap.put("lista_ksie", sKsie);
            activityService.setActivityContext(sProcessId, sActivityId, contextMap);
            processService.setProcessContext(sProcessId, contextMap);
        }
        catch (Exception e) {
            log.error((Object)("UpdateDataDev DEV -" + e.getMessage()), (Throwable)e);
            Functions.addCommentToActivity(sProcessId, sActivityId, "Nie uda\u0142o si\u0119 zaktualizowac danch z IPAO: " + e.getMessage());
            throw e;
        }
    }
}

