/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.PlannedExternalTask;

import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.ckd.integrations.DossierManager;
import com.plusmpm.util.extension.P0015.ckd.integrations.DossierTranslator;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.Dossier;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.DossierKey;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.DossierListElement;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.dao.DossierListElementDao;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessFinder;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.search.SimpleIndexFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceTools {
    public static Logger log = Logger.getLogger(ServiceTools.class);
    @Autowired
    private DossierListElementDao dossierListElementDao;
    @Autowired
    private DossierManager dossierManagerService;
    @Autowired
    private ProcessService processService;

    @Transactional
    public void createDossierListBaseOnDossierNumberAndStoreNumber(String dossierNumber, String storeNumber) throws Exception {
        ProcessFinder processFinder = FinderFactory.getProcessFinder();
        ArrayList<SimpleIndexFilter> filters = new ArrayList<SimpleIndexFilter>();
        filters.add(new SimpleIndexFilter("nr_dossier_ipao", (Object)dossierNumber, FilterOperator.EQ));
        filters.add(new SimpleIndexFilter("store_no", (Object)storeNumber, FilterOperator.EQ));
        List process = processFinder.findByIndexes("kwestie_spo", filters, new String[0]);
        Date date_of_check = new Date();
        if (process.size() == 1) {
            Process oneProcess = (Process)process.get(0);
            Map processContext = this.processService.getProcessContext(oneProcess.getProcessId());
            String nrSklepu = processContext.get("store_no").toString();
            String nrDossier = processContext.get("nr_dossier_ipao").toString();
            String dataDossier = processContext.get("ipao_date").toString();
            if (!(nrSklepu == null || nrSklepu.isEmpty() || nrDossier == null || nrDossier.isEmpty() || dataDossier == null || dataDossier.isEmpty())) {
                log.debug((Object)("**** ServiceTools, dossier " + dossierNumber));
                DossierKey key = new DossierKey(Integer.valueOf(nrSklepu), Long.valueOf(dossierNumber), Functions.convertStringToDate(dataDossier, "yyyy-MM-dd"));
                DossierListElement dossElem = new DossierListElement(key);
                dossElem.setDate_of_check(date_of_check);
                dossElem.setIpao_open(true);
                dossElem.setProcessid(oneProcess.getProcessId());
                dossElem.setSod_start_date(oneProcess.getCreatedTime());
                dossElem.setSod_open(true);
                dossElem.setMessage(Functions.getCurrentDate("yyyy-MM-dd HH:mm:ss.S") + ": no changes");
                DossierKey returnedDossierKey = (DossierKey)this.dossierListElementDao.save(dossElem);
                Dossier dossier = DossierTranslator.getAllDossierData(dossElem.getPrimaryKey());
                boolean data_changed = this.dossierManagerService.updateDossierDataIfChanged(dossier);
                log.debug((Object)("data_changed" + data_changed));
                log.debug((Object)("**** ServiceTools, returned dossier " + returnedDossierKey.getNr_dossier() + " ze sklepu " + returnedDossierKey.getStore_no()));
            }
        }
    }

    public void createDossierListBaseOnProcessId(String processid) throws Exception {
        Map processContext = this.processService.getProcessContext(processid);
        String nrSklepu = processContext.get("store_no").toString();
        String nrDossier = processContext.get("nr_dossier_ipao").toString();
        this.createDossierListBaseOnDossierNumberAndStoreNumber(nrDossier, nrSklepu);
    }
}

