/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.util.extension.P0015.ckd.integrations.DossierManager;
import com.plusmpm.util.extension.P0015.ckd.integrations.DossierTranslator;
import java.util.Date;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IPAO_SyncDossierList {
    public static Logger log = Logger.getLogger(IPAO_SyncDossierList.class);
    @Autowired
    private DossierManager dossierManagerService;
    @Autowired
    private DossierTranslator dossierTranslatorService;

    public void openCloseUpdateDossierInShop_2(int store_no, Date dataOd) throws Exception {
        log.info((Object)("** Wykonywanie aktualizacji WSZYSTKICH DOSSIER ZE SKLEPU " + store_no));
        long startTime = new Date().getTime();
        try {
            log.info((Object)("** 1 updateDossierListFromShop " + store_no));
            this.updateDossierListFromShop(store_no);
            log.info((Object)("** Zaktualizowano list\u0119 dossier ze slepu " + store_no));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            log.info((Object)("** 2 closeDossierInShop " + store_no));
            this.closeDossierInShop(store_no);
            log.info((Object)("** Dossie ZDZ zamkniete dla slepu " + store_no));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            log.info((Object)("** 3 updateDossierInShop " + store_no));
            this.updateDossierInShop(store_no);
            log.info((Object)("** Otwarte dossie zaktualizowane dla slepu " + store_no));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            log.info((Object)("** 4 openReopenDossierInShop " + store_no));
            this.openReopenDossierInShop(store_no, dataOd);
            log.info((Object)("** Nowe Dossie otwarte dla slepu " + store_no));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("** Czas wykonywania aktualizacji WSZYSTKICH DOSSIER ZE SKLEPU " + store_no + ": " + CUFTools.plannedTaskDuration((long)(stopTime - startTime))));
    }

    public void updateDossierListFromShop(int store_no) throws Exception {
        long startTime = new Date().getTime();
        try {
            this.dossierTranslatorService.synchronizeAllFromShop(store_no);
        }
        catch (Exception e) {
            log.error((Object)("** PlannedTask - blad pobierania danych listy dossier dla sklepu " + store_no + ": " + e.getMessage()), (Throwable)e);
            throw e;
        }
        long stopTime = new Date().getTime();
        log.info((Object)("** Czas wykonywania aktualizacji LISTY DOSSIER dla sklepu " + store_no + ": " + CUFTools.plannedTaskDuration((long)(stopTime - startTime))));
    }

    public void closeDossierInShop(int store_no) throws Exception {
        long startTime = new Date().getTime();
        try {
            this.dossierManagerService.closeAllFromShop(store_no, false);
        }
        catch (Exception e) {
            log.error((Object)("** PlannedTask - blad zamykania dossier dla sklepu " + store_no + ": " + e.getMessage()), (Throwable)e);
            throw e;
        }
        long stopTime = new Date().getTime();
        log.info((Object)("** Czas wykonywania ZAMYKANIA DOSSIER dla sklepu " + store_no + ": " + CUFTools.plannedTaskDuration((long)(stopTime - startTime))));
    }

    public void updateDossierInShop(int store_no) {
        long startTime = new Date().getTime();
        try {
            this.dossierManagerService.updateAllFromShop(store_no, true);
        }
        catch (Exception e) {
            log.error((Object)("** PlannedTask - blad aktualizacji listy otwartych dossier dla sklepu " + store_no + ": " + e.getMessage()), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("** Czas AKTUALIZACJI DOSSIER dla sklepu " + store_no + ": " + CUFTools.plannedTaskDuration((long)(stopTime - startTime))));
    }

    public void openReopenDossierInShop(int store_no, Date dataOd) throws Exception {
        long startTime = new Date().getTime();
        try {
            this.dossierManagerService.openAllFromShop(store_no, true, dataOd);
        }
        catch (Exception e) {
            log.error((Object)("** PlannedTask - blad pobierania danych listy dossier dla sklepu " + store_no + ": " + e.getMessage()), (Throwable)e);
            throw e;
        }
        long stopTime = new Date().getTime();
        log.info((Object)("** Czas OTWIERANIA/PRZYWRACANIA DOSSIER dla sklepu " + store_no + ": " + CUFTools.plannedTaskDuration((long)(stopTime - startTime))));
    }

    public void openReopenDossierInShopLOCALTEST(int store_no, Date dataOd) throws Exception {
        long startTime = new Date().getTime();
        try {
            this.dossierManagerService.openAllFromShop(store_no, false, dataOd);
        }
        catch (Exception e) {
            log.error((Object)("** PlannedTask - blad pobierania danych listy dossier dla sklepu " + store_no + ": " + e.getMessage()), (Throwable)e);
            throw e;
        }
        long stopTime = new Date().getTime();
        log.info((Object)("** Czas OTWIERANIA/PRZYWRACANIA DOSSIER dla sklepu " + store_no + ": " + CUFTools.plannedTaskDuration((long)(stopTime - startTime))));
    }
}

