/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.plusmpm.CUF.util.extension.SendTemplateEmail;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.extension.P0015.ckd.CKDTools;
import com.plusmpm.util.extension.P0015.ckd.integrations.ws.IPAO_WServices;
import com.suncode.plugin.lm.util.extension.P0015.ckd_pw.PWTools;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.process.ProcessDataService;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class CKD_SendLS {
    @Autowired
    private PWTools pwToolsService;
    public static Logger log = Logger.getLogger(CKD_SendLS.class);
    public static ActivityService activityService = ServiceFactory.getActivityService();
    public static ProcessService processService = ServiceFactory.getProcessService();

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("CKD_SendLS")).name("44.03 Wysy\u0142anie list\u00f3w spornych")).description("Wysy\u0142anie maili")).cancelable().create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Logger taskLog) throws Exception {
        ResultSet rs;
        Statement stat;
        Object sIdProcesuTmp = "";
        Object sIdActivityTmp = "";
        Object sNrDostawcyTmp = "";
        Object sNrSklepuTmp = "";
        Connection con = null;
        HashSet<String> lDostawcy = new HashSet<String>();
        try {
            con = null;
            stat = null;
            rs = null;
            con = DBUtils.connectToDB();
            if (!con.isClosed()) {
                log.info((Object)"CKD_SendLS: Pobieranie danych do wys\u0142ania maili z LS");
                String sQuery = "select distinct act.activityprocessid processid, act.activityid id, nr_dostawcy_ipao, store_no from (select distinct activityprocessid, activityprocessdefname, activityid from assignmentstable where activityprocessid like '%_kwestie_spo' and activityid like '%_kwestie_spo_oczekiwanie_na_wyslanie_maila') act join pm_idx_kwestie_spo k on act.activityprocessid = k.processid union select distinct act.activityprocessid processid, act.activityid id, nr_dostawcy_ipao, store_no from (select distinct activityprocessid, activityprocessdefname, activityid from assignmentstable where activityprocessid like '%_przyjscia_wyjscia' and activityid like '%_przyjscia_wyjscia_oczekiwanie_na_wyslanie_maila') act join pm_idx_przyjscia_wyjscia p on act.activityprocessid = p.processid";
                stat = con.createStatement();
                rs = stat.executeQuery(sQuery);
                while (rs.next()) {
                    sIdProcesuTmp = (String)sIdProcesuTmp + rs.getString("processid");
                    sIdActivityTmp = (String)sIdActivityTmp + rs.getString("id");
                    sNrDostawcyTmp = (String)sNrDostawcyTmp + rs.getString("nr_dostawcy_ipao");
                    sNrSklepuTmp = (String)sNrSklepuTmp + rs.getString("store_no");
                    if (!lDostawcy.contains(rs.getString("nr_dostawcy_ipao"))) {
                        lDostawcy.add(rs.getString("nr_dostawcy_ipao"));
                    }
                    if (rs.isLast()) continue;
                    sIdProcesuTmp = (String)sIdProcesuTmp + ";";
                    sIdActivityTmp = (String)sIdActivityTmp + ";";
                    sNrDostawcyTmp = (String)sNrDostawcyTmp + ";";
                    sNrSklepuTmp = (String)sNrSklepuTmp + ";";
                }
                rs.close();
                stat.close();
                log.info((Object)("CKD_SendLS: Odnaleziona ilosc procesow oczekujacych na wyslanie maila: " + ((String)sIdProcesuTmp).split(";").length));
                taskLog.info((Object)("ilosc procesow oczekujacych na wyslanie maila: " + ((String)sIdProcesuTmp).split(";").length));
            }
        }
        catch (Exception e) {
            log.error((Object)("CKD_SEND_LS: blad pobierania procesow " + e.getMessage()), (Throwable)e);
            taskLog.error((Object)("CKD_SEND_LS: blad pobierania procesow " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (con != null && !con.isClosed()) {
                    con.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                taskLog.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        log.info((Object)("CKD_SendLS: Odnaleziona ilosc dostawc\u00f3w do kt\u00f3rych zostanie wyslany mail:  " + lDostawcy.size()));
        taskLog.info((Object)("ilosc dostawc\u00f3w do kt\u00f3rych zostanie wyslany mail:  " + lDostawcy.size()));
        String[] tNrDostawcy = ((String)sNrDostawcyTmp).split(";");
        String[] tIdProcesu = ((String)sIdProcesuTmp).split(";");
        String[] tIdActivity = ((String)sIdActivityTmp).split(";");
        String[] tNrSklepuTmp = ((String)sNrSklepuTmp).split(";");
        HashMap<String, String> l_okalizacja_os = new HashMap<String, String>();
        for (String sDostNoInShop : lDostawcy) {
            HashMap lActivityToAccept = new HashMap();
            String sDostNo = sDostNoInShop;
            log.info((Object)("CKD_SendLS: tworze wiadomosc dla dostawcy o nr ipao:  " + sDostNo));
            taskLog.info((Object)("tworze wiadomosc dla dostawcy o nr ipao:  " + sDostNo));
            String username = SystemProperties.getString((String)"Bufor.username").replaceAll("[\"]", "");
            String password = SystemProperties.getString((String)"Bufor.password");
            SharkTransaction st = null;
            ExecutionAdministration ea = null;
            String sTempActivityId = "";
            String sTempProcessId = "";
            ArrayList<Object> attachments = new ArrayList<Object>();
            ArrayList<CallSite> attachments_to_remove = new ArrayList<CallSite>();
            String sSupplMail = "";
            HashMap<String, String> tmpActivityToAccept = new HashMap<String, String>();
            try {
                int i;
                st = Shark.getInstance().createTransaction();
                ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
                ea.connect(st, username, password, "KlientTestowy", null);
                log.debug((Object)("CKD_SendLS: pobieranie maila dostawcy o nr ipao:  " + sDostNo));
                int store_no = Integer.valueOf(tNrSklepuTmp[0]);
                int n = Integer.valueOf(sDostNo);
                JSONObject jsonResult = IPAO_WServices.getSuppilerData(store_no, n);
                JSONArray dane_coresp = jsonResult.getJSONArray("corresp");
                log.debug((Object)dane_coresp);
                log.debug((Object)dane_coresp.length());
                String sSekretariatMail = "";
                String sZamMail = "";
                for (i = 0; i < dane_coresp.length(); ++i) {
                    JSONObject dataJSON = dane_coresp.getJSONObject(i);
                    log.debug((Object)dataJSON.getInt("codfonc"));
                    if (dataJSON.getInt("codfonc") == 6) {
                        log.debug((Object)dataJSON.getInt("codfonc"));
                        log.debug((Object)dataJSON.getString("tlxfou"));
                        if (StringUtils.isBlank((CharSequence)dataJSON.getString("tlxfou").trim())) continue;
                        sSupplMail = dataJSON.getString("tlxfou").trim();
                        log.debug((Object)sSupplMail);
                        break;
                    }
                    if (dataJSON.getInt("codfonc") == 4) {
                        log.debug((Object)dataJSON.getInt("codfonc"));
                        log.debug((Object)dataJSON.getString("tlxfou"));
                        if (StringUtils.isBlank((CharSequence)dataJSON.getString("tlxfou").trim())) continue;
                        sSekretariatMail = dataJSON.getString("tlxfou").trim();
                        log.debug((Object)sSekretariatMail);
                        continue;
                    }
                    if (dataJSON.getInt("codfonc") != 7) continue;
                    log.debug((Object)dataJSON.getInt("codfonc"));
                    log.debug((Object)dataJSON.getString("tlxfou"));
                    if (StringUtils.isBlank((CharSequence)dataJSON.getString("tlxfou").trim())) continue;
                    sZamMail = dataJSON.getString("tlxfou").trim();
                    log.debug((Object)sZamMail);
                }
                if (StringUtils.isBlank((CharSequence)sSupplMail.trim())) {
                    sSupplMail = sSekretariatMail.trim();
                }
                if (StringUtils.isBlank((CharSequence)sSupplMail.trim())) {
                    sSupplMail = sZamMail.trim();
                }
                log.info((Object)("CKD_SendLS: mail pobrano:  " + sSupplMail));
                for (i = 0; i < tIdProcesu.length; ++i) {
                    if (sDostNo.compareTo(tNrDostawcy[i]) != 0) continue;
                    sTempActivityId = tIdActivity[i];
                    sTempProcessId = tIdProcesu[i];
                    if (StringUtils.isBlank((CharSequence)sTempProcessId)) {
                        throw new Exception("Processid jest puste");
                    }
                    log.info((Object)("CKD_SendLS: pobieranie danych z procesu: " + sTempProcessId));
                    WfProcess wfProcess = ea.getProcess(st, sTempProcessId);
                    Map contextMap = SharkFunctions.GetProcessContext((SharkTransaction)st, (WfProcess)wfProcess);
                    String[] colIDs = new String[]{"ls", "zal_fileid", "zal_docclass"};
                    List tab_zal = DynamicTableFunctions.convertFromMapToListOfMaps((Map)contextMap, (String[])colIDs);
                    Timestamp ls_date = null;
                    String ls_path = "";
                    String ls_id = "";
                    for (Map map : tab_zal) {
                        if (((String)map.get("ls")).compareToIgnoreCase("tak") == 0 && !StringUtils.isBlank((CharSequence)((CharSequence)map.get("zal_fileid")))) {
                            log.debug((Object)"zalacznik recznie wskazany do wyslania");
                        } else {
                            if (((String)map.get("zal_docclass")).compareToIgnoreCase(CKDTools._lsDocClassName) != 0) continue;
                            log.debug((Object)"znaleziono list sporny");
                        }
                        String zalacznik = (String)map.get("zal_fileid");
                        Object attachment = "";
                        try {
                            con = null;
                            stat = null;
                            rs = null;
                            con = DBUtils.connectToDB();
                            if (!con.isClosed()) {
                                log.debug((Object)"Pobieranie zalacznikow");
                                String sQuery = "select name, path, file_date from pm_files where id = " + zalacznik;
                                log.debug((Object)("Zalacznik (id): " + zalacznik));
                                stat = con.createStatement();
                                rs = stat.executeQuery(sQuery);
                                while (rs.next()) {
                                    if (((String)map.get("zal_docclass")).compareToIgnoreCase(CKDTools._lsDocClassName) == 0) {
                                        log.debug((Object)"sprawdzam czy znaleziono list sporny jest najnowszy");
                                        Timestamp tmp_date = rs.getTimestamp("file_date");
                                        if (ls_date == null || tmp_date.after(ls_date)) {
                                            log.debug((Object)"znaleziono nowszy LS");
                                            ls_date = tmp_date;
                                            attachment = (String)attachment + rs.getString("path");
                                            attachment = (String)attachment + rs.getString("name");
                                            ls_id = zalacznik;
                                        } else {
                                            attachment = "";
                                        }
                                    } else {
                                        attachment = (String)attachment + rs.getString("path");
                                        attachment = (String)attachment + rs.getString("name");
                                    }
                                    log.debug((Object)("Attachment: " + (String)attachment));
                                }
                                rs.close();
                                stat.close();
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                        finally {
                            try {
                                if (con != null && !con.isClosed()) {
                                    con.close();
                                }
                            }
                            catch (Exception e) {
                                log.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                        if (((String)map.get("zal_docclass")).compareToIgnoreCase(CKDTools._lsDocClassName) != 0) {
                            attachments.add(attachment);
                        } else if (!StringUtils.isBlank((CharSequence)attachment)) {
                            ls_path = attachment;
                        }
                        log.debug((Object)("Attachment: " + (String)attachment));
                    }
                    if (!StringUtils.isBlank((CharSequence)ls_path)) {
                        String sZamowienie = "";
                        if (sTempActivityId.indexOf("przyjscia_wyjscia") < 0) {
                            String[] sTmp = contextMap.get("zamowienie").toString().split(";", -1);
                            sZamowienie = sTmp[0];
                        } else {
                            sZamowienie = contextMap.get("nr_bonu_wyjsciazamowienia").toString();
                        }
                        FileInputStream inStream = null;
                        FileOutputStream outStream = null;
                        try {
                            int length;
                            ProcessDataService pds = (ProcessDataService)SpringContext.getBean(ProcessDataService.class);
                            String sTmpFilePath = pds.getProcessData("P0015", "CKD", "TmpLsPath");
                            String sNewPath = sTmpFilePath + sZamowienie + ".pdf";
                            log.debug((Object)("sNewPath: " + sNewPath));
                            File afile = new File(ls_path);
                            File bfile = new File(sNewPath);
                            inStream = new FileInputStream(afile);
                            outStream = new FileOutputStream(bfile);
                            byte[] buffer = new byte[1024];
                            while ((length = ((InputStream)inStream).read(buffer)) > 0) {
                                ((OutputStream)outStream).write(buffer, 0, length);
                            }
                            ((InputStream)inStream).close();
                            ((OutputStream)outStream).close();
                            attachments.add(sNewPath);
                            attachments_to_remove.add((CallSite)((Object)sNewPath));
                            log.debug((Object)("attachments: " + String.valueOf(attachments)));
                            log.debug((Object)("attachments_to_remove: " + String.valueOf(attachments_to_remove)));
                            log.debug((Object)"CKD_SendLS: plik skopiowany");
                        }
                        catch (IOException e) {
                            log.error((Object)"CKD_SendLS: wysylam maila do dostawcy");
                        }
                    }
                    tmpActivityToAccept.put(sTempActivityId, sTempProcessId);
                    Object sLokalizacja = "";
                    if (sTempActivityId.indexOf("przyjscia_wyjscia") < 0) {
                        String[] tLokalizacja = contextMap.get("lokalizacja_os_kontaktowej").toString().split(";", -1);
                        String[] tZalId = contextMap.get("zal_fileid").toString().split(";", -1);
                        for (int x = 0; x < tZalId.length; ++x) {
                            String fileid = tZalId[x];
                            sLokalizacja = fileid.compareTo(ls_id) == 0 ? (String)sLokalizacja + sSupplMail + ";" : (String)sLokalizacja + tLokalizacja[x] + ";";
                        }
                        if (((String)sLokalizacja).length() > 0) {
                            sLokalizacja = ((String)sLokalizacja).substring(0, ((String)sLokalizacja).length() - 1);
                        }
                    }
                    l_okalizacja_os.put(sTempActivityId, (String)sLokalizacja);
                }
                String sSendMailOn = SystemProperties.getString((String)"CKD_SEND_MAIL");
                String sTestMail = SystemProperties.getString((String)"CKD_TEST_MAIL");
                taskLog.info((Object)("sTestMail: " + sTestMail));
                String sLsMail = SystemProperties.getString((String)"CKD_MAIL_TEMPLATE");
                Object sFWDMail = SystemProperties.getString((String)"CKD_MAIL_FWD");
                sFWDMail = StringUtils.isBlank((CharSequence)sFWDMail) ? "" : (String)sFWDMail + ",";
                String sTemat = "Powiadomienie o listach spornych";
                ArrayList<String> failedSend = new ArrayList<String>();
                if (StringUtils.isEmpty((CharSequence)sSendMailOn) || sSendMailOn.compareToIgnoreCase("YES") == 0) {
                    if (StringUtils.isEmpty((CharSequence)sTestMail)) {
                        log.info((Object)"CKD_SendLS: wysylam maila do dostawcy");
                        try {
                            SendTemplateEmail.Send((String)((String)sFWDMail + sSupplMail), (String)sLsMail, (String)sTemat, (String)sTempActivityId, (String)sTempProcessId, (SharkTransaction)st, attachments, null);
                            log.info((Object)("CKD_SendLS: wysylanie maila zakonczone, adres " + (String)sFWDMail + sSupplMail));
                            taskLog.info((Object)("wyslano maila na adres: " + (String)sFWDMail + sSupplMail));
                        }
                        catch (Exception e) {
                            failedSend.add(0, "niepowodzenie");
                        }
                    } else {
                        log.info((Object)"CKD_SendLS: wysylam maila testowego");
                        taskLog.info((Object)"CKD_SendLS: wysylam maila testowego");
                        sTemat = "Powiadomienie o listach spornych - testy";
                        try {
                            SendTemplateEmail.Send((String)sTestMail, (String)sLsMail, (String)sTemat, (String)sTempActivityId, (String)sTempProcessId, (SharkTransaction)st, attachments, null);
                            log.info((Object)("CKD_SendLS: wysylanie maila zakonczone, adres: " + sTestMail));
                            taskLog.info((Object)("wyslano maila na adres: " + sTestMail));
                        }
                        catch (Exception e) {
                            failedSend.add(0, "niepowodzenie");
                        }
                    }
                } else {
                    log.info((Object)"CKD_SendLS: sending mail turned off");
                    taskLog.info((Object)"CKD_SendLS: sending mail turned off");
                }
                if (failedSend.size() > 0) {
                    log.info((Object)"CKD_SendLS: wysylanie maila zakonczone niepowodzeniem");
                    taskLog.info((Object)"wysylanie maila zakonczone niepowodzeniem");
                } else {
                    lActivityToAccept.putAll(tmpActivityToAccept);
                }
            }
            catch (Exception e) {
                log.error((Object)("CKD_SendLS: Nie udalo sie wysla maila do dostawcy " + sDostNo + " :" + e.getMessage()), (Throwable)e);
                taskLog.info((Object)("Nie udalo sie wysla maila do dostawcy " + sDostNo + " :" + e.getMessage()), (Throwable)e);
                try {
                    Shark.getInstance().emptyCaches(st);
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
                try {
                    st.rollback();
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            finally {
                try {
                    Shark.getInstance().unlockProcesses(st);
                }
                catch (Exception e1) {
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                }
                try {
                    st.release();
                }
                catch (Exception e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
            log.info((Object)("CKD_SendLS: usuwanie plikow tymczasowych: " + attachments_to_remove.size()));
            for (String string : attachments_to_remove) {
                try {
                    File file = new File(string);
                    if (file.delete()) {
                        log.trace((Object)("CKD_SendLS: plik " + file.getName() + " is deleted"));
                        continue;
                    }
                    log.trace((Object)("CKD_SendLS: plik " + file.getName() + " not deleted"));
                }
                catch (Exception e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
            log.info((Object)("CKD_SendLS: akceptacja zadan oczekujacych dla dostawcy w buforze, ilosc zadan: " + lActivityToAccept.size()));
            taskLog.info((Object)("akceptacja zadan - ilosc: " + lActivityToAccept.size()));
            Set key_set = lActivityToAccept.keySet();
            String string = "";
            for (String activityId : key_set) {
                String string2 = (String)lActivityToAccept.get(activityId);
                taskLog.info((Object)("akceptacja procesu: " + string2));
                try {
                    log.debug((Object)("CKD_SendLS: akceptacja zadania: " + activityId));
                    taskLog.info((Object)("akceptacja zadania: " + activityId));
                    Map procesContext = processService.getProcessContext(string2);
                    Map activityContext = activityService.getActivityContext(string2, activityId);
                    activityContext.put("akcja", "wyslano");
                    procesContext.put("akcja", "wyslano");
                    if (activityId.indexOf("przyjscia_wyjscia") > 0) {
                        activityContext.put("status", PWTools._closed_ls);
                        activityContext.put("status_dossier", PWTools._closed_ls);
                        activityContext.put("status_dossier", PWTools._closed_ls);
                        activityContext.put("mail_dostawcy", sSupplMail);
                        procesContext.put("status", PWTools._closed_ls);
                        procesContext.put("status_dossier", PWTools._closed_ls);
                        procesContext.put("status_dossier", PWTools._closed_ls);
                        procesContext.put("mail_dostawcy", sSupplMail);
                    } else {
                        activityContext.put("mail_dostawcy", sSupplMail);
                        activityContext.put("lokalizacja_os_kontaktowej", l_okalizacja_os.get(activityId));
                        procesContext.put("mail_dostawcy", sSupplMail);
                        procesContext.put("lokalizacja_os_kontaktowej", l_okalizacja_os.get(activityId));
                    }
                    activityService.setActivityContext(string2, activityId, activityContext);
                    processService.setProcessContext(string2, procesContext);
                    AcceptationDefinition acceptation = new AcceptationDefinition(string2, activityId, username, "wyslano");
                    acceptation.setIgnoreOwnerShip(Boolean.valueOf(true));
                    activityService.acceptActivity(acceptation);
                }
                catch (Exception e) {
                    log.error((Object)("CKD_SendLS: akceptacja zadania " + activityId + " nie powiodla sie: " + e.getMessage()), (Throwable)e);
                    taskLog.info((Object)("akceptacja zadania " + activityId + " nie powiodla sie: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }
}

