/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.Transport;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class CKD_MailClient
extends Authenticator {
    public static Logger log = Logger.getLogger(CKD_MailClient.class);
    public static final int SHOW_MESSAGES = 1;
    public static final int CLEAR_MESSAGES = 2;
    public static final int SHOW_AND_CLEAR = 3;
    protected String from;
    protected Session session;
    protected PasswordAuthentication authentication;
    protected String Email;

    public CKD_MailClient(String user, String password, String host) {
        this(user, user, password, host, host, "25", "false", false, "");
    }

    public CKD_MailClient(String user, String smtpuser, String password, String host, String outhost, String sSMTPPort, String sSMTPAuth, boolean debug, String sEmail) {
        this.from = user + "@" + host;
        this.Email = sEmail;
        log.debug((Object)(this.Email + " " + user + " " + smtpuser + " " + password + " " + host + " " + outhost + " " + this.from + " " + debug + " " + sSMTPPort));
        if (smtpuser == null || smtpuser.compareToIgnoreCase("") == 0) {
            smtpuser = user;
        }
        this.authentication = new PasswordAuthentication(smtpuser, password);
        Properties props = new Properties();
        if (smtpuser != null) {
            props.put("mail.user", smtpuser);
            props.put("mail.password", password);
            props.put("mail.host", outhost);
            props.put("mail.from", this.from);
            props.put("mail.sender", "from");
            props.put("mail.smtp.submitter", this.Email);
            props.put("mail.debug", debug ? "true" : "false");
            props.put("mail.store.protocol", "pop3");
            props.put("mail.transport.protocol", "smtp");
            props.put("mail.smtp.port", sSMTPPort);
            props.put("mail.pop.port", "110");
            if (sSMTPAuth.compareToIgnoreCase("true") == 0) {
                props.put("mail.smtp.auth", "true");
            }
            this.session = Session.getInstance((Properties)props, (Authenticator)this);
        }
    }

    public PasswordAuthentication getPasswordAuthentication() {
        return this.authentication;
    }

    public void sendMessage(String to, String subject, String content, boolean html) throws MessagingException {
        if (this.session != null) {
            log.debug((Object)("SENDING message from " + this.from + " to " + to));
            MimeMessage msg = new MimeMessage(this.session);
            if (html) {
                msg.setContent((Object)content, "text/html; charset=UTF-8");
            } else {
                msg.setText(content);
            }
            msg.setFrom();
            msg.addRecipients(Message.RecipientType.TO, to);
            msg.setSubject(subject, "UTF-8");
            int tryCount = 6;
            for (int i = 0; i < 6; ++i) {
                try {
                    Transport.send((Message)msg);
                    break;
                }
                catch (MessagingException me) {
                    log.error((Object)me.getMessage(), (Throwable)me);
                    if (i < 5) {
                        Random random = new Random();
                        try {
                            TimeUnit.SECONDS.sleep(random.nextInt(10) + 4);
                        }
                        catch (InterruptedException ie) {
                            log.error((Object)ie.getMessage(), (Throwable)ie);
                        }
                        continue;
                    }
                    log.error((Object)("Failed to send message from: " + this.from + " to: " + to + " in 6 attempts."));
                    continue;
                }
            }
        } else {
            log.warn((Object)("Session is null. Can't send email to:" + to));
        }
    }

    public void sendMessage(String to, String subject, String content, String[] asFilePaths, String[] asFileNames) throws MessagingException {
        this.sendMessage(to, subject, content, asFilePaths, asFileNames, false);
    }

    public void sendMessage(String to, String subject, String content, String[] asFilePaths, String[] asFileNames, boolean isHtml) throws MessagingException {
        log.debug((Object)("SENDING2 message from " + this.from + " to " + to));
        MimeMessage msg = new MimeMessage(this.session);
        msg.addRecipients(Message.RecipientType.TO, to);
        msg.setSubject(subject, "UTF-8");
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        if (isHtml) {
            messageBodyPart.setContent((Object)content, "text/html; charset=UTF-8");
        } else {
            messageBodyPart.setText(content);
        }
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        for (int i = 0; i < asFilePaths.length; ++i) {
            messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(asFilePaths[i]);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName(asFileNames[i]);
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        msg.setFrom();
        msg.setContent((Multipart)multipart);
        msg.setSentDate(new Date());
        Transport transport = this.session.getTransport();
        transport.connect("mail.plusmpm.pl", 25, "powiadomienia_test@plusmpm.pl", "Powiadomienia2010");
        transport.sendMessage((Message)msg, msg.getRecipients(Message.RecipientType.TO));
        transport.close();
    }

    public void checkInbox(int mode) throws MessagingException, IOException {
        if (mode == 0) {
            return;
        }
        boolean show = (mode & 1) > 0;
        boolean clear = (mode & 2) > 0;
        String action = (show ? "Show" : "") + (show && clear ? " and " : "") + (clear ? "Clear" : "");
        log.debug((Object)(action + " INBOX for " + this.from));
        Store store = this.session.getStore();
        store.connect();
        Folder root = store.getDefaultFolder();
        Folder inbox = root.getFolder("inbox");
        inbox.open(2);
        Message[] msgs = inbox.getMessages();
        if (msgs.length == 0 && show) {
            log.debug((Object)"No messages in inbox");
        }
        for (int i = 0; i < msgs.length; ++i) {
            MimeMessage msg = (MimeMessage)msgs[i];
            if (show) {
                log.debug((Object)("    From: " + String.valueOf(msg.getFrom()[0])));
                log.debug((Object)(" Subject: " + msg.getSubject()));
                log.debug((Object)(" Content: " + String.valueOf(msg.getContent())));
            }
            if (!clear) continue;
            msg.setFlag(Flags.Flag.DELETED, true);
        }
        inbox.close(true);
        store.close();
    }
}

