/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd;

import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.ckd.CKDTools;
import com.plusmpm.util.extension.P0015.ckd.integrations.DossierManager;
import com.plusmpm.util.extension.P0015.ckd.integrations.DossierTranslator;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.Dossier;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.DossierKey;
import com.plusmpm.util.extension.P0015.ckd.processTools.ProcessManager;
import com.suncode.lm.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class CKD_IPAO2 {
    public static Logger log = Logger.getLogger(CKD_IPAO2.class);
    @Autowired
    private DossierManager dossierManagerService;
    @Autowired
    private ProcessManager processManagerService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("ckd_ipao2-app")).name("ckd_ipao2-app.name")).description("ckd_ipao2-app.desc")).category(new Category[]{Categories.CLIENT})).icon((Icon)SilkIconPack.APPLICATION)).parameter().id("s_status").name("ckd_ipao2-app.s_status.name").type((Type)Types.STRING).create()).parameter().id("s_selected_ksie").name("ckd_ipao2-app.s_selected_ksie.name").type((Type)Types.STRING).create()).parameter().id("s_lista_ksie").name("ckd_ipao2-app.s_lista_ksie.name").type((Type)Types.STRING).create()).parameter().id("s_store_no").name("ckd_ipao2-app.s_store_no.name").type((Type)Types.STRING).create()).parameter().id("s_dossier_no").name("ckd_ipao2-app.s_dossier_no.name").type((Type)Types.STRING).create()).parameter().id("s_ipao_date").name("ckd_ipao2-app.s_ipao_date.name").type((Type)Types.STRING).create()).parameter().id("s_sklep").name("ckd_ipao2-app.s_sklep.name").type((Type)Types.STRING).create();
    }

    public void execute(ApplicationContext applicationContext, ActivityContextMap activityContext, @Param String s_status, @Param String s_selected_ksie, @Param String s_lista_ksie, @Param String s_store_no, @Param String s_dossier_no, @Param String s_ipao_date, @Param String s_sklep) throws Exception {
        String sProcessId = applicationContext.getProcessId();
        String sActivityId = applicationContext.getActivityId();
        Map<String, String> contextMap = new HashMap();
        log.info((Object)("CKD_IPAO2 - processid: " + sProcessId + ", activityid: " + sActivityId));
        String sStatus = s_status;
        try {
            contextMap = this.processService.getProcessContext(sProcessId);
            String sStore = s_store_no;
            String sDossierNo = s_dossier_no;
            String sIpaoDate = s_ipao_date;
            DossierKey dossKey = new DossierKey(Integer.valueOf(sStore), Long.valueOf(sDossierNo), Functions.convertStringToDate(sIpaoDate, "yyyy-MM-dd"));
            Dossier dossier = DossierTranslator.getAllDossierData(dossKey);
            Dossier doss2update = new Dossier(dossier);
            log.info((Object)("CKD_IPAO2 -aktualizuje proces processid: " + sProcessId + ", activityid: " + sActivityId));
            this.processManagerService.setContextforUpdatedProcess(sProcessId, sActivityId, dossier);
            contextMap = new HashMap();
            contextMap = this.processService.getProcessContext(sProcessId);
            boolean data_changed = this.dossierManagerService.updateDossierDataIfChanged(doss2update);
            if (data_changed) {
                log.info((Object)("CKD_IPAO2 - dane dossier zostaly zmidenione, proces zaktualizowano: " + sProcessId));
            }
            String sSklep = s_sklep;
            String sKsie = CKDTools.getKsieForShop(sSklep);
            log.debug((Object)("lista_ksie: " + contextMap.get("lista_ksie").toString()));
            contextMap.put("lista_ksie", sKsie);
            if (sStatus.compareToIgnoreCase("ZDZ") != 0) {
                contextMap.put("status", "W analizie ponownie");
            }
        }
        catch (Exception e) {
            log.error((Object)("CKD_IPAO2 -" + e.getMessage()), (Throwable)e);
            Functions.addCommentToActivity(sProcessId, sActivityId, "Nie uda\u0142o si\u0119 zaktualizowac danch z IPAO: " + e.getMessage());
            if (sStatus.compareToIgnoreCase("ZDZ") == 0 && e.getMessage().indexOf(DossierTranslator._zgrupowane) >= 0) {
                contextMap.put("status", "ZDZ-zgrupowane");
            }
            throw e;
        }
        log.debug((Object)("selected_ksie: " + contextMap.get("selected_ksie").toString()));
        contextMap.put("selected_ksie", s_lista_ksie);
        this.activityService.setActivityContext(sProcessId, sActivityId, contextMap);
        this.processService.setProcessContext(sProcessId, contextMap);
    }
}

