/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd;

import com.plusmpm.util.extension.P0015.ckd.CKDTools;
import com.suncode.lm.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class CKD_GetIniData {
    public static Logger log = Logger.getLogger(CKD_GetIniData.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("ckd_getinidata-app")).name("ckd_getinidata-app.name")).description("ckd_getinidata-app.desc")).category(new Category[]{Categories.CLIENT})).icon((Icon)SilkIconPack.APPLICATION)).parameter().id("s_store_no").name("ckd_getinidata-app.s_store_no.name").type((Type)Types.STRING).create();
    }

    public void execute(ApplicationContext applicationContext, ActivityContextMap activityContext, @Param String s_store_no) throws Exception {
        String sProcessId = applicationContext.getProcessId();
        String sActivityId = applicationContext.getActivityId();
        Map<String, String> contextMap = new HashMap();
        log.info((Object)("CKD_GetIniData - processid: " + sProcessId + ", activityid: " + sActivityId));
        try {
            contextMap = this.processService.getProcessContext(sProcessId);
            log.debug((Object)("CKD_GetIniData - pobieranie list uzytkownikow ze sklepu: " + s_store_no));
            if (s_store_no == null || StringUtils.isEmpty((String)s_store_no)) {
                throw new Exception("Brak danych sklepu");
            }
            String sKsie = CKDTools.getKsieForShop(s_store_no);
            contextMap.put("lista_ksie", sKsie);
            contextMap.put("selected_ksie", sKsie);
            String sDpt = CKDTools.getDptForShop(s_store_no);
            contextMap.put("lista_dpt", sDpt);
            contextMap.put("selected_dpt", sDpt);
            log.debug((Object)("DPT: " + sDpt));
            String sKz = CKDTools.getDefaultKzForShop(s_store_no);
            if (sKz != null && !StringUtils.isEmpty((String)sKz) && sKz.compareToIgnoreCase("admin") != 0) {
                contextMap.put("kontroler_zarzadzania_d", CKDTools.getDefaultKzForShop(s_store_no));
            }
            this.activityService.setActivityContext(sProcessId, sActivityId, contextMap);
            this.processService.setProcessContext(sProcessId, contextMap);
        }
        catch (Exception e) {
            log.error((Object)("CKD_GetIniData - processid " + sProcessId + " wystapil blad " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }
}

