/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd;

import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.PrepeareDoc;
import com.plusmpm.database.DocumentTemplateTable;
import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.ckd.CKDTools;
import com.suncode.lm.categories.Categories;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.DocumentTemplateService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class CKD_GenerateZestawienie {
    public static Logger log = Logger.getLogger(CKD_GenerateZestawienie.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private DocumentTemplateService documentTemplateService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService documentClassService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("ckd_generatezestawienie-app")).name("ckd_generatezestawienie-app.name")).description("ckd_generatezestawienie-app.desc")).category(new Category[]{Categories.CLIENT})).icon((Icon)SilkIconPack.APPLICATION);
    }

    public void execute(ApplicationContext applicationContext, ActivityContextMap activityContext) throws Exception {
        double limit = 0.5;
        String sProcessId = applicationContext.getProcessId();
        String sActivityId = applicationContext.getActivityId();
        log.info((Object)("CKD_GenerateZestawienie - processid: " + sProcessId + ", activityid: " + sActivityId));
        try {
            String outputDocClassName = CKDTools._zrDocClassName;
            DocumentTemplateTable dtt = this.documentTemplateService.getByName("ckd_zestawienie", new String[0]);
            String docxPath = dtt.getTemplatePath();
            Map mappings = this.processService.getProcessContext(sProcessId);
            String sDataDokumentu = Functions.getCurrentDate("yyyy-MM-dd");
            mappings.put("data_dokumentu", sDataDokumentu);
            mappings.put("tmp_stan_bo", "");
            mappings.put("tmp_stan_fiz", "");
            mappings.put("tmp_kom", "");
            HashMap<String, Object> optionalParameters = new HashMap<String, Object>();
            optionalParameters.put("variablesMarker", "@");
            ArrayList<Boolean> lWhichTables = new ArrayList<Boolean>();
            lWhichTables.add(false);
            lWhichTables.add(true);
            lWhichTables.add(true);
            optionalParameters.put("whichTables", lWhichTables);
            ArrayList<Boolean> lWhichHeaders = new ArrayList<Boolean>();
            lWhichHeaders.add(false);
            lWhichHeaders.add(true);
            lWhichHeaders.add(true);
            optionalParameters.put("whichHeaders", lWhichHeaders);
            String[] tRoznicaIl = mappings.get("roznica_il").toString().split(";", -1);
            String[] tReferencjaLm = mappings.get("referencja_lm").toString().split(";", -1);
            String[] tOpisReferencji = mappings.get("opis").toString().split(";", -1);
            String[] tIloscZwalo = mappings.get("ilosc_zwalo").toString().split(";", -1);
            Object sReferencjaLm = "";
            Object sOpisReferencji = "";
            Object sIloscZwalo = "";
            boolean flaga = false;
            for (int i = 0; i < tRoznicaIl.length; ++i) {
                Double dRoznicaIl = Double.valueOf(tRoznicaIl[i]);
                if (!(dRoznicaIl < limit * -1.0) && !(dRoznicaIl > limit)) continue;
                if (flaga) {
                    sReferencjaLm = (String)sReferencjaLm + ";";
                    sOpisReferencji = (String)sOpisReferencji + ";";
                    sIloscZwalo = (String)sIloscZwalo + ";";
                }
                sReferencjaLm = (String)sReferencjaLm + tReferencjaLm[i];
                sOpisReferencji = (String)sOpisReferencji + tOpisReferencji[i];
                sIloscZwalo = (String)sIloscZwalo + tIloscZwalo[i];
                flaga = true;
            }
            mappings.put("referencja_lm", sReferencjaLm);
            mappings.put("opis", sOpisReferencji);
            mappings.put("ilosc_zwalo", Functions.changeDoubleFormat(String.valueOf(sIloscZwalo)));
            Long docId = PrepeareDoc.createPdfAndSaveInArchive((String)docxPath, (String)outputDocClassName, (Map)mappings, (String)sProcessId, optionalParameters);
            if (docId != null && docId != -1L) {
                Map conntextMap = this.processService.getProcessContext(sProcessId);
                String sDocIds = conntextMap.get("DocIds").toString();
                if (sDocIds.compareTo("") == 0) {
                    conntextMap.put("DocIds", String.valueOf(docId));
                } else {
                    sDocIds = sDocIds.concat(",").concat(String.valueOf(docId));
                    conntextMap.put("DocIds", sDocIds);
                }
                DocumentClass documentClass = this.documentClassService.getDocumentClass(outputDocClassName, new String[0]);
                WfDocument wfDocument = this.documentFinder.findByFileId(docId, documentClass.getId());
                this.documentService.attachDocumentToProcess(wfDocument, "admin", sProcessId, sActivityId);
                String tmp_data = conntextMap.get("data").toString();
                String separator = "";
                if (tmp_data != null && !StringUtils.isEmpty((String)tmp_data)) {
                    separator = ";";
                }
                conntextMap.put("data", tmp_data.concat(separator).concat(sDataDokumentu));
                conntextMap.put("lokalizacja_os_kontaktowej", conntextMap.get("lokalizacja_os_kontaktowej").toString().concat(separator));
                conntextMap.put("osoba_kontaktu", conntextMap.get("osoba_kontaktu").toString().concat(separator));
                conntextMap.put("rodzaj_dokumentu", conntextMap.get("rodzaj_dokumentu").toString().concat(separator).concat(CKDTools._zrfileDesc));
                conntextMap.put("ustalenia", conntextMap.get("ustalenia").toString().concat(separator));
                conntextMap.put("ls", conntextMap.get("ls").toString().concat(separator));
                conntextMap.put("login_osoby_uzupelniajacej", conntextMap.get("login_osoby_uzupelniajacej").toString().concat(separator).concat("admin"));
                conntextMap.put("zal_fileid", conntextMap.get("zal_fileid").toString().concat(separator).concat(String.valueOf(docId)));
                conntextMap.put("zal_docclass", conntextMap.get("zal_docclass").toString().concat(separator).concat(outputDocClassName));
                this.processService.setProcessContext(sProcessId, conntextMap);
                log.debug((Object)"DocId = ".concat(String.valueOf(docId)).concat(", dodano dokument do procesu"));
            }
        }
        catch (Exception e) {
            log.error((Object)("Generowanie zestawienia rozbieznosci nie powiod\u0142o si\u0119 - processid: " + sProcessId + ": " + e.getMessage()), (Throwable)e);
        }
    }
}

