/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd;

import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.PrepeareDoc;
import com.plusmpm.database.DocumentTemplateTable;
import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.ckd.CKDTools;
import com.suncode.lm.categories.Categories;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.DocumentTemplateService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class CKD_GenerateLS {
    public static Logger log = Logger.getLogger(CKD_GenerateLS.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private DocumentTemplateService documentTemplateService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService documentClassService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("ckd_generatels-app")).name("ckd_generatels-app.name")).description("ckd_generatels-app.desc")).category(new Category[]{Categories.CLIENT})).icon((Icon)SilkIconPack.APPLICATION);
    }

    public void execute(ApplicationContext applicationContext, ActivityContextMap activityContext) throws Exception {
        String sProcessId = applicationContext.getProcessId();
        String sActivityId = applicationContext.getActivityId();
        log.info((Object)("CKD_GenerateLS - processid: " + sProcessId + ", activityid: " + sActivityId));
        try {
            Map conntextMap;
            Map mappings = this.processService.getProcessContext(sProcessId);
            String sStatus = mappings.get("status").toString();
            int ls_no = 0;
            if (sStatus.compareTo("KS I") == 0) {
                ls_no = 1;
            } else if (sStatus.compareTo("KS II") == 0) {
                ls_no = 2;
            } else if (sStatus.compareTo("KS III") == 0) {
                ls_no = 3;
            } else if (sStatus.compareTo("W analizie") == 0) {
                ls_no = 1;
            } else {
                throw new Exception("Nieznany status listu spornego");
            }
            log.info((Object)("CKD_GenerateLS - generowanie listu nr: " + ls_no));
            String outputDocClassName = CKDTools._lsDocClassName;
            DocumentTemplateTable dtt = this.documentTemplateService.getByName("ckd_ls_" + ls_no, new String[0]);
            String docxPath = dtt.getTemplatePath();
            String sDataDokumentu = Functions.getCurrentDate("yyyy-MM-dd");
            mappings.put("data_dokumentu", sDataDokumentu);
            mappings.put("zamowienie", mappings.get("zamowienie").toString().replaceAll(";", ";\t"));
            mappings.put("data_odbioru", mappings.get("data_odbioru").toString().replaceAll(";", ";\t"));
            if ((String)mappings.get("numer_faktury") != null && !StringUtils.isEmpty((String)((String)mappings.get("numer_faktury")))) {
                mappings.put("numer_faktury", mappings.get("numer_faktury").toString().replaceAll(";", ";\t"));
            }
            if ((String)mappings.get("data_faktury") != null && !StringUtils.isEmpty((String)((String)mappings.get("data_faktury")))) {
                mappings.put("data_faktury", mappings.get("data_faktury").toString().replaceAll(";", ";\t"));
            }
            if ((String)mappings.get("ustalenia") != null && !StringUtils.isEmpty((String)((String)mappings.get("ustalenia")))) {
                String[] tUstalenia = mappings.get("ustalenia").toString().split(";", -1);
                Object newUstalenia = "";
                for (String res : tUstalenia) {
                    if (res == null || StringUtils.isEmpty((String)res)) continue;
                    newUstalenia = (String)newUstalenia + res + ";";
                }
                if (((String)newUstalenia).length() > 0) {
                    newUstalenia = ((String)newUstalenia).substring(0, ((String)newUstalenia).length() - 1);
                }
                mappings.put("ustalenia", newUstalenia);
            }
            String[] tLp = mappings.get("lp").toString().split(";", -1);
            String[] tReferencjaLm = mappings.get("referencja_lm").toString().split(";", -1);
            String[] tOpisReferencji = mappings.get("opis").toString().split(";", -1);
            String[] tCenaFry = mappings.get("cena_z_fry").toString().split(";", -1);
            String[] tCenaZam = mappings.get("cena_z_zamowienia").toString().split(";", -1);
            String[] tIloscZwalo = mappings.get("ilosc_zwalo").toString().split(";", -1);
            String[] tUszkodzenia = mappings.get("uszkodzenia").toString().split(";", -1);
            String[] tIloscFry = mappings.get("ilosc_z_fry").toString().split(";", -1);
            String[] tRoznicaCenowa = mappings.get("roznica_cenowa").toString().split(";", -1);
            String[] tRoznicaIl = mappings.get("roznica_il").toString().split(";", -1);
            String[] tRoznicaWf = mappings.get("roznica_w_f").toString().split(";", -1);
            Object sLp = "";
            Object sReferencjaLm = "";
            Object sOpisReferencji = "";
            Object sCenaFry = "";
            Object sCenaZam = "";
            Object sIloscZwalo = "";
            Object sUszkodzenia = "";
            Object sIloscFry = "";
            Object sRoznicaCenowa = "";
            Object sRoznicaIl = "";
            Object sRoznicaWf = "";
            boolean flaga = false;
            for (int i = 0; i < tReferencjaLm.length; ++i) {
                double dRoznicaIl = Functions.changeStringToDouble(tRoznicaIl[i]);
                double dRoznicaCen = Functions.changeStringToDouble(tRoznicaCenowa[i]);
                if (dRoznicaIl == 0.0 && dRoznicaCen == 0.0) continue;
                if (flaga) {
                    sLp = (String)sLp + ";";
                    sReferencjaLm = (String)sReferencjaLm + ";";
                    sOpisReferencji = (String)sOpisReferencji + ";";
                    sCenaFry = (String)sCenaFry + ";";
                    sCenaZam = (String)sCenaZam + ";";
                    sIloscZwalo = (String)sIloscZwalo + ";";
                    sUszkodzenia = (String)sUszkodzenia + ";";
                    sIloscFry = (String)sIloscFry + ";";
                    sRoznicaCenowa = (String)sRoznicaCenowa + ";";
                    sRoznicaIl = (String)sRoznicaIl + ";";
                    sRoznicaWf = (String)sRoznicaWf + ";";
                }
                sLp = (String)sLp + Functions.getValueFromTable(tLp, i);
                sReferencjaLm = (String)sReferencjaLm + Functions.getValueFromTable(tReferencjaLm, i);
                sOpisReferencji = (String)sOpisReferencji + Functions.getValueFromTable(tOpisReferencji, i);
                sCenaFry = (String)sCenaFry + Functions.getValueFromTable(tCenaFry, i);
                sCenaZam = (String)sCenaZam + Functions.getValueFromTable(tCenaZam, i);
                sIloscZwalo = (String)sIloscZwalo + Functions.getValueFromTable(tIloscZwalo, i);
                sUszkodzenia = (String)sUszkodzenia + Functions.getValueFromTable(tUszkodzenia, i);
                sIloscFry = (String)sIloscFry + Functions.getValueFromTable(tIloscFry, i);
                sRoznicaCenowa = (String)sRoznicaCenowa + Functions.getValueFromTable(tRoznicaCenowa, i);
                sRoznicaIl = (String)sRoznicaIl + Functions.getValueFromTable(tRoznicaIl, i);
                sRoznicaWf = (String)sRoznicaWf + Functions.getValueFromTable(tRoznicaWf, i);
                flaga = true;
            }
            mappings.put("lp", sLp);
            mappings.put("referencja_lm", sReferencjaLm);
            mappings.put("opis", sOpisReferencji);
            mappings.put("cena_z_fry", Functions.changeDoubleFormat((String)sCenaFry));
            mappings.put("cena_z_zamowienia", Functions.changeDoubleFormat((String)sCenaZam));
            mappings.put("ilosc_zwalo", Functions.changeDoubleFormat((String)sIloscZwalo));
            mappings.put("uszkodzenia", Functions.changeDoubleFormat((String)sUszkodzenia));
            mappings.put("ilosc_z_fry", Functions.changeDoubleFormat((String)sIloscFry));
            mappings.put("roznica_cenowa", Functions.changeDoubleFormat((String)sRoznicaCenowa));
            mappings.put("roznica_il", Functions.changeDoubleFormat((String)sRoznicaIl));
            mappings.put("roznica_w_f", Functions.changeDoubleFormat((String)sRoznicaWf));
            Object sTyp = "";
            Object sZafakturowano = "";
            Object sKwotaProszona = "";
            Object sRoznica = "";
            Object sLpK = "";
            String[] tTyp = mappings.get("typ_kosztow").toString().split(";", -1);
            String[] tZafakturowano = mappings.get("zafakturowano").toString().split(";", -1);
            String[] tKwotaProszona = mappings.get("kwota_proszona").toString().split(";", -1);
            int inc = 0;
            double roznica_kosztow = 0.0;
            for (int i = 0; i < tZafakturowano.length; ++i) {
                double d1 = Functions.changeStringToDouble(tZafakturowano[i]);
                double d2 = Functions.changeStringToDouble(tKwotaProszona[i]);
                roznica_kosztow += Functions.RoundValue(d2 - d1, 2);
                if (d1 == d2) continue;
                sTyp = (String)sTyp + tTyp[i] + ";";
                sZafakturowano = (String)sZafakturowano + tZafakturowano[i] + ";";
                sKwotaProszona = (String)sKwotaProszona + tKwotaProszona[i] + ";";
                sRoznica = (String)sRoznica + String.valueOf(Functions.RoundValue(d2 - d1, 2)) + ";";
                sLpK = (String)sLpK + String.valueOf(++inc) + ";";
            }
            String sInfo = "Brak rozbie\u017cno\u015bci w pozycji KOSZTY POZOSTA\u0141E.";
            if (sTyp != null && !StringUtils.isEmpty((String)sTyp)) {
                sTyp = ((String)sTyp).substring(0, ((String)sTyp).length() - 1);
                sZafakturowano = ((String)sZafakturowano).substring(0, ((String)sZafakturowano).length() - 1);
                sKwotaProszona = ((String)sKwotaProszona).substring(0, ((String)sKwotaProszona).length() - 1);
                sRoznica = ((String)sRoznica).substring(0, ((String)sRoznica).length() - 1);
                sLpK = ((String)sLpK).substring(0, ((String)sLpK).length() - 1);
                sInfo = "";
            }
            if (roznica_kosztow != 0.0) {
                mappings.put("koszty_transportu_info", "Zostali\u015bmy obci\u0105\u017ceni przez Pa\u0144stwa kosztami transportu/opakowa\u0144. R\u00f3\u017cnica pomi\u0119dzy kwot\u0105 przez nas akceptowan\u0105 a faktur\u0105 wynosi: " + roznica_kosztow + " " + mappings.get("waluta").toString());
            } else {
                mappings.put("koszty_transportu_info", "");
            }
            mappings.put("roznica_kosztow", roznica_kosztow);
            mappings.put("pozostale_info", sInfo);
            mappings.put("typ_kosztow", sTyp);
            mappings.put("zafakturowano", Functions.changeDoubleFormat((String)sZafakturowano));
            mappings.put("kwota_proszona", Functions.changeDoubleFormat((String)sKwotaProszona));
            log.debug((Object)("zafakturowano:|" + (String)sZafakturowano + "|"));
            log.debug((Object)("zafakturowano:|" + Functions.changeDoubleFormat((String)sZafakturowano) + "|"));
            log.debug((Object)("kwota_proszona:|" + (String)sKwotaProszona + "|"));
            log.debug((Object)("kwota_proszona:|" + Functions.changeDoubleFormat((String)sKwotaProszona) + "|"));
            mappings.put("pozostale_roznica", Functions.changeDoubleFormat((String)sRoznica));
            mappings.put("klp", Functions.changeDoubleFormat((String)sLpK));
            HashMap<String, Object> optionalParameters = new HashMap<String, Object>();
            ArrayList<Boolean> lWhichTables = new ArrayList<Boolean>();
            lWhichTables.add(true);
            lWhichTables.add(false);
            ArrayList<Boolean> lWhichHeaders = new ArrayList<Boolean>();
            lWhichHeaders.add(false);
            lWhichHeaders.add(false);
            if (ls_no == 1) {
                lWhichTables.add(true);
                lWhichTables.add(false);
                lWhichTables.add(true);
                lWhichTables.add(false);
                lWhichHeaders.add(true);
                lWhichHeaders.add(false);
                lWhichHeaders.add(true);
                lWhichHeaders.add(false);
            }
            optionalParameters.put("variablesMarker", "@");
            optionalParameters.put("whichTables", lWhichTables);
            optionalParameters.put("whichHeaders", lWhichHeaders);
            Long docId = PrepeareDoc.createPdfAndSaveInArchive((String)docxPath, (String)outputDocClassName, (Map)mappings, (String)sProcessId, optionalParameters);
            if (docId != null && docId != -1L) {
                conntextMap = this.processService.getProcessContext(sProcessId);
                String sDocIds = conntextMap.get("DocIds").toString();
                if (sDocIds.compareTo("") == 0) {
                    conntextMap.put("DocIds", String.valueOf(docId));
                } else {
                    sDocIds = sDocIds.concat(",").concat(String.valueOf(docId));
                    conntextMap.put("DocIds", sDocIds);
                }
                DocumentClass documentClass = this.documentClassService.getDocumentClass(outputDocClassName, new String[0]);
                WfDocument wfDocument = this.documentFinder.findByFileId(docId, documentClass.getId());
                this.documentService.attachDocumentToProcess(wfDocument, "admin", sProcessId, sActivityId);
                String tmp_data = conntextMap.get("data").toString();
                String separator = "";
                if (tmp_data != null && !StringUtils.isEmpty((String)tmp_data)) {
                    separator = ";";
                }
                conntextMap.put("data", tmp_data.concat(separator).concat(sDataDokumentu));
                conntextMap.put("lokalizacja_os_kontaktowej", conntextMap.get("lokalizacja_os_kontaktowej").toString().concat(separator));
                conntextMap.put("osoba_kontaktu", conntextMap.get("osoba_kontaktu").toString().concat(separator));
                conntextMap.put("rodzaj_dokumentu", conntextMap.get("rodzaj_dokumentu").toString().concat(separator).concat(CKDTools._lsFileDesc));
                conntextMap.put("ustalenia", conntextMap.get("ustalenia").toString().concat(separator));
                conntextMap.put("ls", conntextMap.get("ls").toString().concat(separator));
                conntextMap.put("login_osoby_uzupelniajacej", conntextMap.get("login_osoby_uzupelniajacej").toString().concat(separator).concat("admin"));
                conntextMap.put("zal_fileid", conntextMap.get("zal_fileid").toString().concat(separator).concat(String.valueOf(docId)));
                conntextMap.put("zal_docclass", conntextMap.get("zal_docclass").toString().concat(separator).concat(outputDocClassName));
                if (conntextMap.get("status").toString().indexOf("KS") < 0) {
                    conntextMap.put("status", "KS I");
                }
            } else {
                throw new Exception("Wyst\u0105pi\u0142 b\u0142\u0105d podczas generowania dokumentu.");
            }
            this.processService.setProcessContext(sProcessId, conntextMap);
            log.debug((Object)"DocId = ".concat(String.valueOf(docId)).concat(", dodano dokument do procesu"));
        }
        catch (Exception e) {
            log.error((Object)("Generowanie zestawienia rozbieznosci nie powiod\u0142o si\u0119 - processid: " + sProcessId + ": " + e.getMessage()), (Throwable)e);
            Functions.addCommentToActivity(sProcessId, sActivityId, "Dodawanie listu spornego zako\u0144czone niepowodzeniem: " + e.getMessage());
            throw e;
        }
    }
}

