/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015.ckd;

import com.plusmpm.CUF.util.DataChoosers.ExecuteQueryDataChooser;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class CKDTools {
    public static Logger log = Logger.getLogger(CKDTools.class);
    public static String _lsDocClassName = "CKD - Listy sporne";
    public static String _lsFileDesc = "List sporny dla dostawcy";
    public static String _zrDocClassName = "CKD - Zestawienie rozbie\u017cno\u015bci";
    public static String _zrfileDesc = "Zestawienie rozbie\u017cno\u015bci";

    public static Date getTerminPlatnosci(String pay_term, Date dDataOdbioru, Date dDataFaktury) {
        try {
            SQLFinder sqlFinder = FinderFactory.getSQLFinder();
            SQLBuilder builder = new SQLBuilder();
            builder.setQuery("select CAST(dni as INT) as dni, formula from pm_custom_terminy_platnosci where upper(symbol)=:pay_term");
            builder.addScalar("dni", (Type)StandardBasicTypes.INTEGER);
            builder.addScalar("formula", (Type)StandardBasicTypes.STRING);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("pay_term", pay_term.toUpperCase());
            builder.setParameters(parameters);
            List data = sqlFinder.find(builder);
            if (data.size() > 0) {
                String sFormula = (String)((Map)data.get(0)).get("formula");
                int dni = Integer.valueOf(((Map)data.get(0)).get("dni").toString());
                return CKDTools.getTerminPlatnosci(pay_term, dDataOdbioru, dDataFaktury, sFormula, dni);
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Date getTerminPlatnosci(String pay_term, Date dDataOdbioru, Date dDataFaktury, String sFormula, int dni) {
        Date result = null;
        if (StringUtils.isNotEmpty((CharSequence)sFormula)) {
            log.debug((Object)("getTerminPlatnosci - wyznaczaanie terminu dla formuly " + sFormula));
            log.debug((Object)("pay_term: " + pay_term + ", dDataOdbioru: " + String.valueOf(dDataOdbioru) + ", dDataFaktury: " + String.valueOf(dDataFaktury) + ", sFormula: " + sFormula + ", dni: " + dni));
            Calendar cal = Calendar.getInstance();
            cal.setTime(dDataOdbioru);
            if (sFormula.compareToIgnoreCase("A") == 0) {
                log.trace((Object)" wyliczanie terminu platnosci dla metody A: data_odbioru+ilosc_dni");
                cal.add(5, dni);
            } else if (sFormula.compareToIgnoreCase("D") == 0) {
                log.trace((Object)" wyliczanie terminu platnosci dla metody D: 10 nastepnego miesiaca od (data_odbioru+ilosc_dni)");
                cal.add(5, dni);
                cal.add(2, 1);
                cal.set(5, 10);
            } else if (sFormula.compareToIgnoreCase("F") == 0) {
                log.trace((Object)" wyliczanie terminu platnosci dla metody D: 30 nastepnego miesiaca od (data_odbioru+ilosc_dni)");
                cal.add(5, dni);
                cal.add(2, 1);
                cal.set(5, 30);
            } else if (sFormula.compareToIgnoreCase("Q") == 0) {
                log.trace((Object)" wyliczanie terminu platnosci dla metody D: 15 nastepnego miesiaca od (data_odbioru+ilosc_dni)");
                cal.add(5, dni);
                cal.add(2, 1);
                cal.set(5, 15);
            } else {
                return null;
            }
            result = cal.getTime();
            log.debug((Object)("result: " + String.valueOf(result)));
        }
        return result;
    }

    public static String getDefaultKzForShop(String sSklep) {
        return CKDTools.getQueryResultForShop("ckd_get_default_kz", "user", sSklep);
    }

    public static String getKsieForShop(String sSklep) {
        return CKDTools.getQueryResultForShop("ckd_get_ksie_for_store", "user", sSklep);
    }

    public static String getDptForShop(String sSklep) {
        return CKDTools.getQueryResultForShop("ckd_get_dpt_for_store", "user", sSklep);
    }

    public static String getQueryResultForShop(String sQueryName, String sUserColumn, String sSklep) {
        Object sListaOsob = "";
        if (sSklep.indexOf(45) > 0) {
            sSklep = sSklep.split(" - ")[0];
        }
        ExecuteQueryDataChooser dc = new ExecuteQueryDataChooser();
        HashMap<String, String> customKeys = new HashMap<String, String>();
        customKeys.put("NameForQuery", sQueryName);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("sklep", sSklep);
        List result = dc.getDataChooserResult(0, 50, sUserColumn, "DESC", criteria, customKeys);
        for (Map oneRes : result) {
            sListaOsob = (String)sListaOsob + (String)oneRes.get(sUserColumn) + ";";
        }
        if (((String)sListaOsob).length() > 0) {
            sListaOsob = ((String)sListaOsob).substring(0, ((String)sListaOsob).length() - 1);
        }
        if (((String)sListaOsob).compareTo("") == 0) {
            log.warn((Object)("B\u0142\u0105d! Brak wynikow dla zapytania " + sQueryName + " dla sklepu " + sSklep));
            sListaOsob = "admin";
        }
        return sListaOsob;
    }
}

