/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015;

import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.io.DataInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PobierzKursWaluty {
    public static Logger log = Logger.getLogger(PobierzKursWaluty.class);
    private static Map<String, Map<String, String>> rates = new HashMap<String, Map<String, String>>();
    private static SimpleDateFormat workflowDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public static HashMap<String, String> pobierz_kurs_waluty(HashMap<String, String> data_waluta) throws Exception {
        HashMap<String, String> data_waluta_kurs = new HashMap<String, String>();
        try {
            for (int k = 0; k < data_waluta.keySet().toArray().length; ++k) {
                String[] dekod = data_waluta.keySet().toArray()[k].toString().split(";");
                String waluta = dekod[0];
                String Data = dekod[1];
                log.debug((Object)("waluta" + waluta + " Data" + Data));
                String[] data_czesci = Data.split("-");
                data_czesci[2] = Integer.valueOf(data_czesci[2]) > 1900 ? String.valueOf(Integer.valueOf(data_czesci[2]) - 1900) : String.valueOf(Integer.valueOf(data_czesci[2]) + 100);
                Date data_kursu = new Date(Integer.valueOf(data_czesci[2]), Integer.valueOf(data_czesci[1]) - 1, Integer.valueOf(data_czesci[0]));
                log.debug((Object)("data_kursu" + String.valueOf(data_kursu)));
                double kurs_sprzedazy = PobierzKursWaluty.getCurrencyRateFromNbp(waluta, workflowDateFormat.format(data_kursu.getTime()));
                data_waluta_kurs.put(waluta + Data, String.valueOf(kurs_sprzedazy).replace(",", ".") + ";" + Data);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return data_waluta_kurs;
    }

    public static Double getCurrencyRateFromNbp(String currency, String currencyDate) {
        Double kurs;
        block23: {
            SimpleDateFormat nbpListDateFormat = new SimpleDateFormat("yyMMdd");
            kurs = null;
            try {
                if (currency.compareTo("PLN") != 0) {
                    String currencyRate;
                    Map<String, String> dailyRates = rates.get(currencyDate);
                    if (dailyRates != null && (currencyRate = dailyRates.get(currency)) != null && currencyRate.compareTo("null") != 0) {
                        log.debug((Object)("Kurs pobrany z mapy:" + currencyRate));
                        kurs = Double.valueOf(currencyRate.replace(",", "."));
                    }
                    if (kurs == null) {
                        URL oURL;
                        ArrayList<String> lista_xml;
                        Calendar cal = Calendar.getInstance();
                        Integer nCurrentYear = cal.get(1);
                        cal.setTime(workflowDateFormat.parse(currencyDate));
                        Integer nSearchYear = cal.get(1);
                        String szukana_data = nbpListDateFormat.format(cal.getTime());
                        String data_ustalenia_kursu = workflowDateFormat.format(cal.getTime());
                        String sURL = SystemProperties.getString((String)"adresnbp1");
                        Object sURLWithYear = sURL;
                        if (nCurrentYear > nSearchYear) {
                            sURLWithYear = (String)sURLWithYear + nSearchYear.toString();
                        }
                        if ((lista_xml = PobierzKursWaluty.getXMLCurrencyList(oURL = new URL((String)(sURLWithYear = (String)sURLWithYear + ".txt")))).size() != 0) {
                            try {
                                Object url = SystemProperties.getString((String)"adresnbp2");
                                boolean nieznaleziono = true;
                                while (nieznaleziono) {
                                    boolean bChangeYear = false;
                                    for (int i = 0; i < lista_xml.size(); ++i) {
                                        if (lista_xml.get(i).toString().indexOf(szukana_data) == -1) continue;
                                        url = (String)url + lista_xml.get(i) + ".xml";
                                        nieznaleziono = false;
                                        break;
                                    }
                                    cal.add(5, -1);
                                    if (cal.get(1) < nSearchYear) {
                                        if (bChangeYear) break;
                                        Integer i = nSearchYear;
                                        nSearchYear = nSearchYear - 1;
                                        sURLWithYear = sURL + nSearchYear.toString() + ".txt";
                                        oURL = new URL((String)sURLWithYear);
                                        lista_xml = PobierzKursWaluty.getXMLCurrencyList(oURL);
                                        if (lista_xml.isEmpty()) break;
                                        bChangeYear = true;
                                    }
                                    szukana_data = nbpListDateFormat.format(cal.getTime());
                                    log.debug((Object)("Szukana data w pliku NBP: " + szukana_data));
                                    data_ustalenia_kursu = workflowDateFormat.format(cal.getTime());
                                }
                                if (!nieznaleziono) {
                                    String kurs_sprzedazy = "";
                                    String przelicznik = "";
                                    try {
                                        String thisLine;
                                        URL u = new URL((String)url);
                                        URLConnection con = u.openConnection();
                                        con.setConnectTimeout(10000);
                                        con.setReadTimeout(60000);
                                        DataInputStream theHTML = new DataInputStream(con.getInputStream());
                                        String szukana_linia = "<kod_waluty>" + currency + "</kod_waluty>";
                                        while ((thisLine = theHTML.readLine()) != null) {
                                            if (thisLine.toString().indexOf("<przelicznik>") != -1) {
                                                przelicznik = thisLine.replace("</przelicznik>", "");
                                                przelicznik = przelicznik.replace("<przelicznik>", "");
                                                przelicznik = przelicznik.trim();
                                                przelicznik = przelicznik.replace(",", ".");
                                            }
                                            if (thisLine.toString().indexOf(szukana_linia) == -1) continue;
                                            thisLine = theHTML.readLine();
                                            kurs_sprzedazy = thisLine.replace("</kurs_sredni>", "");
                                            kurs_sprzedazy = kurs_sprzedazy.replace("<kurs_sredni>", "");
                                            kurs_sprzedazy = kurs_sprzedazy.trim();
                                            kurs_sprzedazy = kurs_sprzedazy.replace(",", ".");
                                            break;
                                        }
                                        if (kurs_sprzedazy.compareTo("") != 0 && przelicznik.compareTo("") != 0) {
                                            kurs = Double.valueOf(kurs_sprzedazy) / Double.valueOf(przelicznik);
                                        }
                                        log.debug((Object)("Zakonczenie pobierania kursu " + currency + " z dnia " + currencyDate + "(" + data_ustalenia_kursu + ")"));
                                    }
                                    catch (Exception e) {
                                        log.error((Object)("B\u0142\u0105d podczas pobierania kursu " + currency + " z NBP"));
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    try {
                        Date dCurrentDate = new Date();
                        Date dCurrencyDate = workflowDateFormat.parse(currencyDate);
                        if (dCurrencyDate.getTime() <= dCurrentDate.getTime()) {
                            if (dailyRates == null) {
                                dailyRates = new HashMap<String, String>();
                            }
                            DecimalFormat formatter = new DecimalFormat("#.####");
                            if (kurs != null) {
                                dailyRates.put(currency, formatter.format(kurs));
                                rates.put(currencyDate, dailyRates);
                            }
                        }
                        break block23;
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    break block23;
                }
                kurs = 1.0;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return kurs;
    }

    public static ArrayList<String> getXMLCurrencyList(URL url) {
        ArrayList<String> lista_xml = new ArrayList<String>();
        try {
            String thisLine;
            log.debug((Object)url.toString());
            URLConnection con = url.openConnection();
            con.setConnectTimeout(10000);
            con.setReadTimeout(60000);
            DataInputStream theHTML = new DataInputStream(con.getInputStream());
            while ((thisLine = theHTML.readLine()) != null) {
                int test = thisLine.substring(0, 1).compareTo("a");
                if (test != 0) continue;
                lista_xml.add(thisLine);
            }
            log.debug((Object)"Zakonczenie pobierania listy XML z NBP");
        }
        catch (Exception e) {
            log.error((Object)"B\u0142\u0105d podczas pobierania listy XML z NBP");
        }
        return lista_xml;
    }
}

