/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.extension.P0015;

import com.plusmpm.CUF.util.extension.MathFunctions;
import com.plusmpm.database.variableSet.VariableSetManager;
import com.plusmpm.database.variableSet.VariableSetPrimaryKey;
import com.plusmpm.database.variableSet.VariableSetTable;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.extension.P0015.OUMethods.OUData;
import com.plusmpm.util.extension.P0015.PobierzKursWaluty;
import com.plusmpm.util.extension.P0015.sprzedazowe.FSTools;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.database.sequence.SequenceService;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfservice.ConnectFailed;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class Functions {
    public static Logger log = Logger.getLogger(Functions.class);
    public static SQLFinder sqlFinder = FinderFactory.getSQLFinder();

    public static String getProcessData(String processType, String taskType, String fieldName) {
        String sQuery = "select distinct sprocessfieldvalue from pm_processdata where sprocesstypename = '" + processType + "' and stasktypename = '" + taskType + "' and sprocessfieldname = '" + fieldName + "'";
        log.debug((Object)("sQuery: " + sQuery));
        SQLBuilder sqlBuilder = new SQLBuilder();
        sqlBuilder.setQuery(sQuery);
        sqlBuilder.addScalar("sprocessfieldvalue", (Type)StandardBasicTypes.STRING);
        List results = sqlFinder.find(sqlBuilder);
        String value = "";
        if (results != null && results.size() > 0) {
            value = ((Map)results.get(0)).get("sprocessfieldvalue").toString();
        }
        return value;
    }

    public static String getRealName(String sUserLogin) {
        String sRealName = sUserLogin;
        try {
            sRealName = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserRealName(sUserLogin);
        }
        catch (Exception e) {
            log.error((Object)("Nie uda\u0142o si\u0119 pobra\u0107 RealName dla: " + sUserLogin + e.getLocalizedMessage()));
        }
        return sRealName;
    }

    public static String getUserEmail(String sUserLogin) {
        String sEmail = sUserLogin;
        try {
            sEmail = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserEMailAddress(sUserLogin);
        }
        catch (Exception e) {
            log.error((Object)("Nie uda\u0142o si\u0119 pobra\u0107 emailu dla: " + sUserLogin + e.getLocalizedMessage()));
        }
        return sEmail;
    }

    private static String createQuery(String[][] tabValue, String sPrefix, String sSufix, String sErrorMessage) {
        String sTemp = "";
        Object sQuery = "";
        for (int i = 0; i < tabValue.length; ++i) {
            sTemp = Functions.createRow(tabValue[i], sErrorMessage);
            if (sTemp.compareToIgnoreCase(sErrorMessage) == 0) continue;
            sQuery = (String)sQuery + sPrefix + sTemp + sSufix;
        }
        return sQuery;
    }

    private static String createRow(String[] value, String sErrorMessage) {
        Object sResult = "";
        sResult = value.length > 1 ? "'" + value[1] + "','" + value[0] + "','" + value[0] + " - " + value[1] + "'" : sErrorMessage;
        return sResult;
    }

    public static String insertToTab(String sTabName, String[][] tabValue, String sErrorMessage) {
        String sResult = "$error$";
        String sPrefix = "insert into " + sTabName + " values( ";
        String sSufix = "   ); ";
        String sQuery = Functions.createQuery(tabValue, sPrefix, sSufix, sErrorMessage);
        Functions.doUpdateQuery(sQuery);
        return sResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doSelectQuery(String sQuery, String sValue, String sRowSeparator) {
        Object result = "";
        Connection con = null;
        try {
            con = DBUtils.connectToDB();
            if (!con.isClosed()) {
                Statement st = null;
                st = con.createStatement();
                ResultSet rs = null;
                log.debug((Object)("Querry: " + sQuery));
                rs = st.executeQuery(sQuery);
                log.debug((Object)"Querry completed");
                while (rs.next()) {
                    result = (String)result + rs.getString(sValue) + sRowSeparator;
                }
                if (((String)result).length() > sRowSeparator.length()) {
                    result = ((String)result).substring(0, ((String)result).length() - sRowSeparator.length());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Functions - Problems while executing procedure (doSelectQuery)");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doUpdateQuery(String sQuery) {
        String result = "";
        Connection con = null;
        try {
            con = DBUtils.connectToDB();
            if (!con.isClosed()) {
                Statement st = null;
                st = con.createStatement();
                log.debug((Object)("Querry: " + sQuery));
                st.execute(sQuery);
                log.debug((Object)"Querry completed");
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Functions - Problems while executing procedure (doUpdateQuery)");
            }
        }
        return result;
    }

    public static String getCurrentDate(String sDataFormat) {
        java.util.Date dt = new java.util.Date();
        return Functions.getDate(dt, sDataFormat);
    }

    public static String getDate(String sDataFormat, long lTime) {
        java.util.Date dt = new java.util.Date();
        return Functions.getDate(dt, sDataFormat);
    }

    public static String getDate(java.util.Date dDate, String sDataFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(sDataFormat);
        String sDate = sdf.format(dDate);
        return sDate;
    }

    public static java.util.Date convertStringToDate(String sDate, String sDateFormat) {
        SimpleDateFormat df = new SimpleDateFormat(sDateFormat);
        java.util.Date dDate = null;
        try {
            dDate = df.parse(sDate);
        }
        catch (Exception e) {
            log.error((Object)e, e.fillInStackTrace());
        }
        return dDate;
    }

    public static boolean validateValue(String sValue, String sPattern) {
        log.debug((Object)("Value to validate: " + sValue));
        Pattern p = Pattern.compile(sPattern);
        Matcher m = p.matcher(sValue);
        boolean b = m.matches();
        log.debug((Object)("Validate result: " + b));
        return b;
    }

    public static String generateNextValue(String sValue, int iPosNr) {
        long lNr;
        Object sResult = "";
        sValue = sValue.replace("-", "_");
        String seqName = "seq_" + sValue;
        SequenceService sequenceService = ServiceFactory.getSequenceService();
        if (!sequenceService.sequenceExist(seqName)) {
            sequenceService.createSequence(seqName, 1, 1);
        }
        if ((lNr = sequenceService.getNextSequenceValue(seqName) + 1L) >= 0L) {
            boolean check = true;
            int nr = 0;
            if (--iPosNr >= 0) {
                nr = (int)Math.pow(10.0, iPosNr);
            }
            while (check) {
                if (lNr < (long)nr) {
                    sResult = (String)sResult + "0";
                    nr /= 10;
                    continue;
                }
                check = false;
            }
        }
        sResult = (String)sResult + lNr;
        return sResult;
    }

    public static String generateValue(String sYear, String sSklep, String sValue, int iPosNr) {
        long lNr;
        Object sResult = "";
        sValue = sValue.replace("-", "_");
        SequenceService sequenceService = ServiceFactory.getSequenceService();
        String seqName = "seq_" + sValue;
        log.debug((Object)("sequenceName: " + seqName));
        if (!sequenceService.sequenceExist(seqName)) {
            sequenceService.createSequence(seqName, 1, 1);
        }
        if ((lNr = sequenceService.getNextSequenceValue(seqName).longValue()) >= 0L) {
            boolean check = true;
            int nr = 0;
            if (--iPosNr >= 0) {
                nr = (int)Math.pow(10.0, iPosNr);
            }
            while (check) {
                if (lNr < (long)nr) {
                    sResult = (String)sResult + "0";
                    nr /= 10;
                    continue;
                }
                check = false;
            }
        }
        sResult = (String)sResult + lNr;
        return sResult;
    }

    public static String getOUNameByUserId(String sLogin) {
        String sResult = "";
        OrganizationalUnitFinder organizationalUnitFinder = FinderFactory.getOrganizationalUnitFinder();
        List aList = organizationalUnitFinder.findByUserName(sLogin, new String[0]);
        if (aList != null && aList.size() > 0) {
            sResult = ((OrganizationalUnit)aList.get(0)).getName();
        }
        return sResult;
    }

    public static double RoundValue(double number, int decimalPlaces) {
        double modifier = Math.pow(10.0, decimalPlaces);
        return (double)Math.round(number * modifier) / modifier;
    }

    public static String[] splitStringIntoTable(String sText, String sSeparator) {
        String[] table = null;
        if (sText != null) {
            table = sText.split(sSeparator);
        }
        return table;
    }

    public static String[] insertStringIntoTable(String sText) {
        String[] table = null;
        if (sText != null) {
            table = new String[sText.length()];
            for (int i = 0; i < table.length - 1; ++i) {
                table[i] = sText.substring(i, i + 1);
            }
        }
        return table;
    }

    public static int countCharInString(String sText, String sFind) {
        int iCount = 0;
        if (sText != null && sText.compareToIgnoreCase("") != 0) {
            for (int i = 0; i < sText.length() - 1; ++i) {
                if (sText.substring(i, i + 1).compareToIgnoreCase(sFind) != 0) continue;
                ++iCount;
            }
        } else {
            log.error((Object)("String is null or empty - countCharInString | sText: " + sText + " | sFind: " + sFind));
        }
        return iCount;
    }

    public static int[] getCharPosInString(String sText, String sFind) {
        int iPosition = 0;
        int[] iPosTab = null;
        if (sText != null && sText.compareToIgnoreCase("") != 0) {
            iPosTab = new int[Functions.countCharInString(sText, sFind)];
            for (int i = 0; i < sText.length() - 1; ++i) {
                if (sText.substring(i, i + 1).compareToIgnoreCase(sFind) != 0) continue;
                iPosTab[iPosition] = i;
            }
        } else {
            log.error((Object)("String is null or empty - countCharInString | sText: " + sText + " | sFind: " + sFind));
        }
        return iPosTab;
    }

    public static String[] generateValueFrom0to(int end) {
        String[] sTab = new String[++end];
        for (int i = 0; i < end; ++i) {
            sTab[i] = String.valueOf(i).toString();
        }
        return sTab;
    }

    public static boolean checkIfInteger(String sText) {
        boolean bResult = false;
        int iCount = 0;
        if (sText.length() == 1) {
            String[] sCheck = Functions.generateValueFrom0to(9);
            for (int i = 0; i < sCheck.length; ++i) {
                if (sText.compareToIgnoreCase(sText) != 0) continue;
                ++iCount;
            }
            if (iCount > 0) {
                bResult = true;
            }
        } else {
            log.error((Object)"Podany String ma wiecej niz 1 znak - nie mozna sprawdzic czy jest on liczba");
        }
        return bResult;
    }

    public static boolean checkIfCharIsNumber(char cChar) {
        boolean bResult = false;
        int iCount = 0;
        char[] tab = new char[10];
        tab[0] = 48;
        tab[0] = 49;
        tab[0] = 50;
        tab[0] = 51;
        tab[0] = 52;
        tab[0] = 53;
        tab[0] = 54;
        tab[0] = 55;
        tab[0] = 56;
        tab[0] = 57;
        for (int i = 0; i < 10; ++i) {
            if (tab[i] != cChar) continue;
            ++iCount;
        }
        if (iCount > 0) {
            bResult = true;
        }
        return bResult;
    }

    public static float changeStringToFloat(String sValue) {
        return Float.valueOf(sValue).floatValue();
    }

    public static double changeStringToDouble(String sValue) {
        double fKwota = 0.0;
        if (sValue != null) {
            fKwota = (sValue = sValue.replace(" ", "")).compareTo("") == 0 ? 0.0 : Double.valueOf(sValue);
        }
        return fKwota;
    }

    public static int changeStringToInteger(String sValue) {
        int fKwota = 0;
        if (sValue != null) {
            fKwota = (sValue = sValue.replace(" ", "")).compareTo("") == 0 ? 0 : Integer.valueOf(sValue);
        }
        return fKwota;
    }

    public static String changeListToString(List<String> list) {
        Object sResult = "";
        for (int i = 0; i < list.size(); ++i) {
            sResult = (String)sResult + list.get(i) + "\n";
        }
        if (((String)sResult).length() > 3) {
            sResult = ((String)sResult).substring(0, ((String)sResult).length() - 1);
        }
        return sResult;
    }

    public static float addValueFromTable(float[] fTable) {
        float fSum = 0.0f;
        for (int i = 0; i < fTable.length; ++i) {
            fSum += fTable[i];
        }
        return fSum;
    }

    public static double addValueFromDoubleTable(double[] fTable, int iRound) {
        double fSum = 0.0;
        for (int i = 0; i < fTable.length; ++i) {
            fSum += fTable[i];
        }
        fSum = Functions.RoundValue(fSum, iRound);
        return fSum;
    }

    public static float[] changeStringTabToFloatTable(List<String> sTable) {
        float[] fTable = new float[sTable.size()];
        for (int i = 0; i < sTable.size(); ++i) {
            String obj = sTable.get(i);
            String sTemp = obj.toString();
            fTable[i] = Functions.changeStringToFloat(sTemp);
        }
        return fTable;
    }

    public static double[] changeStringTabToDoubleTable(String[] sTable) {
        int iSize = sTable.length;
        double[] fTable = new double[iSize];
        for (int i = 0; i < iSize; ++i) {
            String obj = sTable[i];
            String sTemp = obj.toString();
            fTable[i] = Functions.changeStringToDouble(sTemp);
        }
        return fTable;
    }

    public static String changeParamSearch(String sText, String sFromParam, String sToParam) {
        String result = "";
        if (sFromParam != null && sFromParam.compareToIgnoreCase("") != 0 && sToParam != null && sToParam.compareToIgnoreCase("") != 0) {
            result = sText.replace(sFromParam, sToParam);
        }
        return result;
    }

    public static String getValFromDynamicTable(String sActivityId, String sProcessId, String sParamName) {
        String sResult = "";
        VariableSetPrimaryKey variableSetPrimaryKey = new VariableSetPrimaryKey();
        variableSetPrimaryKey.setSActivityId(sActivityId);
        variableSetPrimaryKey.setSProcessId(sProcessId);
        variableSetPrimaryKey.setSVariableId(sParamName);
        VariableSetTable setTable = VariableSetManager.getVariableSetValue((VariableSetPrimaryKey)variableSetPrimaryKey);
        if (setTable != null) {
            sResult = setTable.getSVariableValue();
        }
        return sResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getValueFromInvoiceProcess(String sProcessId, String sActivityId, String sValueName) {
        String sVal = "";
        SharkTransaction trans = null;
        try {
            trans = Shark.getInstance().createTransaction();
            String username = SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
            String password = SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
            ExecutionAdministration ea = null;
            ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            ea.connect(trans, username, password, "KlientTestowy", null);
            WfActivity wfActivity = SharkFunctions.GetWfActivity((SharkTransaction)trans, (ExecutionAdministration)ea, (String)sProcessId, (String)sActivityId);
            Map processContextMap = SharkFunctions.GetActivityContext((SharkTransaction)trans, (WfActivity)wfActivity);
            String obj = "";
            obj = sValueName;
            if (processContextMap != null) {
                sVal = processContextMap.get(obj).toString();
            }
            trans.commit();
        }
        catch (Throwable throwable) {
            log.error((Object)throwable.getMessage(), throwable);
            try {
                Shark.getInstance().emptyCaches(trans);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                trans.rollback();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        finally {
            try {
                Shark.getInstance().unlockProcesses(trans);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                trans.release();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        return sVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setVariableToActivity(SharkTransaction trans, String sActivityId, String sProcessId, Map<String, Object> mValList) {
        log.debug((Object)("setVariableToActivity for: " + sActivityId + " START"));
        String sResult = "";
        try {
            String username = SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
            String password = SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
            ExecutionAdministration ea = null;
            ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            ea.connect(trans, username, password, "KlientTestowy", null);
            WfActivity wfActivity = SharkFunctions.GetWfActivity((SharkTransaction)trans, (ExecutionAdministration)ea, (String)sProcessId, (String)sActivityId);
            if (wfActivity != null) {
                SharkFunctions.SetActivityResult((SharkTransaction)trans, (WfActivity)wfActivity, mValList);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getStackTrace());
        }
        log.debug((Object)("setVariableToActivity for: " + sActivityId + " END"));
        return sResult;
    }

    public static Map<Object, Object> getActivityMapTrans(SharkTransaction st, String sProcessID, String sActivityID) throws Exception {
        String username = SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
        String password = SystemProperties.getString((String)"DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
        ExecutionAdministration ea = null;
        ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
        try {
            ea.connect(st, username, password, "KlientTestowy", null);
        }
        catch (BaseException e) {
            log.error((Object)e.getMessage());
        }
        catch (ConnectFailed e) {
            log.error((Object)e.getMessage());
        }
        WfActivity wfActivity = SharkFunctions.GetWfActivity((SharkTransaction)st, (ExecutionAdministration)ea, (String)sProcessID, (String)sActivityID);
        Map mapActivityCtx = SharkFunctions.GetActivityContext((SharkTransaction)st, (WfActivity)wfActivity);
        return mapActivityCtx;
    }

    public static String getShopNameAndNo(String sNazwa_sklepu, String sSymbol) {
        Object sResult = "";
        sResult = sSymbol.indexOf("C0099") == 0 ? "CENTRALA - " + sSymbol : sNazwa_sklepu + " - " + sSymbol;
        return sResult;
    }

    public static double getExchangeRate(String sExchangeDate, String sCurrency) {
        StringBuilder sb;
        log.debug((Object)("getExchangeRate invoked - currency: " + sCurrency + " date: " + sExchangeDate));
        double nExRate = -1.0;
        HashMap<String, String> data_waluta = new HashMap<String, String>();
        String[] sDate = sExchangeDate.split("-");
        if (sDate.length == 3) {
            sb = new StringBuilder();
            sb.append(sDate[2]);
            sb.append("-");
            sb.append(sDate[1]);
            sb.append("-");
            sb.append(sDate[0]);
            sExchangeDate = sb.toString();
        }
        log.debug((Object)("sExchangeDate" + sExchangeDate + " sCurrency" + sCurrency));
        sb = new StringBuilder();
        sb.append(sCurrency);
        sb.append(";");
        sb.append(sExchangeDate);
        String sKey = sb.toString();
        log.debug((Object)("sKey" + sKey));
        data_waluta.put(sKey, "0");
        String sExRate = null;
        try {
            HashMap<String, String> map = PobierzKursWaluty.pobierz_kurs_waluty(data_waluta);
            sKey = sKey.replace(";", "");
            log.debug((Object)("sKey" + sKey));
            sExRate = map.get(sKey);
            log.debug((Object)("sExRate" + sExRate));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (sExRate != null) {
            sExRate = sExRate.substring(0, sExRate.indexOf(";"));
            nExRate = Functions.changeStringToDouble(sExRate);
            log.debug((Object)("getExchangeRate finished successfully, ex-rate: " + nExRate));
        } else {
            log.debug((Object)"No connection to NBP - seting fixed exchange rate");
            sExRate = SystemProperties.getString((String)("EX_RATE_" + sCurrency.toUpperCase())).replaceAll("[\"]", "");
            if (sExRate != null) {
                nExRate = Functions.changeStringToDouble(sExRate);
            }
        }
        return nExRate;
    }

    public static double getNBPExchangeRate(String sExchangeDate, String sCurrency) {
        java.util.Date oDate = Functions.convertStringToDate(sExchangeDate, "yyyy-MM-dd");
        log.debug((Object)("oDate" + String.valueOf(oDate)));
        Calendar cal = Calendar.getInstance();
        cal.setTime(oDate);
        cal.add(5, -1);
        oDate = cal.getTime();
        sExchangeDate = Functions.getDate(oDate, "yyyy-MM-dd");
        log.debug((Object)("sExchangeDate" + sExchangeDate));
        return Functions.getExchangeRate(sExchangeDate, sCurrency);
    }

    public static String getUsersListForLocalization(Set<String> sUsersSet, String sLocation) {
        Object sUsersList = "";
        for (String sUser : sUsersSet) {
            String sCashierOU = OUData.getUserOU(sUser);
            if (sCashierOU.indexOf(sLocation) != 0) continue;
            sUsersList = (String)sUsersList + sUser + ";";
        }
        if (((String)sUsersList).length() > 0) {
            sUsersList = ((String)sUsersList).substring(0, ((String)sUsersList).length() - 1);
        }
        return sUsersList;
    }

    public static double sumColumn(String sColumn) {
        String[] columns;
        double fResult = 0.0;
        for (String singleVal : columns = sColumn.split(";")) {
            double fVal = Functions.changeStringToDouble(singleVal);
            fResult = MathFunctions.add((double)fVal, (double)fResult);
        }
        return fResult;
    }

    public static double getWyplataZKasyWal(Map<Object, Object> activityMap) {
        double fKp = (Double)activityMap.get("kwota_do_zwrotu_do_kasy_kp");
        double fKw = (Double)activityMap.get("kwota_do_wyplaty_z_kasy_kw");
        return Functions.getWyplataZKasyWal(fKp, fKw);
    }

    public static double getWyplataZKasyWal(double fKp, double fKw) {
        double fKasa = 0.0;
        fKasa = fKw > 0.0 ? fKw * -1.0 : fKp;
        return fKasa;
    }

    public static String getLokalizacjaKasyDel(String sLokalizacjaKasy) {
        Object sListaOsob = "";
        if (sLokalizacjaKasy.compareToIgnoreCase("POTR\u00c4\u201eCENIE Z WYNAGRODZENIA") == 0) {
            Set<Object> setListaOsob = new HashSet();
            setListaOsob = OUData.getUsersForRole_Set("kasa_potracenia");
            for (String string : setListaOsob) {
                sListaOsob = (String)sListaOsob + string + ";";
            }
            if (((String)sListaOsob).length() > 0) {
                sListaOsob = ((String)sListaOsob).substring(0, ((String)sListaOsob).length() - 1);
            }
        } else {
            sLokalizacjaKasy = sLokalizacjaKasy.substring(sLokalizacjaKasy.length() - 5);
            HashSet<String> setListaOsob = new HashSet();
            setListaOsob = OUData.getUsersForRole_Set("kasa_delegacje");
            sListaOsob = Functions.getUsersListForLocalization(setListaOsob, sLokalizacjaKasy);
        }
        if (((String)sListaOsob).compareTo("") == 0) {
            log.info((Object)("B\u0139\u201a\u00c4\u2026d! Brak osob z lokalizacji " + sLokalizacjaKasy + " o danej roli "));
            sListaOsob = "admin";
        }
        return sListaOsob;
    }

    public static int changeMonthToInteger(String sMonth) {
        if (sMonth.compareToIgnoreCase("stycze\u0139\u201e") == 0) {
            return 1;
        }
        if (sMonth.compareToIgnoreCase("luty") == 0) {
            return 2;
        }
        if (sMonth.compareToIgnoreCase("marzec") == 0) {
            return 3;
        }
        if (sMonth.compareToIgnoreCase("kwiecie\u0139\u201e") == 0) {
            return 4;
        }
        if (sMonth.compareToIgnoreCase("maj") == 0) {
            return 5;
        }
        if (sMonth.compareToIgnoreCase("czerwiec") == 0) {
            return 6;
        }
        if (sMonth.compareToIgnoreCase("lipiec") == 0) {
            return 7;
        }
        if (sMonth.compareToIgnoreCase("sierpie\u0139\u201e") == 0) {
            return 8;
        }
        if (sMonth.compareToIgnoreCase("wrzesie\u0139\u201e") == 0) {
            return 9;
        }
        if (sMonth.compareToIgnoreCase("pa\u0139\u015fdziernik") == 0) {
            return 10;
        }
        if (sMonth.compareToIgnoreCase("listopad") == 0) {
            return 11;
        }
        if (sMonth.compareToIgnoreCase("grudzie\u0139\u201e") == 0) {
            return 12;
        }
        return 0;
    }

    public static String changeMonthToSring(int iMonth) {
        switch (iMonth) {
            case 1: {
                return "stycze\u0139\u201e";
            }
            case 2: {
                return "luty";
            }
            case 3: {
                return "marzec";
            }
            case 4: {
                return "kwiecie\u0139\u201e";
            }
            case 5: {
                return "maj";
            }
            case 6: {
                return "czerwiec";
            }
            case 7: {
                return "lipiec";
            }
            case 8: {
                return "sierpie\u0139\u201e";
            }
            case 9: {
                return "wrzesie\u0139\u201e";
            }
            case 10: {
                return "pa\u0139\u015fdziernik";
            }
            case 11: {
                return "listopad";
            }
            case 12: {
                return "grudzie\u0139\u201e";
            }
        }
        return "stycze\u0139\u201e";
    }

    public static Date chandeStringToSqlDate(String sDate) {
        java.util.Date utilDate = Functions.convertStringToDate(sDate, "yyyy-MM-dd");
        Date sqlDate = new Date(utilDate.getTime());
        return sqlDate;
    }

    public static String changeIntToStringWithZero(int iVal) {
        Object sResult = "";
        if (iVal < 10) {
            sResult = (String)sResult + "0";
        }
        sResult = (String)sResult + String.valueOf(iVal);
        return sResult;
    }

    public static void addCommentToActivity(String sProcessId, String sActivityId, String msg) {
        try {
            log.trace((Object)"************************* addCommentToActivity() ********************");
            java.util.Date dDate = new java.util.Date();
            Long lTime = dDate.getTime();
            CommentService cs = ServiceFactory.getCommentService();
            Comment comment = new Comment();
            comment.setActivityId(sActivityId);
            comment.setProcessId(sProcessId);
            comment.setTimestamp(lTime);
            comment.setUserId("admin");
            comment.setComment(msg);
            cs.createComment(comment);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static String changeDoubleFormat(String sIn) {
        if (StringUtils.isNotBlank((CharSequence)sIn)) {
            DecimalFormat twoDForm = new DecimalFormat("# ###.##;-# ###.##");
            twoDForm.setMinimumFractionDigits(2);
            twoDForm.setGroupingUsed(true);
            twoDForm.setGroupingSize(3);
            DecimalFormatSymbols symbols = twoDForm.getDecimalFormatSymbols();
            symbols.setGroupingSeparator(' ');
            symbols.setDecimalSeparator('.');
            twoDForm.setDecimalFormatSymbols(symbols);
            String[] sAmount = ((String)sIn).split(";");
            sIn = "";
            for (String amount : sAmount) {
                double tmp;
                if (amount.compareToIgnoreCase("") != 0) {
                    tmp = Double.valueOf(amount);
                    tmp = MathFunctions.round((double)tmp, (int)2);
                    sIn = (String)sIn + twoDForm.format(tmp) + ";";
                    continue;
                }
                tmp = 0.0;
                sIn = (String)sIn + twoDForm.format(tmp) + ";";
            }
            sIn = ((String)sIn).substring(0, ((String)sIn).length() - 1);
        }
        return sIn;
    }

    public static String getValueFromTable(String[] tTable, int index) {
        String sResult = "";
        if (tTable.length > 0 && index < tTable.length) {
            sResult = tTable[index];
        }
        return sResult;
    }

    public static String setTableNum(String sTable) {
        Object sNum = "";
        String[] fTable = sTable.split(";");
        int iSize = fTable.length;
        for (int i = 1; i <= iSize; ++i) {
            sNum = (String)sNum + i + ";";
        }
        sNum = Functions.cutLastChar((String)sNum);
        return sNum;
    }

    public static String cutLastChar(String sIn) {
        if (sIn.length() > 0) {
            sIn = sIn.substring(0, sIn.length() - 1);
        }
        return sIn;
    }

    public static String getDelOracleVatCode(String vat) {
        String sQuery = "select distinct value oracleCode from pm_custom_vat_delegacje where kod_vat = '" + vat + "'";
        String sOrcleCode = "";
        List<Map<String, String>> results = FSTools.executeInternalQuery(sQuery);
        if (results != null && results.size() > 0) {
            sOrcleCode = results.get(0).get("oraclecode");
        }
        return sOrcleCode;
    }
}

