/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.util.Integrations;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class InternalDataBase {
    public static Logger log = Logger.getLogger(InternalDataBase.class);

    public static Connection connect() throws NamingException, SQLException {
        try {
            Connection con = null;
            InitialContext initialContext = new InitialContext();
            DataSource dataSource = (DataSource)initialContext.lookup("java:comp/env/PlusWorkflowResource");
            con = dataSource.getConnection();
            return con;
        }
        catch (NamingException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
    }

    public static void distconnect(Connection con) throws SQLException {
        if (con != null && !con.isClosed()) {
            con.close();
        }
    }

    public static ArrayList<HashMap<String, String>> executeQuery(Connection con, String query) throws Exception {
        ArrayList<HashMap<String, String>> results = null;
        ResultSet rset = null;
        try (Statement stmt = null;){
            results = new ArrayList<HashMap<String, String>>();
            Date dtStart = new Date();
            log.debug((Object)("Wykonanie zapytania   :" + query));
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData.supportsTransactionIsolationLevel(1)) {
                con.setTransactionIsolation(1);
            }
            stmt = con.createStatement();
            rset = stmt.executeQuery(query);
            ResultSetMetaData rsmd = rset.getMetaData();
            int numColumns = rsmd.getColumnCount();
            while (rset.next()) {
                HashMap<String, String> oneRow = new HashMap<String, String>();
                for (int i = 1; i < numColumns + 1; ++i) {
                    String columnName = rsmd.getColumnName(i);
                    String value = rset.getString(columnName);
                    if (value == null) {
                        value = "";
                    }
                    oneRow.put(columnName, value);
                }
                results.add(oneRow);
            }
            log.debug((Object)("Ilosc zwroconych wynikow : " + results.size()));
            Date dtEnd = new Date();
            log.debug((Object)("Przyblizony czas wykonania zapytania : " + (dtEnd.getTime() - dtStart.getTime())));
            ArrayList<HashMap<String, String>> arrayList = results;
            return arrayList;
        }
    }

    public static HashMap<String, String> executeOneResultQuery(Connection con, String query) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        ResultSet rset = null;
        try (Statement stmt = null;){
            result = new HashMap();
            Date dtStart = new Date();
            log.debug((Object)("Wykonanie zapytania   :" + query));
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData.supportsTransactionIsolationLevel(1)) {
                con.setTransactionIsolation(1);
            }
            stmt = con.createStatement();
            rset = stmt.executeQuery(query);
            ResultSetMetaData rsmd = rset.getMetaData();
            int numColumns = rsmd.getColumnCount();
            while (rset.next()) {
                for (int i = 1; i < numColumns + 1; ++i) {
                    String columnName = rsmd.getColumnName(i);
                    String value = rset.getString(columnName);
                    if (value == null) {
                        value = "";
                    }
                    result.put(columnName, value);
                }
                if (result == null || result.isEmpty()) continue;
            }
            Date dtEnd = new Date();
            log.debug((Object)("Przyblizony czas wykonania zapytania : " + (dtEnd.getTime() - dtStart.getTime())));
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
    }

    public static void executeNoResultQuery(Connection con, String query) throws Exception {
        try (Statement stmt = null;){
            Date dtStart = new Date();
            log.debug((Object)("Wykonanie zapytania   :" + query));
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData.supportsTransactionIsolationLevel(1)) {
                con.setTransactionIsolation(1);
            }
            stmt = con.createStatement();
            stmt.executeUpdate(query);
            Date dtEnd = new Date();
            log.debug((Object)("Przyblizony czas wykonania zapytania : " + (dtEnd.getTime() - dtStart.getTime())));
        }
    }
}

