/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.ckd;

import com.plusmpm.util.extension.P0015.ckd.integrations.ws.IPAO_WServices;
import com.plusmpm.util.extension.P0015.ckd_pw.data.ReturnTable;
import com.plusmpm.util.extension.P0015.ckd_pw.data.dao.ReturnTableDao;
import com.suncode.plugin.lm.DirectDB.copyInitData.Sklepy;
import com.suncode.plugin.lm.DirectDB.copyInitData.dao.SklepyDao;
import com.suncode.plugin.lm.util.extension.P0015.ckd_pw.PWTools;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pw_check_rec"})
public class PWCheckRec {
    public static Logger log = Logger.getLogger(PWCheckRec.class);
    public static SQLFinder finder = FinderFactory.getSQLFinder();
    @Autowired
    private ReturnTableDao returnTableDao;
    @Autowired
    private SklepyDao sklepyDao;
    @Autowired
    private PWTools pwToolsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/get_data"}, method={RequestMethod.POST})
    @ResponseBody
    public synchronized Map<String, Object> getPwCheckRec(@RequestParam(value="processid") String sProcessId, @RequestParam(value="activityid") String sActivityid, @RequestParam(value="sklep") String sSklep, @RequestParam(value="nr_bonu") String sNrBonu, @RequestParam(value="nr_odbioru") String sNrOdbioru, @RequestParam(value="user") String sUser) {
        HashMap<String, Object> data;
        block36: {
            log.trace((Object)"** CKD ** PWCheckRec ");
            boolean bSuccess = true;
            Object answerMessage = "ok";
            int iStatus = 0;
            boolean reopen = false;
            data = new HashMap<String, Object>();
            try {
                log.info((Object)("** CKD ** PWCheckRec process " + sProcessId + ", sklep " + sSklep + ", nr_bonu " + sNrBonu + ", nr_bonu " + sNrOdbioru));
                if (sSklep == null || sSklep.isEmpty()) {
                    throw new Exception("Brak numeru sklepu");
                }
                if ((sNrBonu == null || sNrBonu.isEmpty()) && (sNrOdbioru == null || sNrOdbioru.isEmpty())) {
                    throw new Exception("Nie podano nr bonu i nr odbioru");
                }
                String sSymbol = sSklep.split(" - ")[0];
                Sklepy shop = this.sklepyDao.getSklepBySymbol(sSymbol);
                int store_no = Integer.valueOf(shop.getCkd());
                ReturnTable doss = null;
                if (sNrBonu != null && !sNrBonu.isEmpty()) {
                    log.debug((Object)("** CKD ** PWCheckRec sprawdzanie po nr bonu " + sNrBonu));
                    doss = this.returnTableDao.getIfExistsByNrBonuAndSklep(sNrBonu, store_no);
                } else if (sNrOdbioru != null && !sNrOdbioru.isEmpty()) {
                    log.debug((Object)("** CKD ** PWCheckRec sprawdzanie po nr odbioru " + sNrOdbioru));
                    doss = this.returnTableDao.getIfExistsByNrOdbioruAndSklep(sNrOdbioru, store_no);
                } else {
                    throw new Exception("Jeden z indeks\u00f3w nr bonu b\u0105d\u017a nr odbioru musi by\u0107 podany");
                }
                if (doss == null) {
                    log.debug((Object)"** CKD ** PWCheckRec brak dossier w SOD integracja z BO");
                    if (sNrBonu == null || sNrBonu.isEmpty()) {
                        throw new Exception("Brak zwrotu w SOD, prosz\u0119 poda\u0107 nr bonu/zam\u00f3wienia w celu pobrania danych z BO.");
                    }
                    JSONObject dossierJSON = IPAO_WServices.get_rec(store_no, sNrBonu);
                    if (dossierJSON != null) {
                        log.info((Object)("** CKD ** PWCheckRec dossier istnieje w BO " + dossierJSON.getString("status")));
                        iStatus = 2;
                        answerMessage = "Czy chcesz zarejestrowa\u0107 nowe dossier?";
                    } else {
                        log.info((Object)"** CKD ** PWCheckRec brak dossier w BO");
                        iStatus = 0;
                        answerMessage = "Wprowadzono b\u0142\u0119dne dane. Zweryfikuj ich poprawno\u015b\u0107.";
                    }
                } else {
                    log.info((Object)("** CKD ** PWCheckRec odnaleziono dossier w SOD, sprawdzam czy jest uruchomione: " + doss.isSod_open()));
                    if (doss.isSod_open()) {
                        answerMessage = "Dossier aktualnie przetwarzane w innym procesie.";
                    } else {
                        String Original_processid = doss.getOriginal_processid();
                        ProcessService processService = ServiceFactory.getProcessService();
                        Map ContextMap = processService.getProcessContext(Original_processid);
                        String nr_faktury = (String)ContextMap.get("nr_faktury");
                        log.info((Object)("** CKD ** PWCheckRec Nr faktury: " + nr_faktury));
                        SQLBuilder builder = new SQLBuilder();
                        builder.setQuery("SELECT * FROM pm_cast_send_to_oracle WHERE document_id= :textcol_documentId and category='WFPW' ");
                        builder.setParameter("textcol_documentId", (Object)nr_faktury);
                        List dane = finder.find(builder);
                        if (dane.size() > 0) {
                            answerMessage = "Zablokowana mo\u017cliwo\u015bci ponownego otwarcia procesu - faktura oczekuje na eksport do Oracle.";
                        } else {
                            reopen = true;
                            log.info((Object)("** CKD ** PWCheckRec statusu dossier: " + doss.getStatus_dossier() + " faktura do anulacji: " + doss.isFaktura_do_anulacji()));
                            if (doss.getStatus_dossier().compareToIgnoreCase(PWTools._closed_fv) == 0) {
                                boolean has_role = PWTools.hasUserRole("ckd_ksiegowa_s%", sUser, sSklep);
                                log.info((Object)("** CKD ** PWCheckRec uzytkownik ma role ckd_ksiegowa_s: " + has_role));
                                if (doss.isFaktura_do_anulacji()) {
                                    if (has_role) {
                                        iStatus = 2;
                                        answerMessage = "Mo\u017cliwe jest jedynie anulowanie wystawionej faktury. Czy chcesz kontynuowa\u0107?";
                                    } else {
                                        answerMessage = "Brak uprawnie\u0144 do anulacji faktury";
                                    }
                                } else if (has_role) {
                                    iStatus = 2;
                                    answerMessage = "Faktura zosta\u0142a anulowana czy chcesz kontynuowa\u0107?";
                                } else {
                                    answerMessage = "Brak uprawnie\u0144 do aktualizacji dossier po anulowaniu faktury";
                                }
                            } else if (doss.getStatus_dossier().compareToIgnoreCase(PWTools._closed_ls) == 0) {
                                boolean has_role = PWTools.hasUserRole("ckd_ksiegowa_s%", sUser, sSklep);
                                log.info((Object)("** CKD ** PWCheckRec uzytkownik ma role ckd_ksiegowa_s: " + has_role));
                                if (has_role) {
                                    iStatus = 2;
                                    answerMessage = "Dla dossier wys\u0142ano LS. Czy chcesz kontynuowa\u0107? ";
                                } else {
                                    answerMessage = "Wystawiono LS, brak uprawnie\u0144 do aktualizacji";
                                }
                            } else if (doss.getStatus_dossier().compareToIgnoreCase(PWTools._closed) == 0) {
                                boolean has_role = PWTools.hasUserRole("ckd_ksiegowa_s%", sUser, sSklep);
                                log.info((Object)("** CKD ** PWCheckRec uzytkownik ma role ckd_ksiegowa_s: " + has_role));
                                if (has_role) {
                                    iStatus = 2;
                                    answerMessage = "Dossier ma status Zamkniete czy chcesz kontynuowa\u0107?";
                                } else {
                                    answerMessage = "Brak uprawnie\u0144 do wywo\u0142ania dossier";
                                }
                            } else {
                                iStatus = 1;
                                answerMessage = "ok";
                            }
                        }
                    }
                }
                data.put("success", bSuccess);
            }
            catch (Exception e) {
                log.error((Object)("** CKD ** Blad pobierania danych dossier w procesie " + sProcessId + " :" + e.getMessage()), (Throwable)e);
                answerMessage = "Nie mo\u017cna pobra\u0107 danych dla wskazanego nr, komunikat: " + e.getMessage();
                bSuccess = false;
                break block36;
            }
            finally {
                data.put("success", bSuccess);
                data.put("status", iStatus);
                data.put("message", answerMessage);
                data.put("reopen", reopen);
            }
            data.put("status", iStatus);
            data.put("message", answerMessage);
            data.put("reopen", reopen);
        }
        return data;
    }
}

