/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.ckd;

import com.plusmpm.util.extension.P0015.ckd.integrations.ws.IPAO_WServices;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/get_supplier_data"})
public class GetSupplierData {
    public static Logger log = Logger.getLogger(GetSupplierData.class);

    @RequestMapping(value={"/get_data"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getInfoVersionFormProcessDoc(@RequestParam(value="processid") String sProcessId, @RequestParam(value="store_no") String sStoreNo, @RequestParam(value="supplier_no") String sSupplierNo) {
        log.trace((Object)"** CKD ** GetSupplierData ");
        boolean bSuccess = false;
        String answerMessage = "";
        JSONObject jsonResult = null;
        Map<String, Object> data = new HashMap<String, Object>();
        try {
            log.trace((Object)("** CKD ** GetSupplierData process " + sProcessId + ", shop " + sStoreNo + ", supplier " + sSupplierNo));
            if (sStoreNo == null || sStoreNo.isEmpty()) {
                throw new Exception("Brak numeru sklepu");
            }
            if (sSupplierNo == null || sSupplierNo.isEmpty()) {
                throw new Exception("Brak numeru IPAO dostawcy");
            }
            int store_no = Integer.valueOf(sStoreNo);
            int supplier_no = Integer.valueOf(sSupplierNo);
            jsonResult = IPAO_WServices.getSuppilerData(store_no, supplier_no);
            bSuccess = true;
            answerMessage = "ok";
            data = GetSupplierData.toMap(jsonResult);
            data.put("success", bSuccess);
            data.put("message", answerMessage);
        }
        catch (Exception e) {
            log.error((Object)("** CKD ** Blad pobierania danych dostawcy w procesie " + sProcessId + " :" + e.getMessage()), (Throwable)e);
            answerMessage = e.getMessage();
            bSuccess = false;
            data.put("success", bSuccess);
            data.put("message", answerMessage);
        }
        return data;
    }

    private static Map<String, Object> toMap(JSONObject jsonobj) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = jsonobj.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            List<Object> value = jsonobj.get(key);
            if (value instanceof JSONArray) {
                value = GetSupplierData.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = GetSupplierData.toMap((JSONObject)value);
            }
            if (jsonobj.isNull(key)) {
                value = "";
            }
            map.put(key, value);
        }
        return map;
    }

    private static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = GetSupplierData.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = GetSupplierData.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }
}

