/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.ckd;

import com.plusmpm.util.extension.P0015.Functions;
import com.plusmpm.util.extension.P0015.ckd.integrations.DossierTranslator;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.Dossier;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierdata.DossierRec;
import com.plusmpm.util.extension.P0015.ckd.integrations.dossierlist.DossierKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/check_correct"})
public class CheckCorrect {
    public static Logger log = Logger.getLogger(CheckCorrect.class);

    @RequestMapping(value={"/get_data"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getCheckCorrect(@RequestParam(value="processid") String sProcessId, @RequestParam(value="store_no") String sStoreNo, @RequestParam(value="dossier") String sDossier, @RequestParam(value="ipao_date") String sIpaoDate, @RequestParam(value="sum_walo") String sSumaWalo) {
        log.trace((Object)"** CKD ** CheckCorrect ");
        boolean bSuccess = false;
        Object answerMessage = "ok";
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            log.trace((Object)("** CKD ** CheckCorrect process " + sProcessId + ", shop " + sStoreNo + ", dossier " + sDossier));
            if (sStoreNo == null || sStoreNo.isEmpty()) {
                throw new Exception("Brak numeru sklepu");
            }
            if (sDossier == null || sDossier.isEmpty()) {
                throw new Exception("Brak numeru dosssier");
            }
            int store_no = Integer.valueOf(sStoreNo);
            DossierKey key = new DossierKey(store_no, Long.valueOf(sDossier), Functions.convertStringToDate(sIpaoDate, "yyyy-MM-dd"));
            Dossier dossier = DossierTranslator.getAllDossierData(key);
            bSuccess = true;
            double sum_walo = Functions.changeStringToDouble(sSumaWalo);
            double tmp_sum = 0.0;
            Map<Long, DossierRec> rec_map = dossier.getRec();
            TreeSet<Long> key_set = new TreeSet<Long>(rec_map.keySet());
            Iterator iterator = key_set.iterator();
            while (iterator.hasNext()) {
                long key_tmp = (Long)iterator.next();
                DossierRec rec = rec_map.get(key_tmp);
                tmp_sum += rec.getKwota_zwalo();
            }
            if (sum_walo != (tmp_sum = Functions.RoundValue(tmp_sum, 2))) {
                answerMessage = "Suma waloryzacji po korekcie " + sum_walo + " jest niezgodna z sum\u0105 waloryzacji w BO " + tmp_sum + ".";
            }
        }
        catch (Exception e) {
            log.error((Object)("** CKD ** Blad pobierania danych dossier w procesie " + sProcessId + " :" + e.getMessage()), (Throwable)e);
            answerMessage = e.getMessage();
            bSuccess = false;
        }
        data.put("success", bSuccess);
        data.put("message", answerMessage);
        return data;
    }
}

