/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.DirectDB.lists;

import com.plusmpm.CUF.util.extension.ExcelReader;
import com.plusmpm.DirectDB.lists.ListConf;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.util.Integrations.InternalDataBase;
import com.suncode.plugin.lm.util.extension.P0015.getDataMethods.ReadData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class ListConfManager {
    public static Logger log = Logger.getLogger(ListConfManager.class);

    private static String[] getCreateIndicesTableQueries(String tableName, String[] columnNames, String[] columnTypes) throws IllegalArgumentException {
        log.trace((Object)"************************* getCreateIndicesTableQueries(String, String[], String[]) ********************");
        if (columnNames.length != columnTypes.length) {
            throw new IllegalArgumentException("Rozmiar tablicy z nazwami kolumn jest inny ni\u017c rozmiar tablicy z typami.");
        }
        String[] result = new String[2];
        StringBuilder sequenceCreateQuery = new StringBuilder("CREATE SEQUENCE ");
        sequenceCreateQuery.append(tableName);
        sequenceCreateQuery.append("_id_seq");
        result[0] = sequenceCreateQuery.toString();
        StringBuilder tableCreateQuery = new StringBuilder();
        tableCreateQuery.append("CREATE TABLE ");
        tableCreateQuery.append(tableName);
        tableCreateQuery.append(" (id int8 DEFAULT nextval('");
        tableCreateQuery.append(tableName);
        tableCreateQuery.append("_id_seq') PRIMARY KEY");
        for (int i = 0; i < columnNames.length; ++i) {
            tableCreateQuery.append(", ");
            tableCreateQuery.append(columnNames[i]);
            if (columnTypes[i].equals("integer") || columnTypes[i].equals("int8")) {
                tableCreateQuery.append(" int8");
                continue;
            }
            if (columnTypes[i].equals("float") || columnTypes[i].equals("float8")) {
                tableCreateQuery.append(" float8");
                continue;
            }
            if (columnTypes[i].equals("double") || columnTypes[i].equals("double8")) {
                tableCreateQuery.append(" double8");
                continue;
            }
            if (columnTypes[i].equals("timestamp")) {
                tableCreateQuery.append(" timestamp");
                continue;
            }
            tableCreateQuery.append(" varchar(200)");
        }
        tableCreateQuery.append(", criteria varchar(1024), dateofrecordcheck timestamp, connectionname varchar(1024))");
        result[1] = tableCreateQuery.toString();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long addResults(Connection con, List<Map<String, String>> newResults, String[] columnNames, String[] columnTypes, String sTableName, String sCriteria, String connectionName) throws SQLException {
        log.trace((Object)"************************* addResults(Connection, ArrayList<HashMap<String, String>>, String[], String[], String, String, String) ********************");
        Statement statement = null;
        ArrayList<HashMap<String, String>> oldResults = null;
        Date date = new Date();
        long time = date.getTime();
        try {
            int i;
            log.debug((Object)"Dodawanie i uaktualnianie rekordow");
            StringBuilder insertQuery = new StringBuilder();
            insertQuery.append("INSERT INTO ");
            insertQuery.append(sTableName);
            insertQuery.append(" (");
            for (i = 0; i < newResults.get(0).size() + 1; ++i) {
                if (i != newResults.get(0).size()) {
                    insertQuery.append(columnNames[i] + ", ");
                    continue;
                }
                insertQuery.append("criteria, dateofrecordcheck, connectionname)");
            }
            insertQuery.append(" VALUES (");
            for (i = 0; i < newResults.get(0).size() + 1; ++i) {
                if (i != newResults.get(0).size()) {
                    insertQuery.append("?, ");
                    continue;
                }
                insertQuery.append("?, ?, ?)");
            }
            String sqlInsert = insertQuery.toString();
            log.debug((Object)("INSERT query: " + sqlInsert));
            StringBuilder updateQuery = new StringBuilder();
            updateQuery.append("UPDATE ");
            updateQuery.append(sTableName);
            updateQuery.append(" SET ");
            for (int i2 = 0; i2 < newResults.get(0).size() + 1; ++i2) {
                if (i2 != newResults.get(0).size()) {
                    updateQuery.append(columnNames[i2] + "=?, ");
                    continue;
                }
                updateQuery.append("criteria=?, dateofrecordcheck=?, connectionname=?");
            }
            updateQuery.append(" WHERE ");
            String[] criteriaSplit = sCriteria.split(";");
            for (int i3 = 0; i3 < criteriaSplit.length; ++i3) {
                updateQuery.append(criteriaSplit[i3]);
                if (i3 != criteriaSplit.length - 1) {
                    updateQuery.append("=? AND ");
                    continue;
                }
                updateQuery.append("=?");
            }
            String sqlUpdate = updateQuery.toString();
            log.debug((Object)("UPDATE query: " + sqlUpdate));
            String oldQuery = "SELECT * FROM " + sTableName;
            oldResults = InternalDataBase.executeQuery(con, oldQuery);
            statement = con.prepareStatement(sqlInsert);
            for (int i4 = 0; i4 < newResults.size(); ++i4) {
                int recordExists = 0;
                int range = newResults.get(i4).size() + 1;
                if (oldResults != null && oldResults.size() > 0) {
                    for (int k = 0; k < oldResults.size(); ++k) {
                        recordExists = 0;
                        for (int w = 0; w < criteriaSplit.length; ++w) {
                            if (!oldResults.get(k).get(criteriaSplit[w]).equals(newResults.get(i4).get(criteriaSplit[w]))) continue;
                            ++recordExists;
                        }
                        if (recordExists == criteriaSplit.length) break;
                    }
                    statement = recordExists == criteriaSplit.length ? con.prepareStatement(sqlUpdate) : con.prepareStatement(sqlInsert);
                }
                for (int j = 0; j < range; ++j) {
                    if (j < newResults.get(i4).size()) {
                        if (columnTypes[j].equals("integer") || columnTypes[j].equals("int8")) {
                            statement.setInt(j + 1, Integer.valueOf(newResults.get(i4).get(columnNames[j])));
                            continue;
                        }
                        if (columnTypes[j].equals("float") || columnTypes[j].equals("float8")) {
                            statement.setFloat(j + 1, Float.valueOf(newResults.get(i4).get(columnNames[j])).floatValue());
                            continue;
                        }
                        if (columnTypes[j].equals("double") || columnTypes[j].equals("double8")) {
                            statement.setDouble(j + 1, Double.valueOf(newResults.get(i4).get(columnNames[j])));
                            continue;
                        }
                        if (columnTypes[j].equals("timestamp")) {
                            statement.setTimestamp(j + 1, Timestamp.valueOf(newResults.get(i4).get(columnNames[j])));
                            continue;
                        }
                        statement.setString(j + 1, newResults.get(i4).get(columnNames[j]));
                        continue;
                    }
                    statement.setString(j + 1, sCriteria);
                    statement.setTimestamp(j + 2, new Timestamp(time));
                    statement.setString(j + 3, connectionName);
                    if (recordExists != criteriaSplit.length) continue;
                    for (int z = 0; z < criteriaSplit.length; ++z) {
                        String criteriaType = "";
                        for (int e = 0; e < columnNames.length; ++e) {
                            if (!criteriaSplit[z].equals(columnNames[e])) continue;
                            criteriaType = columnTypes[e];
                            break;
                        }
                        if (criteriaType.equals("integer") || criteriaType.equals("int8")) {
                            statement.setInt(j + 4 + z, Integer.valueOf(newResults.get(i4).get(criteriaSplit[z])));
                            continue;
                        }
                        if (criteriaType.equals("float") || criteriaType.equals("float8")) {
                            statement.setFloat(j + 4 + z, Float.valueOf(newResults.get(i4).get(criteriaSplit[z])).floatValue());
                            continue;
                        }
                        if (criteriaType.equals("double") || criteriaType.equals("double8")) {
                            statement.setDouble(j + 4 + z, Double.valueOf(newResults.get(i4).get(criteriaSplit[z])));
                            continue;
                        }
                        if (criteriaType.equals("timestamp")) {
                            statement.setTimestamp(j + 4 + z, Timestamp.valueOf(newResults.get(i4).get(criteriaSplit[z])));
                            continue;
                        }
                        statement.setString(j + 4 + z, newResults.get(i4).get(criteriaSplit[z]));
                    }
                }
                statement.execute();
                statement.clearParameters();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            long l = -1L;
            return l;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean deleteResults(Connection con, String sTableName, String connectionName, Long time) {
        log.trace((Object)"************************* deleteResults(Connection, String, String, Long) ********************");
        boolean state = false;
        Statement statement = null;
        try {
            Timestamp timestamp = new Timestamp(time);
            StringBuilder deleteQuery = new StringBuilder();
            deleteQuery.append("DELETE FROM ");
            deleteQuery.append(sTableName);
            deleteQuery.append(" WHERE dateofrecordcheck<? AND connectionname=?");
            String sqlDelete = deleteQuery.toString();
            log.debug((Object)sqlDelete);
            statement = con.prepareStatement(sqlDelete);
            statement.setTimestamp(1, timestamp);
            statement.setString(2, connectionName);
            statement.execute();
            state = true;
        }
        catch (Exception e) {
            state = false;
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return state;
    }

    public static ListConf getListConfByName(String sName) {
        ListConf result = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            result = (ListConf)session.createQuery("from ListConf where listName=:name").setParameter("name", (Object)sName).uniqueResult();
            transaction.commit();
            ListConf listConf = result;
            return listConf;
        }
        catch (HibernateException e) {
            try {
                if (transaction != null && session.isOpen()) {
                    transaction.rollback();
                }
            }
            catch (HibernateException he1) {
                log.error((Object)he1.getMessage());
            }
            throw e;
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    private static List<Map<String, String>> getDataFromXlsx(File file, ListConf oList) {
        log.trace((Object)"******************* getDataFromXlsx - pobieranie danych z pliku xlsx ******************* ");
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        List resultsObj = new ArrayList();
        String[] columnNames = oList.getColumnsTab();
        try {
            ExcelReader er = new ExcelReader();
            resultsObj = er.readExcel(file.getAbsolutePath());
            for (int i = 1; i < resultsObj.size(); ++i) {
                try {
                    Map singleRowObj = (Map)resultsObj.get(i);
                    HashMap<String, String> singleRow = new HashMap<String, String>();
                    for (String key : columnNames) {
                        if (!singleRowObj.containsKey(key)) continue;
                        if (singleRowObj.get(key) == null) {
                            singleRow.put(key, "");
                            continue;
                        }
                        singleRow.put(key, singleRowObj.get(key).toString());
                    }
                    results.add(singleRow);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)String.valueOf(e));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return results;
    }

    private static List<Map<String, String>> getDataFromTxt(File file, ListConf oList, String sSeparator, boolean header, String sCoding) {
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        if (StringUtils.isEmpty((CharSequence)sCoding)) {
            sCoding = "UTF-8";
        }
        int iLineNr = 0;
        int headerRow = 0;
        if (header) {
            headerRow = 1;
        }
        int coulumnCount = oList.getColumnsCount();
        String[] columnNames = oList.getColumnsTab();
        try {
            String sLine;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), sCoding));
            while ((sLine = in.readLine()) != null) {
                if (++iLineNr <= headerRow) continue;
                String[] tempTab = null;
                tempTab = ReadData.readLineFromFile(sLine, sSeparator, coulumnCount);
                HashMap<String, String> singleRow = new HashMap<String, String>();
                for (int i = 0; i < coulumnCount; ++i) {
                    singleRow.put(columnNames[i], tempTab[i]);
                }
                results.add(singleRow);
            }
            in.close();
        }
        catch (IOException exc) {
            log.error((Object)exc.getMessage());
        }
        return results;
    }
}

