JDBC = {
    t: PW.I18N.createT('com.suncode.plugin-jdbc-datasources')
};

PW.DataSources.register('jdbcQueryDatasource', {
    buildParams: function( form ) {
        var row = form.addRow();
        row.addCombobox({
            id: 'connection',
            valueField: 'id',
            displayField: 'name',
            queryCaching: false,
            remote: {
                url: PW.getAbsolutePath('/plugin/com.suncode.plugin-jdbc-datasources/connections' ),
                fields: ['id', 'name'],
                remoteSort: true
            },
            sort: [{
                property: 'name',
                direction: 'ASC'
            }]
        });
        row.addButton({
            text: JDBC.t('jdbcDatasource.createConnectionButton'),
            handler: function() {
                showNewConnectionWindow( row, false );
            },
            id: 'newConnectionButton'
        });
        row.addButton({
            text: JDBC.t('jdbcDatasource.modifyConnectionsButton'),
            handler: function() {
                showNewConnectionWindow( row, true );
            },
            id: 'modifyConnectionButton'
        });
        row.addButton({
            text: JDBC.t('jdbcDatasource.testConnectionButton'),
            handler: function() {
                testConnection( row.getValue('connection'), form );
            },
            id: 'testButton'
        });
        form.addTextArea('query');
        form.addTextArea('countQuery');
        
        var inputParametersTable = form.addTable({
            name: JDBC.t('jdbcDatasource.inputParametersTable')
        });
        inputParametersTable.addField('queryParametersId');
        inputParametersTable.addField('queryParametersName');
        inputParametersTable.addCombobox({
            id: 'queryParametersType',
            values : [
                {id : 'string', display : JDBC.t('string')},
                {id : 'integer', display : JDBC.t('integer')},
                {id : 'float', display : JDBC.t('float')},
                {id : 'double', display : JDBC.t('double')},
                {id : 'date', display : JDBC.t('date')},
                {id : 'timestamp', display : JDBC.t('timestamp')}
            ]
        });
        
        var outputParametersTable = form.addTable({
            name: JDBC.t('jdbcDatasource.outputParametersTable')
        });
        outputParametersTable.addField('queryResultColumnsId');
        outputParametersTable.addField('queryResultColumnsName');
    }
});

PW.DataSources.register('jdbcUpdateDatasource', {
	buildParams: function( form ) {
		handleUpdateAndWriteBuildParams(form);
	}
});

PW.DataSources.register('jdbcWriteDatasource', {
    buildParams: function( form ) {
		handleUpdateAndWriteBuildParams(form);
	}
});

function handleUpdateAndWriteBuildParams( form ) {
	var row = form.addRow();
        row.addCombobox({
            id: 'connection',
            valueField: 'id',
            displayField: 'name',
            queryCaching: false,
            remote: {
                url: PW.getAbsolutePath('/plugin/com.suncode.plugin-jdbc-datasources/connections' ),
                fields: ['id', 'name'],
                remoteSort: true
            },
            sort: [{
                property: 'name',
                direction: 'ASC'
            }]
        });
        row.addButton({
            text: JDBC.t('jdbcDatasource.createConnectionButton'),
            handler: function() {
                showNewConnectionWindow( row, false );
            },
            id: 'newConnectionButton'
        });
        row.addButton({
            text: JDBC.t('jdbcDatasource.modifyConnectionsButton'),
            handler: function() {
                showNewConnectionWindow( row, true );
            },
            id: 'modifyConnectionButton'
        });
        row.addButton({
            text: JDBC.t('jdbcDatasource.testConnectionButton'),
            handler: function() {
                testConnection( row.getValue('connection'), form );
            },
            id: 'testButton'
        });
        form.addTextArea('query');
        
        var inputParametersTable = form.addTable({
            name: JDBC.t('jdbcDatasource.inputParametersTable')
        });
        inputParametersTable.addField('queryParametersId');
        inputParametersTable.addField('queryParametersName');
        inputParametersTable.addCombobox({
            id: 'queryParametersType',
            values : [
                {id : 'string', display : JDBC.t('string')},
                {id : 'integer', display : JDBC.t('integer')},
                {id : 'float', display : JDBC.t('float')},
                {id : 'double', display : JDBC.t('double')},
                {id : 'date', display : JDBC.t('date')},
                {id : 'timestamp', display : JDBC.t('timestamp')}
            ]
        });
}

function showNewConnectionWindow( row, modify ) {
    Ext4.create('Ext4.window.Window', {
        title: JDBC.t('jdbcDatasource.createConnectionWindowTitle'),
        width: modify ? 750 : 500,
        modal: true,
        frame: false,
        layout: 'fit',
        autoShow: true,
        
        items: [{
            xtype: 'form',
            layout: 'form',
            frame: false,
            border: false,
            bodyPadding: 10,
            defaults: {
                labelWidth: 150
            },
            items: [{
                xtype: 'combo',
                name: 'template',
                fieldLabel: JDBC.t('jdbcDatasource.template'),
                queryCaching: false,
                store: Ext4.create('Ext4.data.Store', {
                    fields: ['id', 'name', 'description', 'driverClassName', 'username', 'url', 'password'],
                    remoteSort: true,
                    pageSize: 20,
                    proxy: {
                        type: 'ajax',
                        url: PW.getAbsolutePath('/plugin/com.suncode.plugin-jdbc-datasources/connections' ),
                        reader: {
                             type: 'json',
                             root: 'data',
                             totalProperty: 'total'
                        }
                    },
                    sorters: [{
                        property: 'name',
                        direction: 'ASC'
                    }]
                }),
                pageSize: 20,
                minChars: 0,
                queryMode: 'remote',
                displayField: 'name',
                valueField: 'id',
                submitValue: false,
                padding: '0 0 10 0',
                listeners: {
                    select: function(combo, record) {
                        var form = combo.up('form').getForm();
                        if(!modify) {
                            record[0].data.id = '';
                            record[0].data.name = '';
                        }
                        form.setValues(record[0].data);
                    }
                }
            },{
                xtype: 'box',
                autoEl: 'div',
                height: 5
            },{
                xtype: 'textfield',
                name: 'id',
                fieldLabel: JDBC.t('jdbcDatasource.id'),
                allowBlank: false,
                hidden: modify
            },{
                xtype: 'textfield',
                name: 'name',
                fieldLabel: JDBC.t('jdbcDatasource.name'),
                allowBlank: false
            },{
                xtype: 'textfield',
                name: 'description',
                fieldLabel: JDBC.t('jdbcDatasource.description')
            },{
                xtype: 'form',
                layout: 'hbox',
                border: false,
                items: [{
                    xtype: 'textfield',
                    name: 'driverClassName',
                    fieldLabel: JDBC.t('jdbcDatasource.driverClassName'),
                    labelWidth: 150,
                    allowBlank: false,
                    flex: 1,
                    listeners: {
                        blur: function(field) {
                            var win = field.up('window');
                            win.checkDriver( field.getValue(), Ext4.getCmp('driverButton') );
                        }
                    }
                },{
                    xtype: 'button',
                    text: JDBC.t('jdbcDatasource.loadDriverButton'),
                    margin: '0 0 0 5',
                    padding: '4 3 3 3',
                    handler: function( button ) {
                        var win = button.up('window');
                        win.showUploadWindow();
                    },
                    id: 'driverButton',
                    hidden: true
                }]
            },{
                xtype: 'textfield',
                name: 'url',
                fieldLabel: JDBC.t('jdbcDatasource.url'),
                allowBlank: false
            },{
                xtype: 'textfield',
                name: 'username',
                fieldLabel: JDBC.t('jdbcDatasource.username')
            },{
                xtype: 'textfield',
                inputType: 'password',
                name: 'password',
                fieldLabel: JDBC.t('jdbcDatasource.password')
            }]
        }],
        
        buttons: [{
            text: JDBC.t('jdbcDatasource.createConnectionButton'),
            handler: function( button ) {
                var win = button.up('window');
                win.createOrModifyConnection(win, row);
            },
            hidden: modify
        },{
            text: JDBC.t('jdbcDatasource.modifyConnectionButton'),
            handler: function( button ) {
                var win = button.up('window'),
                    connectionId = win.down('[name=id]').getValue();
                
                win.createOrModifyConnection(win, row, connectionId);
            },
            hidden: !modify
        },{
            text: JDBC.t('jdbcDatasource.deleteConnectionButton'),
            handler: function( button ) {
                Ext4.MessageBox.confirm(JDBC.t('deleteConnectionTitle'), JDBC.t('deleteConnectionConfirm'), function(btn) {
                    if(btn === 'yes') {
                        var win = button.up('window'),
                        connectionId = win.down('[name=id]').getValue();
                        win.deleteConnection(win, row, connectionId);
                    }
                });
            },
            hidden: !modify
        },{
            text: JDBC.t('jdbcDatasource.testConnectionButton'),
            handler: function( button ) {
                var win = button.up('window');
                win.testConnection(win, row);
           }
        }, {
            text: PW.t('cancel'),
            handler: function( button ) {
                button.up('window').close();
            }
        }],

        createOrModifyConnection: function(win, row, connectionId){
            var url = '/plugin/com.suncode.plugin-jdbc-datasources/connections';
            if(connectionId) {
                url += '/' + connectionId;
            }
            var form = this.down('form');
            if( form.isValid() ) {
                form.mask();
                Ext4.Ajax.request({
                    url: PW.getAbsolutePath(url),
                    method: 'POST',
                    jsonData: Ext4.encode(form.getValues()),
                    failure: function(resp) {
                        PW.ui.Message.error(JDBC.t('jdbcDatasource.unknownException'));
                        form.unmask();
                    },
                    success: function(resp) {
                        var response = Ext4.decode(resp.responseText);
                        if(response.success) {
                            PW.ui.Message.success(response.message);
                            win.close();
                        }
                        else {
                            PW.ui.Message.error(response.message);
                            form.unmask();
                        }
                    }
                });
            }
        },
        deleteConnection: function(win, row, connectionId) {
            var url = '/plugin/com.suncode.plugin-jdbc-datasources/connections/' + connectionId;
            var form = this.down('form');
            if( form.isValid() ) {
                form.mask();
                Ext4.Ajax.request({
                    url: PW.getAbsolutePath(url),
                    method: 'DELETE',
                    failure: function(resp) {
                        PW.ui.Message.error(JDBC.t('jdbcDatasource.unknownException'));
                        form.unmask();
                    },
                    success: function(resp) {
                        var response = Ext4.decode(resp.responseText);
                        if(response.success) {
                            PW.ui.Message.success(response.message);
                            win.close();
                        }
                        else {
                            PW.ui.Message.error(response.message);
                            form.unmask();
                        }
                    }
                });
            }
        },
        testConnection: function(win) {
            var form = this.down('form');
            form.mask();
            Ext4.Ajax.request({
                url: PW.getAbsolutePath('/plugin/com.suncode.plugin-jdbc-datasources/connections/test' ),
                method: 'POST',
                jsonData: Ext4.encode(form.getValues()),
                failure: function(resp) {
                    PW.ui.Message.error(JDBC.t('jdbcDatasource.unknownException'));
                    form.unmask();
                },
                success: function(resp) {
                    var response = Ext4.decode(resp.responseText);
                    if(response.success) {
                        PW.ui.Message.success(response.message, response.success);
                    }
                    else {
                        PW.ui.Message.error(response.message, response.success);
                    }
                    form.unmask();
                }
            });
        },
        checkDriver: function( value, button ) {
            if(value) {
                Ext4.Ajax.request({
                    method: 'GET',
                    url: PW.getAbsolutePath('/plugin/com.suncode.plugin-jdbc-datasources/connections/driver/check/' + value ),
                    success: function(response) {
                        var result = Ext4.decode(response.responseText);
                        if(result.success) {
                            button.hide();
                        }
                        else {
                            PW.ui.Message.warning(JDBC.t('jdbcDatasource.driverNotExist'));
                            button.show();
                        }
                    },
                    failure: function() {
                        PW.ui.Message.warning(JDBC.t('jdbcDatasource.driverNotExist'));
                        button.show();
                    }
                });
            }
        },
        showUploadWindow: function( button ) {
            Ext4.create('Ext4.window.Window', {
                title: JDBC.t('jdbcDatasource.uploadDriverWindow.title'),
                width: 500,
                modal: true,
                frame: false,
                layout: 'fit',
                autoShow: true,
                
                items: [{
                    xtype: 'form',
                    layout: 'form',
                    frame: false,
                    border: false,
                    bodyPadding: 10,
                    defaults: {
                        labelWidth: 150
                    },
                    items: [{
                        xtype: 'filefield',
                        name: 'file',
                        regex: new RegExp('.jar$', 'i'),
                        fieldLabel: PW.t('fileNameText'),
                        buttonText: PW.t('choosefile'),
                        allowBlank: false,
                        // bez tego rozjezdza sie na IE forma
                        padding: '0px 1px 0px 0px'
                    }]
                }],
                
                buttons: [{
                    text: JDBC.t('jdbcDatasource.uploadDriverWindow.upload'),
                    handler: function( button ) {
                        var win = button.up('window');
                        win.onImportClick(win);
                    }
                }, {
                    text: PW.t('cancel'),
                    handler: function( button ) {
                        button.up('window').close();
                    }
                }],

                onImportClick: function(win){
                    var form = this.down('form');
                    if( form.isValid() ){
                        form.submit({
                            scope: this,
                            url: PW.getAbsolutePath('/plugin/com.suncode.plugin-jdbc-datasources/connections/driver/upload/' + row.getValue('driverClass') ),
                            waitMsg: PW.t('progressTitle'),
                            failure: function(form, action) {
                                var response = Ext4.decode( action.response.responseText );
                                PW.ui.Message.error( response.message );
                            },
                            success: function(form, action) {
                                var response = Ext4.decode( action.response.responseText );
                                PW.ui.Message.success( response.message );
                                win.close();
                                button.hide();
                            }
                        });
                    }
                }
            });
        }
    });
}

function testConnection( connectionId, form ) {
    if(connectionId) {
        form.mask();
        Ext4.Ajax.request({
            url: PW.getAbsolutePath('/plugin/com.suncode.plugin-jdbc-datasources/connections/' + connectionId + '/test' ),
            method: 'POST',
            failure: function(resp) {
                PW.ui.Message.error(JDBC.t('jdbcDatasource.unknownException'));
                form.unmask();
            },
            success: function(resp) {
                var response = Ext4.decode(resp.responseText);
                if(response.success) {
                    PW.ui.Message.success(response.message);
                }
                else {
                    PW.ui.Message.error(response.message);
                }
                form.unmask();
            }
        });
    }
}
