/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.jdbc.web.rest;

import com.suncode.plugin.datasource.jdbc.TranslatorWrapper;
import com.suncode.plugin.datasource.jdbc.component.enums.WayOfGenerateKeys;
import com.suncode.plugin.datasource.jdbc.connection.ConnectionWrapper;
import com.suncode.plugin.datasource.jdbc.connection.DataSourceConnectionFactory;
import com.suncode.plugin.datasource.jdbc.connection.DataSourceFactory;
import com.suncode.plugin.datasource.jdbc.connection.JdbcDriversLoader;
import com.suncode.plugin.datasource.jdbc.db.ConnectionConfiguration;
import com.suncode.plugin.datasource.jdbc.db.ConnectionService;
import com.suncode.plugin.datasource.jdbc.exception.InvalidDriverException;
import com.suncode.plugin.datasource.jdbc.web.connection.ConnectionConfigDto;
import com.suncode.plugin.datasource.jdbc.web.rest.SortDto;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"connections"})
public class JdbcConnectionController {
    private static final Logger log = LoggerFactory.getLogger(JdbcConnectionController.class);
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private JdbcDriversLoader driverLoader;
    @Autowired
    private DataSourceFactory dataSourceFactory;
    @Autowired
    private DataSourceConnectionFactory dataSourceConnectionFactory;
    @Autowired
    private TranslatorWrapper translatorWrapper;

    @Transactional
    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ConnectionConfigDto> getInternalConnections(@RequestParam(required=false) String query, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, SortDto sort) {
        CountedResult<ConnectionConfiguration> countedConnectionConfiguration = this.connectionService.getInternalConnections(query, sort.getSorter(), start, limit);
        return this.buildCountedConnectionConfigDto(countedConnectionConfiguration);
    }

    @Transactional
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ConnectionConfigDto> getAllConnections(@RequestParam(required=false) String query, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, SortDto sort) {
        CountedResult<ConnectionConfiguration> countedConnectionConfiguration = this.connectionService.getAllConnections(query, sort.getSorter(), start, limit);
        return this.buildCountedConnectionConfigDto(countedConnectionConfiguration);
    }

    @Transactional
    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public RestResult createConnection(@RequestBody ConnectionConfigDto connection) {
        if (this.connectionService.getConnection(connection.getId()) != null) {
            return new RestResult(false, this.translatorWrapper.getMessage("jdbcDatasource.connectionExists", connection.getId()));
        }
        this.connectionService.saveConnection(connection.getConnectionConfiguration());
        return new RestResult(true, this.translatorWrapper.getMessage("jdbcDatasource.connectionCreated"));
    }

    @Transactional
    @RequestMapping(value={"{connectionId}"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult modifyConnection(@PathVariable String connectionId, @RequestBody ConnectionConfigDto modifiedConnection) {
        ConnectionConfiguration connection = this.connectionService.getConnection(connectionId);
        if (connection == null) {
            return new RestResult(false, this.translatorWrapper.getMessage("jdbcDatasource.connectionNotExists", connectionId));
        }
        this.connectionService.updateConnection(modifiedConnection.getConnectionConfiguration());
        return new RestResult(true, this.translatorWrapper.getMessage("jdbcDatasource.connectionModified"));
    }

    @Transactional
    @RequestMapping(value={"{connectionId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteConnection(@PathVariable String connectionId) {
        ConnectionConfiguration connection = this.connectionService.getConnection(connectionId);
        if (connection != null) {
            this.connectionService.deleteConnection(connection);
        }
        return new RestResult(true, this.translatorWrapper.getMessage("jdbcDatasource.connectionDeleted"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"test"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult testConnection(@RequestBody ConnectionConfigDto connectionConfigDto) {
        try {
            DataSource dataSource = this.dataSourceFactory.getDataSource(connectionConfigDto.getConnectionConfiguration());
            try (Connection connection = dataSource.getConnection();){
                if (connection == null) {
                    throw new Exception("Invalid connection url [" + connectionConfigDto.getUrl() + "].");
                }
                RestResult restResult = new RestResult(true, this.translatorWrapper.getMessage("jdbcDatasource.connectionEstablished"));
                return restResult;
            }
        }
        catch (ClassNotFoundException e) {
            return new RestResult(false, this.translatorWrapper.getMessage("jdbcDatasource.driverNotExists", connectionConfigDto.getDriverClassName()));
        }
        catch (InvalidDriverException e) {
            return new RestResult(false, this.translatorWrapper.getMessage("jdbcDatasource.invalidDriverClass", connectionConfigDto.getDriverClassName()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new RestResult(false, this.translatorWrapper.getMessage("jdbcDatasource.connectionFailed"));
        }
    }

    @RequestMapping(value={"{connectionId}/test"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult testConnection(@PathVariable String connectionId) throws SQLException {
        try (ConnectionWrapper connectionDto = this.dataSourceConnectionFactory.getDataSourceConnection(connectionId);){
            RestResult restResult = connectionDto.getConnection().isValid(100) ? new RestResult(true, this.translatorWrapper.getMessage("jdbcDatasource.connectionEstablished")) : new RestResult(false, this.translatorWrapper.getMessage("jdbcDatasource.connectionFailed", connectionId));
            return restResult;
        }
    }

    @RequestMapping(value={"driver/upload/{driverClass}"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult importDeclarations(@PathVariable String driverClass, @RequestParam MultipartFile file) {
        try (InputStream inputStream = file.getInputStream();){
            this.driverLoader.addDriver(inputStream, driverClass);
        }
        catch (InvalidDriverException e) {
            return new RestResult(false, this.translatorWrapper.getMessage("jdbcDatasource.invalidDriverFile"));
        }
        catch (Exception e) {
            log.error("Could not load driver: {}", (Object)e.getMessage(), (Object)e);
            return new RestResult(false, this.translatorWrapper.getMessage("jdbcDatasource.invalidDriverFile"));
        }
        return new RestResult(true, this.translatorWrapper.getMessage("jdbcDatasource.driverFileUploaded"));
    }

    @RequestMapping(value={"driver/check/{driverClass}"}, method={RequestMethod.GET})
    @ResponseBody
    public RestResult checkDriver(@PathVariable String driverClass) {
        boolean driverExists = this.driverLoader.isDriverLoaded(driverClass);
        return new RestResult(driverExists);
    }

    private CountedResult<ConnectionConfigDto> buildCountedConnectionConfigDto(CountedResult<ConnectionConfiguration> countedConnectionConfiguration) {
        List data = countedConnectionConfiguration.getData().stream().map(ConnectionConfigDto::build).collect(Collectors.toList());
        return new CountedResult(countedConnectionConfiguration.getTotal(), data);
    }

    @RequestMapping(value={"wayOfGenerateKeys"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getWayOfGenerateKeys() {
        List listOfMaps = WayOfGenerateKeys.stream().map(enumValue -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", enumValue.getKey());
            map.put("display", this.translatorWrapper.getMessage(enumValue.getTranslation()));
            return map;
        }).collect(Collectors.toList());
        return new CountedResult((long)listOfMaps.size(), listOfMaps);
    }
}

