/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.jdbc.web.connection;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.plusmpm.security.TextCipher;
import com.suncode.plugin.datasource.jdbc.component.enums.WayOfGenerateKeys;
import com.suncode.plugin.datasource.jdbc.db.ConnectionConfiguration;
import com.suncode.plugin.datasource.jdbc.web.connection.OnOffBooleanDeserializer;
import com.suncode.plugin.datasource.jdbc.web.connection.OnOffBooleanSerializer;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class ConnectionConfigDto {
    private String id;
    private String name;
    private String description;
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private WayOfGenerateKeys wayOfGenerateKeys;
    @JsonSerialize(using=OnOffBooleanSerializer.class, as=Boolean.class)
    @JsonDeserialize(using=OnOffBooleanDeserializer.class, as=Boolean.class)
    private Boolean disableAutoGeneratedKeys;

    public static ConnectionConfigDto build(ConnectionConfiguration connectionConfiguration) {
        boolean disableAutoGeneratedKeysValue = BooleanUtils.isTrue((Boolean)connectionConfiguration.getDisableAutoGeneratedKeys());
        WayOfGenerateKeys wayOfGenerateKeys = connectionConfiguration.getWayOfGenerateKeys();
        if (wayOfGenerateKeys == null) {
            wayOfGenerateKeys = disableAutoGeneratedKeysValue ? WayOfGenerateKeys.NO_GENERATED_KEYS : WayOfGenerateKeys.RETURN_GENERATED_KEYS;
        }
        return ConnectionConfigDto.builder().description(connectionConfiguration.getDescription()).disableAutoGeneratedKeys(disableAutoGeneratedKeysValue).driverClassName(connectionConfiguration.getDriverClassName()).id(connectionConfiguration.getId()).name(connectionConfiguration.getName()).username(connectionConfiguration.getUsername()).password(StringUtils.isBlank((CharSequence)connectionConfiguration.getPassword()) ? null : TextCipher.decrypt((String)connectionConfiguration.getPassword())).url(connectionConfiguration.getUrl()).wayOfGenerateKeys(wayOfGenerateKeys).build();
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration();
        connectionConfiguration.setDescription(this.description);
        connectionConfiguration.setDisableAutoGeneratedKeys(this.disableAutoGeneratedKeys != null && this.disableAutoGeneratedKeys != false);
        connectionConfiguration.setDriverClassName(this.driverClassName);
        connectionConfiguration.setId(this.id);
        connectionConfiguration.setName(this.name);
        connectionConfiguration.setUsername(this.username);
        connectionConfiguration.setPassword(StringUtils.isBlank((CharSequence)this.password) ? null : TextCipher.encrypt((String)this.password));
        connectionConfiguration.setUrl(this.url);
        connectionConfiguration.setWayOfGenerateKeys(this.wayOfGenerateKeys);
        return connectionConfiguration;
    }

    private static Boolean $default$disableAutoGeneratedKeys() {
        return false;
    }

    @ConstructorProperties(value={"id", "name", "description", "driverClassName", "url", "username", "password", "wayOfGenerateKeys", "disableAutoGeneratedKeys"})
    ConnectionConfigDto(String id, String name, String description, String driverClassName, String url, String username, String password, WayOfGenerateKeys wayOfGenerateKeys, Boolean disableAutoGeneratedKeys) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.driverClassName = driverClassName;
        this.url = url;
        this.username = username;
        this.password = password;
        this.wayOfGenerateKeys = wayOfGenerateKeys;
        this.disableAutoGeneratedKeys = disableAutoGeneratedKeys;
    }

    public static ConnectionConfigDtoBuilder builder() {
        return new ConnectionConfigDtoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public WayOfGenerateKeys getWayOfGenerateKeys() {
        return this.wayOfGenerateKeys;
    }

    public Boolean getDisableAutoGeneratedKeys() {
        return this.disableAutoGeneratedKeys;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setWayOfGenerateKeys(WayOfGenerateKeys wayOfGenerateKeys) {
        this.wayOfGenerateKeys = wayOfGenerateKeys;
    }

    public void setDisableAutoGeneratedKeys(Boolean disableAutoGeneratedKeys) {
        this.disableAutoGeneratedKeys = disableAutoGeneratedKeys;
    }

    public static class ConnectionConfigDtoBuilder {
        private String id;
        private String name;
        private String description;
        private String driverClassName;
        private String url;
        private String username;
        private String password;
        private WayOfGenerateKeys wayOfGenerateKeys;
        private boolean disableAutoGeneratedKeys$set;
        private Boolean disableAutoGeneratedKeys;

        ConnectionConfigDtoBuilder() {
        }

        public ConnectionConfigDtoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ConnectionConfigDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ConnectionConfigDtoBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ConnectionConfigDtoBuilder driverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
            return this;
        }

        public ConnectionConfigDtoBuilder url(String url) {
            this.url = url;
            return this;
        }

        public ConnectionConfigDtoBuilder username(String username) {
            this.username = username;
            return this;
        }

        public ConnectionConfigDtoBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ConnectionConfigDtoBuilder wayOfGenerateKeys(WayOfGenerateKeys wayOfGenerateKeys) {
            this.wayOfGenerateKeys = wayOfGenerateKeys;
            return this;
        }

        public ConnectionConfigDtoBuilder disableAutoGeneratedKeys(Boolean disableAutoGeneratedKeys) {
            this.disableAutoGeneratedKeys = disableAutoGeneratedKeys;
            this.disableAutoGeneratedKeys$set = true;
            return this;
        }

        public ConnectionConfigDto build() {
            return new ConnectionConfigDto(this.id, this.name, this.description, this.driverClassName, this.url, this.username, this.password, this.wayOfGenerateKeys, this.disableAutoGeneratedKeys$set ? this.disableAutoGeneratedKeys : ConnectionConfigDto.$default$disableAutoGeneratedKeys());
        }

        public String toString() {
            return "ConnectionConfigDto.ConnectionConfigDtoBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", driverClassName=" + this.driverClassName + ", url=" + this.url + ", username=" + this.username + ", password=" + this.password + ", wayOfGenerateKeys=" + (Object)((Object)this.wayOfGenerateKeys) + ", disableAutoGeneratedKeys=" + this.disableAutoGeneratedKeys + ")";
        }
    }
}

