/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.jdbc.update;

import com.google.common.collect.Sets;
import com.suncode.plugin.datasource.jdbc.common.JdbcDatasourcesUtils;
import com.suncode.plugin.datasource.jdbc.connection.DataSourceFactory;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.datasource.AbstractDataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceParameter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class JdbcUpdateDataSource
extends AbstractDataSourceInstance {
    private static final Logger log = LoggerFactory.getLogger(JdbcUpdateDataSource.class);
    private DataSourceFactory dataSourceFactory;
    private String connection;
    private String query;
    private List<String> rawQueryParameters;
    private Map<String, DataSourceParameter> parameters;

    public JdbcUpdateDataSource(Parameters parameters, DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
        this.connection = (String)parameters.get("connection");
        this.rawQueryParameters = JdbcDatasourcesUtils.readParametersFromQuery((String)parameters.get("query"));
        this.query = JdbcDatasourcesUtils.getQueryWithFormattedParameters((String)parameters.get("query"), this.rawQueryParameters);
        this.parameters = JdbcDatasourcesUtils.buildParameters(parameters, Collections.singletonList(this.rawQueryParameters));
    }

    public void update(Map<String, Object> data) {
        Map<String, String> values = JdbcDatasourcesUtils.prepareValuesMap(data);
        JdbcDatasourcesUtils.logQueries(log, this.query, values, this.rawQueryParameters);
        DataSource dataSource = this.dataSourceFactory.getDataSource(this.connection);
        try (Connection conn = dataSource.getConnection();){
            Assert.notNull((Object)conn, (String)"Could not connect to database. Check configuration.");
            PreparedStatement preparedStatement = conn.prepareStatement(this.query);
            JdbcDatasourcesUtils.setStatementParameters(preparedStatement, this.rawQueryParameters, values, this.parameters);
            preparedStatement.executeUpdate();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Set<DataSourceParameter> getInputParameters() {
        return Sets.newLinkedHashSet(this.parameters.values());
    }

    public Set<DataSourceParameter> getOutputParameters() {
        return new HashSet<DataSourceParameter>();
    }
}

