/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.jdbc.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.suncode.plugin.datasource.jdbc.common.JdbcDatasourcesUtils;
import com.suncode.plugin.datasource.jdbc.connection.DataSourceFactory;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.datasource.AbstractDataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceParameter;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.util.PaginatedList;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcQueryDataSource
extends AbstractDataSourceInstance {
    private static final Logger log = LoggerFactory.getLogger(JdbcQueryDataSource.class);
    private DataSourceFactory dataSourceFactory;
    private String connection;
    private String query;
    private String countQuery;
    private List<String> rawQueryParameters;
    private List<String> rawCountQueryParameters;
    private Map<String, DataSourceParameter> parameters;
    private Set<DataSourceParameter> resultColumns;

    public JdbcQueryDataSource(Parameters parameters, DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
        this.connection = (String)parameters.get("connection");
        this.rawQueryParameters = JdbcDatasourcesUtils.readParametersFromQuery((String)parameters.get("query"));
        this.rawCountQueryParameters = JdbcDatasourcesUtils.readParametersFromQuery((String)parameters.get("countQuery"));
        this.query = JdbcDatasourcesUtils.getQueryWithFormattedParameters((String)parameters.get("query"), this.rawQueryParameters);
        this.countQuery = JdbcDatasourcesUtils.getQueryWithFormattedParameters((String)parameters.get("countQuery"), this.rawCountQueryParameters);
        this.parameters = JdbcDatasourcesUtils.buildParameters(parameters, Arrays.asList(this.rawQueryParameters, this.rawCountQueryParameters));
        this.resultColumns = this.buildResultColumns(parameters);
    }

    /*
     * Exception decompiling
     */
    public CountedResult<Map<String, Object>> getCountedData(Map<String, String> values, Map<String, String> filters, Pagination pagination) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 10 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Pagination ensurePagination(Pagination pagination) {
        if (pagination == null) {
            pagination = Pagination.create((Sorter)new Sorter("1"), (Integer)0, (Integer)Integer.MAX_VALUE);
        }
        if (pagination.getLimit() <= 0) {
            pagination.setLimit(Integer.valueOf(Integer.MAX_VALUE));
        }
        return pagination;
    }

    private String applyPredefinedParametersToQuery(Pagination pagination) {
        String query = this.applyPaginationToQuery(pagination);
        query = this.applyLoggedUserParam(query);
        return query;
    }

    private String applyPaginationToQuery(Pagination pagination) {
        return this.query.replace("{orderProperty}", pagination.getSorter().getProperty()).replace("{orderDirection}", pagination.getSorter().getDirection().name()).replace("{start}", pagination.getStart().toString()).replace("{limit}", pagination.getLimit().toString());
    }

    private String applyLoggedUserParam(String query) {
        String loggedUser = "''";
        if (UserContext.isActive()) {
            loggedUser = "'" + UserContext.current().getUser().getUserName() + "'";
        }
        return query.replace("{loggedUser}", loggedUser);
    }

    private List<Map<String, Object>> applyPaginationToResultIfNeeded(List<Map<String, Object>> result, Pagination pagination) {
        if (result.size() > pagination.getLimit()) {
            PaginatedList paginated = new PaginatedList(result, pagination.getLimit());
            return paginated.getRange(pagination.getStart());
        }
        return result;
    }

    private List<Map<String, Object>> resultSetToListOfMap(ResultSet rs) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int columns = md.getColumnCount();
        ArrayList list = Lists.newArrayList();
        while (rs.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>(columns);
            for (int i = 1; i <= columns; ++i) {
                row.put(md.getColumnName(i), JdbcDatasourcesUtils.extractResultSetValue(rs, i));
            }
            list.add(row);
        }
        return list;
    }

    private Set<DataSourceParameter> buildResultColumns(Parameters parameters) {
        String[] ids = (String[])parameters.get("queryResultColumnsId");
        String[] names = (String[])parameters.get("queryResultColumnsName");
        LinkedHashSet resultColumns = Sets.newLinkedHashSet();
        for (int i = 0; i < ids.length; ++i) {
            resultColumns.add(new DataSourceParameter(ids[i], names[i]));
        }
        return resultColumns;
    }

    public Set<DataSourceParameter> getInputParameters() {
        return Sets.newLinkedHashSet(this.parameters.values());
    }

    public Set<DataSourceParameter> getOutputParameters() {
        return this.resultColumns;
    }

    private void logQueries(String query, String countQuery, Map<String, String> values) {
        log.debug("Query to invoke: " + query);
        log.debug("Parameters for query: " + String.join((CharSequence)", ", this.getValuesForQuery(this.rawQueryParameters, values)));
        log.debug("Count query to invoke: " + countQuery);
        log.debug("Parameters for query: " + String.join((CharSequence)", ", this.getValuesForQuery(this.rawCountQueryParameters, values)));
    }

    private List<String> getValuesForQuery(List<String> rawParameters, Map<String, String> allValues) {
        ArrayList<String> values = new ArrayList<String>();
        rawParameters.forEach(rawParameter -> values.add((String)allValues.get(rawParameter)));
        return values;
    }
}

