/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.jdbc.db;

import com.suncode.plugin.datasource.jdbc.component.enums.WayOfGenerateKeys;
import com.suncode.plugin.datasource.jdbc.db.ConnectionConfiguration;
import com.suncode.plugin.datasource.jdbc.db.ConnectionDao;
import com.suncode.plugin.datasource.jdbc.db.ConnectionService;
import com.suncode.pwfl.dbconfig.DatabaseConnectionConfigEntry;
import com.suncode.pwfl.dbconfig.DatabaseConnectionConfigService;
import com.suncode.pwfl.plugin.modules.dbconfig.DatabaseConnectionConfig;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.support.hibernate.criterion.Criterion;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import com.suncode.pwfl.util.BaseFinderImpl;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="connectionService")
@Transactional
public class ConnectionServiceImpl
extends BaseFinderImpl<ConnectionConfiguration, String, ConnectionDao>
implements ConnectionService {
    @Autowired
    private DatabaseConnectionConfigService databaseConnectionConfigService;
    @Autowired
    private ConnectionDao connectionDao;

    @Override
    public CountedResult<ConnectionConfiguration> getInternalConnections(String query, Sorter sorter, Integer start, Integer limit) {
        HibernateCriteria dc = HibernateCriteria.forClass(ConnectionConfiguration.class);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            dc.add((Criterion)Restrictions.disjunction().add(Restrictions.ilike((String)"id", (Object)("%" + query + "%"))).add(Restrictions.ilike((String)"name", (Object)("%" + query + "%"))));
        }
        List list = this.connectionDao.findByCriteria(dc, start, limit);
        CountedResult result = new CountedResult();
        result.setData(list);
        result.setTotal((long)list.size());
        return result;
    }

    @Override
    public CountedResult<ConnectionConfiguration> getAllConnections(String query, Sorter sorter, Integer start, Integer limit) {
        CountedResult<ConnectionConfiguration> internalConnections = this.getInternalConnections(query, sorter, start, limit);
        List connectionEntries = this.databaseConnectionConfigService.getConfigs();
        LinkedList externalConnections = new LinkedList();
        connectionEntries.forEach(connectionEntry -> connectionEntry.getConfigs().forEach(connectionConfig -> externalConnections.add(this.buildExternalConnectionConfiguration((DatabaseConnectionConfigEntry)connectionEntry, (DatabaseConnectionConfig)connectionConfig))));
        List allConfigurations = Stream.concat(internalConnections.getData().stream(), externalConnections.stream()).collect(Collectors.toList());
        return new CountedResult((long)allConfigurations.size(), allConfigurations);
    }

    private ConnectionConfiguration buildExternalConnectionConfiguration(DatabaseConnectionConfigEntry connectionEntry, DatabaseConnectionConfig connectionConfig) {
        ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration();
        connectionConfiguration.setId(connectionEntry.getPluginId() + "&" + connectionEntry.getId() + "&" + connectionConfig.getId());
        connectionConfiguration.setName("Data editor -> " + connectionConfig.getName());
        return connectionConfiguration;
    }

    @Override
    public ConnectionConfiguration getConnection(String id) {
        ConnectionConfiguration configuration = (ConnectionConfiguration)this.connectionDao.get((Serializable)((Object)id));
        if (configuration == null) {
            return null;
        }
        return configuration;
    }

    @Override
    public void saveConnection(ConnectionConfiguration connection) {
        this.connectionDao.save(connection);
    }

    @Override
    public void updateConnection(ConnectionConfiguration connection) {
        this.connectionDao.merge(connection);
    }

    @Override
    public void deleteConnection(ConnectionConfiguration connection) {
        this.connectionDao.delete(connection);
    }

    @Override
    public Boolean hasDisableAutoGeneratedKeys(String connectionId) {
        ConnectionConfiguration configuration = this.getConnection(connectionId);
        if (configuration == null) {
            throw new IllegalArgumentException("Connection configuration not found by id " + connectionId);
        }
        return configuration.getDisableAutoGeneratedKeys() != null && configuration.getDisableAutoGeneratedKeys() != false;
    }

    @Override
    public WayOfGenerateKeys getWayOfGenerateKeys(String connectionId) {
        return this.getConnection(connectionId).getWayOfGenerateKeys();
    }
}

