/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.jdbc.connection;

import com.suncode.plugin.datasource.jdbc.exception.InvalidDriverException;
import com.suncode.plugin.framework.PluginStore;
import com.suncode.plugin.framework.PluginStoreResource;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class JdbcDriversLoader
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(JdbcDriversLoader.class);
    @Autowired
    private PluginStore store;
    private final Map<String, Driver> loadedBundleDrivers = new ConcurrentHashMap<String, Driver>();
    private final Map<String, URLClassLoader> classLoaders = new ConcurrentHashMap<String, URLClassLoader>();

    public void afterPropertiesSet() {
        this.loadAllDriversIntoBundle();
    }

    public void destroy() {
        this.closeClassLoaders();
    }

    private void loadAllDriversIntoBundle() {
        Map resources = this.store.getStoredResources();
        resources.forEach((path, resource) -> {
            try {
                this.loadDriver(this.createJarURL((PluginStoreResource)resource), path.replace(".jar", ""));
                log.info("Driver successfully loaded: {}", path);
            }
            catch (Exception e) {
                log.error("Failed to load driver from resource {}", (Object)resource.getAbsolutePath(), (Object)e);
            }
        });
    }

    private void loadDriver(URL driverJarUrl, String driverClassName) throws Exception {
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{driverJarUrl}, this.getClass().getClassLoader());
        Class<?> driverClass = urlClassLoader.loadClass(driverClassName);
        if (!Driver.class.isAssignableFrom(driverClass)) {
            throw new InvalidDriverException(driverClassName);
        }
        Driver driverInstance = (Driver)driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.loadedBundleDrivers.put(driverClassName, driverInstance);
        this.classLoaders.put(driverClassName, urlClassLoader);
        log.info("Driver loaded: {}", (Object)driverClass.getName());
    }

    public void addDriver(InputStream inputStream, String path) {
        if (this.loadedBundleDrivers.containsKey(path)) {
            log.warn("Driver already loaded for path: {}", (Object)path);
            return;
        }
        try {
            PluginStoreResource driverResource = this.store.store(path + ".jar", inputStream, true);
            this.loadDriver(this.createJarURL(driverResource), path);
        }
        catch (Exception e) {
            log.error("Failed to load driver at runtime for path: {}", (Object)path, (Object)e);
        }
    }

    public boolean isDriverLoaded(String driverClassName) {
        try {
            this.getDriver(driverClassName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Class<? extends Driver> getDriver(String driverClassName) throws InvalidDriverException {
        if (this.isDriverInSystemClasspath(driverClassName)) {
            return this.getDriverClassFromSystem(driverClassName);
        }
        if (this.loadedBundleDrivers.containsKey(driverClassName)) {
            return this.loadedBundleDrivers.get(driverClassName).getClass();
        }
        throw new InvalidDriverException(driverClassName);
    }

    private void closeClassLoaders() {
        this.classLoaders.forEach((path, classLoader) -> {
            try {
                classLoader.close();
                log.info("ClassLoader for {} successfully closed.", path);
            }
            catch (Exception e) {
                log.error("Failed to close ClassLoader for: {}", path, (Object)e);
            }
        });
    }

    private URL createJarURL(PluginStoreResource driverResource) throws MalformedURLException {
        return new URL("jar:file:" + driverResource.getAbsolutePath() + "!/");
    }

    private boolean isDriverInSystemClasspath(String driverClass) {
        try {
            Class.forName(driverClass, true, ClassUtils.getDefaultClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Class<? extends Driver> getDriverClassFromSystem(String driverClassName) {
        Class<?> driverClass = Class.forName(driverClassName, true, ClassUtils.getDefaultClassLoader());
        if (!Driver.class.isAssignableFrom(driverClass)) {
            throw new InvalidDriverException(driverClassName);
        }
        return driverClass;
    }
}

