/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.jdbc.connection;

import com.plusmpm.security.TextCipher;
import com.suncode.plugin.datasource.jdbc.common.JdbcDatasourcesUtils;
import com.suncode.plugin.datasource.jdbc.connection.JdbcDriversLoader;
import com.suncode.plugin.datasource.jdbc.db.ConnectionConfiguration;
import com.suncode.plugin.datasource.jdbc.db.ConnectionService;
import com.suncode.plugin.datasource.jdbc.exception.ConnectionNotExistsException;
import com.suncode.plugin.datasource.jdbc.exception.InvalidConnectionException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.stereotype.Component;

@Component
public class DataSourceFactory {
    private static final Logger log = LoggerFactory.getLogger(DataSourceFactory.class);
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private JdbcDriversLoader jdbcDriversLoader;

    public DataSource getDataSource(String connectionId) {
        ConnectionConfiguration connection = this.connectionService.getConnection(connectionId);
        if (connection == null) {
            throw new ConnectionNotExistsException("Connection [" + connectionId + "] does not exist in database.");
        }
        try {
            return this.getDataSource(connection);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new InvalidConnectionException("Could not prepare data source", e);
        }
    }

    public DataSource getDataSource(ConnectionConfiguration connection) throws Exception {
        SimpleDriverDataSource dataSource = new SimpleDriverDataSource();
        String resolvedUrl = JdbcDatasourcesUtils.resolveSqlServerConnectionUrl(connection.getUrl());
        dataSource.setUrl(resolvedUrl);
        dataSource.setUsername(connection.getUsername());
        dataSource.setPassword(TextCipher.decrypt((String)connection.getPassword()));
        dataSource.setDriverClass(this.jdbcDriversLoader.getDriver(connection.getDriverClassName()));
        return dataSource;
    }
}

