/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.jdbc.connection;

import com.suncode.plugin.datasource.jdbc.common.JdbcDatasourcesUtils;
import com.suncode.plugin.datasource.jdbc.connection.ConnectionWrapper;
import com.suncode.plugin.datasource.jdbc.connection.DataSourceFactory;
import com.suncode.plugin.datasource.jdbc.connection.ExternalConnectionIdHolder;
import com.suncode.pwfl.dbconfig.DatabaseConnectionConfigEntry;
import com.suncode.pwfl.dbconfig.DatabaseConnectionConfigService;
import com.suncode.pwfl.plugin.modules.dbconfig.DatabaseConnectionConfig;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import javax.naming.directory.InvalidAttributeValueException;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataSourceConnectionFactory {
    @Autowired
    private DataSourceFactory dataSourceFactory;
    @Autowired
    private DatabaseConnectionConfigService databaseConnectionConfigService;

    public ConnectionWrapper getDataSourceConnection(String connectionId) throws SQLException {
        try {
            return new ConnectionWrapper(this.getExternalDataSourceConnection(connectionId), false);
        }
        catch (InvalidAttributeValueException ex) {
            return new ConnectionWrapper(this.getInternalDataSourceConnection(connectionId), true);
        }
    }

    private Connection getExternalDataSourceConnection(String connectionId) throws SQLException, InvalidAttributeValueException {
        ExternalConnectionIdHolder idHolder = new ExternalConnectionIdHolder(connectionId);
        List connectionEntries = this.databaseConnectionConfigService.getConfigsByPluginId(idHolder.getPluginId());
        if (connectionEntries.isEmpty()) {
            throw new RuntimeException("There are no registered database connections in plugin: " + idHolder.getPluginId() + "!");
        }
        DatabaseConnectionConfigEntry connectionConfigEntry = connectionEntries.stream().filter(connectionEntry -> connectionEntry.getId().equals(idHolder.getEntryId())).findFirst().orElseThrow(() -> new RuntimeException("There are no registered database connections in plugin: " + idHolder.getPluginId() + "!"));
        DatabaseConnectionConfig connectionConfig = connectionConfigEntry.getConfigs().stream().filter(connection -> connection.getId().equals(idHolder.getConfigId())).findFirst().orElseThrow(() -> new RuntimeException("No connection with id: '" + idHolder.getConfigId() + "' registred in plugin " + idHolder.getPluginId() + "!"));
        String resolvedUrl = JdbcDatasourcesUtils.resolveSqlServerConnectionUrl(connectionConfig.getJdbcUrl());
        return DriverManager.getConnection(resolvedUrl, connectionConfig.getUsername(), connectionConfig.getPassword());
    }

    private Connection getInternalDataSourceConnection(String connectionId) throws SQLException {
        DataSource datasource = this.dataSourceFactory.getDataSource(connectionId);
        return datasource.getConnection();
    }
}

